/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.framework.i18n;

import com.ygsoft.ecp.framework.i18n.CommonResourceLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class BundleMessageSource
extends ReloadableResourceBundleMessageSource {
    private String locationPattern = "classpath*:/META-INF/ecp-i18n/*.properties";
    private String location;
    private static final String I18N_PATH_SIGN = "ecp-i18n";

    public String getLocationPattern() {
        return this.locationPattern;
    }

    public void setLocationPattern(String newLocationPattern) {
        this.locationPattern = newLocationPattern;
        this.location = this.locationPattern.replaceAll("\\*", "");
        this.location = this.location.substring(0, this.location.lastIndexOf("/") + 1);
    }

    @PostConstruct
    public void init() throws Exception {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        Resource[] resources = resolver.getResources(this.locationPattern);
        HashMap<String, String> fileNames = new HashMap<String, String>();
        for (Resource resource : resources) {
            String url = resource.toString();
            String fileName = url.substring(url.lastIndexOf("/") + 1);
            if (fileNames.containsKey(fileName)) {
                this.logger.error((Object)("Resource file [" + url + "] dup with [" + (String)fileNames.get(fileName)));
            }
            fileNames.put(fileName, url);
        }
        Set fNames = fileNames.keySet();
        ArrayList<String> baseNames = new ArrayList<String>();
        for (String fname : fNames) {
            int i18nIndex = fname.indexOf(I18N_PATH_SIGN) + I18N_PATH_SIGN.length();
            String baseName = fname.substring(0, fname.lastIndexOf("."));
            if (baseName.indexOf("_", i18nIndex) > 0) {
                baseName = baseName.substring(0, baseName.indexOf("_", i18nIndex));
            }
            if (baseNames.contains(baseName = this.location + baseName)) continue;
            baseNames.add(baseName);
        }
        this.logger.info((Object)("All base names parsed from " + this.locationPattern + " is " + ((Object)baseNames).toString() + "."));
        super.setBasenames(baseNames.toArray(new String[0]));
        super.setResourceLoader((ResourceLoader)new CommonResourceLoader());
    }
}

