/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.framework.i18n;

import java.util.Locale;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public final class LocaleHolder {
    private final ThreadLocal<Locale> LOCALE = new ThreadLocal();
    public static final LocaleHolder INSTANCE = new LocaleHolder();

    private LocaleHolder() {
    }

    public Locale getLocale() {
        return this.LOCALE.get() == null ? Locale.SIMPLIFIED_CHINESE : this.LOCALE.get();
    }

    public void setLocale(Locale locale) {
        this.LOCALE.set(locale);
    }

    public void setLocale(HttpServletRequest httpRequest) {
        Cookie[] cookies;
        String language = httpRequest.getHeader("ecp_locale");
        if (language == null || language.trim().length() == 0) {
            language = httpRequest.getParameter("ecp_locale");
        }
        if ((language == null || language.trim().length() == 0) && (cookies = httpRequest.getCookies()) != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!"ecp_locale".equalsIgnoreCase(cookies[i].getName())) continue;
                language = cookies[i].getValue();
                break;
            }
        }
        if (language != null && language.trim().length() > 0) {
            String[] srcLanguage = new String[]{"zh", "cn"};
            if (language != null && language.indexOf("-") != -1) {
                srcLanguage = language.split("-");
            }
            String[] ecp_locale = srcLanguage;
            Locale locale = new Locale(ecp_locale[0], ecp_locale[1]);
            this.setLocale(locale);
        }
    }

    public void clearLocale() {
        this.LOCALE.remove();
    }
}

