/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.framework.util;

import com.ygsoft.ecp.framework.util.ResourceUtil;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.IOUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassUtil {
    private static final Map<String, List<Object>> SERVICES_CACHE = new ConcurrentHashMap<String, List<Object>>();
    private static final Set<Class<?>> BASE_CLASS = new HashSet();
    private static Map<String, Map> instanceCache;
    private static final String SERVICES_CONFIG_PATH = "classpath*:/META-INF/services/";
    private static final Object[] EMPTYARGS;

    private static Class<?> getActualGenericType(Type superType, int index) {
        if (superType instanceof ParameterizedType) {
            Type[] types = ((ParameterizedType)superType).getActualTypeArguments();
            Type type = types[index];
            if (type instanceof ParameterizedType) {
                type = ((ParameterizedType)type).getRawType();
            }
            if (type instanceof Class) {
                return (Class)type;
            }
        }
        return null;
    }

    public static Class<?>[] getActualGenericTypes(Class<?> clazz) {
        Type superClass = clazz.getGenericSuperclass();
        return ClassUtil.getActualGenericTypes(superClass);
    }

    public static Class<?>[] getActualGenericTypes(Class<?> clazz, Class<?> interfaceClass) {
        Type[] types = clazz.getGenericInterfaces();
        ParameterizedType superInterface = ClassUtil.getMatchedGenericType(types, interfaceClass);
        return ClassUtil.getActualGenericTypes(superInterface);
    }

    private static ParameterizedType getMatchedGenericType(Type[] types, Class<?> interfaceClass) {
        for (Type type : types) {
            ParameterizedType pt;
            if (!(type instanceof ParameterizedType) || !(pt = (ParameterizedType)type).getRawType().equals(interfaceClass)) continue;
            return pt;
        }
        return null;
    }

    private static Class<?>[] getActualGenericTypes(Type superType) {
        if (superType instanceof ParameterizedType) {
            Type[] types = ((ParameterizedType)superType).getActualTypeArguments();
            Class[] classes = new Class[types.length];
            for (int i = 0; i < types.length; ++i) {
                Type type = types[i];
                if (type instanceof ParameterizedType) {
                    type = ((ParameterizedType)type).getRawType();
                }
                classes[i] = type instanceof Class ? (Class)type : null;
            }
            return classes;
        }
        return new Class[0];
    }

    public static Class<?> getAcutalGenericType(Class<?> clazz, Class<?> interfaceClass, int index) {
        Type[] types = clazz.getGenericInterfaces();
        ParameterizedType superInterface = ClassUtil.getMatchedGenericType(types, interfaceClass);
        return ClassUtil.getActualGenericType(superInterface, index);
    }

    public static Class<?> getAcutalGenericType(Class<?> clazz, int index) {
        Type superClass = clazz.getGenericSuperclass();
        return ClassUtil.getActualGenericType(superClass, index);
    }

    public static Class<?> getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Class<?>[] getClass(Object[] instances) {
        Class[] cls = new Class[instances.length];
        Object obj = null;
        for (int i = 0; i < instances.length; ++i) {
            obj = instances[i];
            cls[i] = obj != null ? obj.getClass() : Object.class;
        }
        return cls;
    }

    public static Object createObject(Class<?> cls) {
        try {
            return cls.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object createObject(String className) {
        try {
            Class<?> cls = ClassUtil.getClass(className);
            if (cls != null) {
                return cls.newInstance();
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Method getMethod(Object obj, String methodName, Class<?>[] pTypes) {
        if (obj == null) {
            return null;
        }
        return ClassUtils.getMethod(obj.getClass(), (String)methodName, (Class[])pTypes);
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?>[] pTypes) {
        return ClassUtils.getMethod(clazz, (String)methodName, (Class[])pTypes);
    }

    public static Field getClassField(Class<?> clazz, String name) {
        Field field;
        int i;
        Field fld = null;
        Field[] fields = clazz.getFields();
        for (i = 0; i < fields.length; ++i) {
            field = fields[i];
            if (!field.getName().equals(name)) continue;
            fld = field;
            break;
        }
        if (fld == null) {
            fields = clazz.getDeclaredFields();
            for (i = 0; i < fields.length; ++i) {
                field = fields[i];
                if (!field.getName().equals(name)) continue;
                fld = field;
                break;
            }
        }
        return fld;
    }

    public static Object getFieldValue(Object obj, String name) {
        if (obj == null) {
            return null;
        }
        Field fld = ClassUtil.getClassFieldIncludeSuperClass(obj.getClass(), name);
        if (fld != null) {
            try {
                fld.setAccessible(true);
                return fld.get(obj);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static void setFieldValue(Object obj, String name, String value) {
        if (obj == null) {
            return;
        }
        Method md = null;
        PropertyDescriptor pd = ClassUtil.getPropertyDescriptor(obj, name);
        if (pd != null) {
            md = pd.getWriteMethod();
        }
        if ((md = null) != null) {
            try {
                md.invoke(obj, value);
            }
            catch (Exception exception) {}
        } else {
            Field fld = ClassUtil.getClassFieldIncludeSuperClass(obj.getClass(), name);
            if (fld != null) {
                try {
                    fld.setAccessible(true);
                    fld.set(obj, value);
                }
                catch (Exception e) {
                    return;
                }
            }
        }
    }

    public static PropertyDescriptor getPropertyDescriptor(Object instance, String name) {
        return ClassUtil.getPropertyDescriptorByClass(instance.getClass(), name);
    }

    public static PropertyDescriptor getPropertyDescriptorByClass(Class cls, String name) {
        String propName = name.toUpperCase();
        Map map = ClassUtil.getInstancePropertyMap(cls);
        return (PropertyDescriptor)map.get(propName);
    }

    public static Map getInstancePropertyMap(Class cls) {
        try {
            String keyName = cls.getName();
            ConcurrentHashMap<String, PropertyDescriptor> attrsMap = null;
            Map<String, Map> cache = ClassUtil.getInstanceCache();
            if (cache != null) {
                attrsMap = cache.get(keyName);
            }
            if (attrsMap != null) {
                return attrsMap;
            }
            attrsMap = new ConcurrentHashMap<String, PropertyDescriptor>();
            BeanInfo bi = Introspector.getBeanInfo(cls);
            PropertyDescriptor[] ps = bi.getPropertyDescriptors();
            PropertyDescriptor pd = null;
            for (int i = 0; i < ps.length; ++i) {
                pd = ps[i];
                attrsMap.put(pd.getName().toUpperCase(), pd);
            }
            if (cache != null) {
                cache.put(keyName, attrsMap);
            }
            return attrsMap;
        }
        catch (IntrospectionException e) {
            return null;
        }
    }

    private static Map<String, Map> getInstanceCache() {
        if (instanceCache == null) {
            instanceCache = new ConcurrentHashMap<String, Map>();
        }
        return instanceCache;
    }

    public static Field getClassFieldIncludeSuperClass(Class<?> cls, String name) {
        Field fld = ClassUtil.getClassField(cls, name);
        if (fld == null) {
            for (Class<?> parentCls = cls.getSuperclass(); parentCls != null && (fld = ClassUtil.getClassField(parentCls, name)) == null; parentCls = parentCls.getSuperclass()) {
            }
        }
        return fld;
    }

    public static <T> List<T> findObjectByInterface(Class<T> ifc) {
        return ClassUtil.findObjectByInterface(ifc.getName());
    }

    public static <T> List<T> findObjectByInterface(String ifc) {
        if (ifc == null || ifc.isEmpty()) {
            return null;
        }
        if (SERVICES_CACHE.containsKey(ifc)) {
            return SERVICES_CACHE.get(ifc);
        }
        ArrayList<Object> objectList = new ArrayList<Object>();
        List<URL> urls = ResourceUtil.findResources(SERVICES_CONFIG_PATH + ifc);
        for (URL url : urls) {
            try {
                List implClasses = IOUtils.readLines((InputStream)url.openStream(), (String)"UTF-8");
                if (implClasses.isEmpty()) continue;
                for (String implClass : implClasses) {
                    Object obj = ClassUtil.createObject(implClass);
                    if (obj == null) continue;
                    objectList.add(obj);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        SERVICES_CACHE.put(ifc, objectList);
        return objectList;
    }

    public static final boolean isBaseClass(Class<?> clz) {
        return BASE_CLASS.contains(clz);
    }

    public static Constructor<?> findConstructor(Class<?> type, Object ... constructorArguments) {
        Assert.notNull(type, (String)"Target type must not be null!");
        Assert.notNull((Object)constructorArguments, (String)"Constructor arguments must not be null!");
        for (Constructor<?> candidate : type.getDeclaredConstructors()) {
            Class<?>[] parameterTypes = candidate.getParameterTypes();
            if (!ClassUtil.argumentsMatch(parameterTypes, constructorArguments)) continue;
            return candidate;
        }
        return null;
    }

    private static final boolean argumentsMatch(Class<?>[] parameterTypes, Object[] arguments) {
        if (parameterTypes.length != arguments.length) {
            return false;
        }
        int index = 0;
        for (Class<?> argumentType : parameterTypes) {
            Object argument = arguments[index];
            if (argumentType.isPrimitive() && argument == null) {
                return false;
            }
            if (argument != null && !ClassUtils.isAssignableValue(argumentType, (Object)argument)) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public static Object callMethod(Object instance, String methodName, Object[] args) {
        Class<?>[] types;
        Method method;
        if (instance instanceof Class) {
            return ClassUtil.callMethod((Class)instance, methodName, args);
        }
        Object[] callParams = args;
        if (callParams == null) {
            callParams = EMPTYARGS;
        }
        if ((method = ClassUtil.getMethod(instance, methodName, types = ClassUtil.getClass(callParams))) != null) {
            try {
                method.setAccessible(true);
                return method.invoke(instance, callParams);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static Object callMethod(Class cls, String methodName, Object[] args) {
        Class<?>[] types;
        Method method;
        Object[] callParams = args;
        if (callParams == null) {
            callParams = EMPTYARGS;
        }
        if ((method = ClassUtil.getMethod(cls, methodName, types = ClassUtil.getClass(callParams))) != null) {
            try {
                method.setAccessible(true);
                return method.invoke(null, callParams);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    static {
        BASE_CLASS.add(String.class);
        BASE_CLASS.add(Integer.TYPE);
        BASE_CLASS.add(Double.TYPE);
        BASE_CLASS.add(Float.TYPE);
        BASE_CLASS.add(Long.TYPE);
        BASE_CLASS.add(Short.TYPE);
        BASE_CLASS.add(Boolean.TYPE);
        BASE_CLASS.add(Byte.TYPE);
        BASE_CLASS.add(Character.TYPE);
        BASE_CLASS.add(Integer.class);
        BASE_CLASS.add(Double.class);
        BASE_CLASS.add(Float.class);
        BASE_CLASS.add(Long.class);
        BASE_CLASS.add(Short.class);
        BASE_CLASS.add(Boolean.class);
        BASE_CLASS.add(Byte.class);
        BASE_CLASS.add(Character.class);
        EMPTYARGS = new Object[0];
    }
}

