/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.framework.util;

import com.ygsoft.ecp.framework.code.arthas.Decompiler;
import com.ygsoft.ecp.framework.code.arthas.DynamicCompiler;
import com.ygsoft.ecp.framework.code.arthas.SearchUtils;
import com.ygsoft.ecp.framework.util.ClassUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.bytebuddy.agent.ByteBuddyAgent;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CodeUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(CodeUtil.class);
    private static final Instrumentation instrumentation = ByteBuddyAgent.install();
    private static final String compile_dir = System.getProperty("java.io.tmpdir") + "/jtagent/";

    public static byte[] redefineClass(String className, String sourceCode) {
        if (className == null || sourceCode == null) {
            return null;
        }
        if (ClassUtil.getClass(className) == null) {
            return null;
        }
        DynamicCompiler compiler = new DynamicCompiler(ClassUtils.getDefaultClassLoader());
        compiler.addSource(className, sourceCode);
        byte[] javaCode = null;
        try {
            Map<String, byte[]> codes = compiler.buildByteCodes();
            Class<?> clazz = ClassUtils.getDefaultClassLoader().loadClass(className);
            javaCode = codes.get(className);
            if (javaCode == null) {
                return null;
            }
            instrumentation.redefineClasses(new ClassDefinition(clazz, javaCode));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return javaCode;
    }

    public static byte[] redefineClass(String className, byte[] bytes) {
        if (className == null || bytes == null) {
            return null;
        }
        if (ClassUtil.getClass(className) == null) {
            return null;
        }
        try {
            Class<?> clazz = ClassUtils.getDefaultClassLoader().loadClass(className);
            instrumentation.redefineClasses(new ClassDefinition(clazz, bytes));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return bytes;
    }

    public static byte[] redefineMethod(String className, String methodCode) {
        int index;
        String mothodStart;
        if (className == null || methodCode == null) {
            return null;
        }
        if (ClassUtil.getClass(className) == null) {
            return null;
        }
        String sourceCode = CodeUtil.decompileClass(className);
        int start = sourceCode.indexOf(mothodStart = methodCode.substring(0, index = methodCode.indexOf("(")));
        if (start > 0) {
            int end = sourceCode.indexOf("}", start);
            sourceCode = sourceCode.substring(0, start) + methodCode + sourceCode.substring(end + 1);
        }
        DynamicCompiler compiler = new DynamicCompiler(ClassUtils.getDefaultClassLoader());
        compiler.addSource(className, sourceCode);
        byte[] javaCode = null;
        try {
            Map<String, byte[]> codes = compiler.buildByteCodes();
            Class<?> clazz = ClassUtils.getDefaultClassLoader().loadClass(className);
            javaCode = codes.get(className);
            instrumentation.redefineClasses(new ClassDefinition(clazz, javaCode));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return javaCode;
    }

    public static String decompileClass(String className) {
        return CodeUtil.decompileClass(className, null, null);
    }

    public static String decompileClass(String className, String methodName) {
        return CodeUtil.decompileClass(className, methodName, null);
    }

    public static String decompileClass(String className, byte[] byteCode) {
        return CodeUtil.decompileClass(className, null, byteCode);
    }

    public static String decompileClass(String className, String methodName, byte[] byteCode) {
        String string;
        String classFilePath;
        byte[] classBytes;
        block31: {
            if (className == null) {
                return null;
            }
            if (ClassUtil.getClass(className) == null) {
                return null;
            }
            classBytes = null;
            String classFile = className;
            classFilePath = classFile.replace(".", "/") + ".class";
            InputStream inputStream = null;
            if (byteCode == null) {
                try {
                    inputStream = ClassUtils.getDefaultClassLoader().getResourceAsStream(classFilePath);
                    if (inputStream != null) {
                        ByteArrayOutputStream byteArrayOutputStream = null;
                        try {
                            int bytesRead;
                            byteArrayOutputStream = new ByteArrayOutputStream();
                            byte[] buffer = new byte[1024];
                            while ((bytesRead = inputStream.read(buffer)) != -1) {
                                byteArrayOutputStream.write(buffer, 0, bytesRead);
                            }
                            classBytes = byteArrayOutputStream.toByteArray();
                            break block31;
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Error occurred while reading the input stream", e);
                        }
                        finally {
                            if (byteArrayOutputStream != null) {
                                try {
                                    byteArrayOutputStream.close();
                                }
                                catch (IOException ex) {
                                    ex.printStackTrace();
                                }
                            }
                        }
                    }
                    String byteArrayOutputStream = null;
                    return byteArrayOutputStream;
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
            classBytes = byteCode;
        }
        File agentClassFile = null;
        try {
            String agentClassFilePath = compile_dir + classFilePath;
            File dir = new File(compile_dir);
            FileUtils.forceMkdir((File)dir);
            agentClassFile = new File(agentClassFilePath);
            FileUtils.writeByteArrayToFile((File)agentClassFile, (byte[])classBytes);
            string = Decompiler.decompile(agentClassFilePath, methodName, false);
        }
        catch (Throwable e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                FileUtils.deleteQuietly(agentClassFile);
                throw throwable;
            }
        }
        FileUtils.deleteQuietly((File)agentClassFile);
        return string;
    }

    public static boolean reverseClass(String className) {
        byte[] classBytes;
        block26: {
            if (ClassUtil.getClass(className) == null) {
                return false;
            }
            classBytes = null;
            String classFile = className;
            String classFilePath = classFile.replace(".", "/") + ".class";
            InputStream inputStream = null;
            try {
                inputStream = ClassUtils.getDefaultClassLoader().getResourceAsStream(classFilePath);
                if (inputStream != null) {
                    ByteArrayOutputStream byteArrayOutputStream = null;
                    try {
                        int bytesRead;
                        byteArrayOutputStream = new ByteArrayOutputStream();
                        byte[] buffer = new byte[1024];
                        while ((bytesRead = inputStream.read(buffer)) != -1) {
                            byteArrayOutputStream.write(buffer, 0, bytesRead);
                        }
                        classBytes = byteArrayOutputStream.toByteArray();
                        break block26;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("IOException occurred while reading the stream", e);
                    }
                    finally {
                        if (byteArrayOutputStream != null) {
                            try {
                                byteArrayOutputStream.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                boolean byteArrayOutputStream = false;
                return byteArrayOutputStream;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        if (classBytes == null) {
            return false;
        }
        byte[] bytes0 = CodeUtil.redefineClass(className, classBytes);
        return bytes0 != null;
    }

    public static Set<Class<?>> searchClass(String classPattern) {
        return SearchUtils.searchClass(instrumentation, classPattern, true);
    }

    public static Set<String> searchMethod(Class<?> clazz, String methodPattern) {
        if (clazz == null) {
            return Collections.emptySet();
        }
        HashSet<String> matches = new HashSet<String>();
        for (Method method : clazz.getDeclaredMethods()) {
            String methodName;
            if (method == null || !(methodName = method.getName()).contains(methodPattern)) continue;
            matches.add(methodName);
        }
        return matches;
    }

    public static Set<String> searchMethod(String className, String methodPattern) {
        Class<?> clazz = ClassUtil.getClass(className);
        if (clazz == null) {
            return Collections.emptySet();
        }
        return CodeUtil.searchMethod(clazz, methodPattern);
    }

    public static Instrumentation getInstrumentation() {
        return instrumentation;
    }
}

