/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.framework.util;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IPUtil {
    private static final Logger LOG;
    private static final Set<String> IP_SET;
    public static final String LOCALHOST = "localhost";
    public static final String LOCALHOST2 = "127.0.0.1";

    private IPUtil() {
    }

    public static String getHostIP() {
        String clientIP = System.getProperty("mapp.clientRegisterIP");
        if (clientIP != null) {
            return clientIP;
        }
        if (IP_SET.isEmpty()) {
            return LOCALHOST;
        }
        if (IP_SET.size() > 1 && LOG.isDebugEnabled()) {
            LOG.debug("\u670d\u52a1\u5668\u6709\u591a\u4e2aIP\u5730\u5740[" + IPUtil.convertSetToString(IP_SET) + "],\u968f\u673a\u4f7f\u7528\u5176\u4e2d\u4e00\u4e2aIP\u5730\u5740\u8fd4\u56de");
        }
        return IP_SET.iterator().next();
    }

    public static boolean isSelfIP(String ip) {
        return LOCALHOST.equalsIgnoreCase(ip) || LOCALHOST2.equalsIgnoreCase(ip) || IP_SET.contains(ip);
    }

    private static String convertSetToString(Set<String> set) {
        StringBuilder sb = new StringBuilder();
        for (String l : set) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(l);
        }
        return sb.toString();
    }

    static {
        block4: {
            LOG = LoggerFactory.getLogger(IPUtil.class);
            IP_SET = new HashSet<String>();
            try {
                Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
                while (networkInterfaces.hasMoreElements()) {
                    NetworkInterface networkInterface = networkInterfaces.nextElement();
                    Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                    while (inetAddresses.hasMoreElements()) {
                        String ip;
                        InetAddress inetAddress = inetAddresses.nextElement();
                        if (inetAddress == null || !(inetAddress instanceof Inet4Address) || LOCALHOST.equalsIgnoreCase(ip = inetAddress.getHostAddress()) || LOCALHOST2.equalsIgnoreCase(ip)) continue;
                        IP_SET.add(ip);
                    }
                }
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block4;
                LOG.warn("\u83b7\u53d6\u5fae\u5e94\u7528\u670d\u52a1\u5668IP\u5730\u5740\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            }
        }
    }
}

