/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.framework.util;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceUtil {
    private static final String DAO_PACKAGE_PREFFIX = ".impl";
    private static final String DAO_IMPL_SUBFFIX = "Imp";

    private ResourceUtil() {
    }

    public static <T> T[] sortByOrderAnnotation(List<T> list, T[] emptyArray) {
        T[] array = list.toArray(emptyArray);
        Arrays.sort(array, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                Order annotation2;
                int order2;
                Order annotation1 = o1.getClass().getAnnotation(Order.class);
                int order1 = annotation1 == null ? -1 : annotation1.value();
                if (order1 == (order2 = (annotation2 = o2.getClass().getAnnotation(Order.class)) == null ? -1 : annotation2.value())) {
                    return 0;
                }
                if (order1 > order2) {
                    return 1;
                }
                if (order1 < order2) {
                    return -1;
                }
                return order1 >= order2 ? 1 : -1;
            }
        });
        return array;
    }

    public static List<URL> findResources(String locationPattern) {
        ArrayList<URL> files = new ArrayList<URL>();
        try {
            Resource[] resources;
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            for (Resource resource : resources = resolver.getResources(locationPattern)) {
                files.add(resource.getURL());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return files;
    }

    public static String getDaoImpl(Class<?> ifc) {
        String ifcName = ifc.getSimpleName();
        String pkgName = ifc.getPackage().getName();
        String impName = null;
        impName = ifcName.indexOf("I") == 0 ? ifcName.substring(1) : ifcName + DAO_IMPL_SUBFFIX;
        int lastIndex = pkgName.lastIndexOf(".");
        String lastPkgName = pkgName.substring(lastIndex, pkgName.length());
        String impl = pkgName.replace(lastPkgName, DAO_PACKAGE_PREFFIX + lastPkgName) + "." + impName;
        return impl;
    }
}

