/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.framework.util;

import com.ygsoft.ecp.framework.cons.ServerProps;
import com.ygsoft.ecp.framework.util.BackKeyUtil;
import com.ygsoft.ecp.framework.util.FrontKeyUtil;
import java.util.Arrays;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;

public class SecurityKeyUtil {
    private static final String KEY_STR = "jdbc.password.encode.key";
    private static final String iV_STR = "sm4cbc.iv";
    private static final String JT_CLOUD_KEY_SEGMENT_ENABLED = "jt.cloud.key.segment.enabled";
    private static final boolean KEY_SEGMENT_ENABLED = "true".equals(ServerProps.getProperty("jt.cloud.key.segment.enabled", "false"));
    private static String SM4CBC_SEGMENT_KEY = null;
    private static String SM4CBC_SEGMENT_IV = null;
    private static String DEFAULT_KEY = ByteUtils.toHexString((byte[])SecurityKeyUtil.byteMergerAll(FrontKeyUtil.getFrontKey(), BackKeyUtil.getBackKey()));

    public static String getSM4CBCKey() {
        String key = "";
        key = KEY_SEGMENT_ENABLED ? SecurityKeyUtil.getSegMentSM4CBCKey() : ServerProps.getProperty(KEY_STR, DEFAULT_KEY);
        return key;
    }

    public static String getSM4CBCIv() {
        String iv = "";
        iv = KEY_SEGMENT_ENABLED ? SecurityKeyUtil.getSegMentSM4CBCIv() : ServerProps.getProperty(iV_STR);
        return iv;
    }

    private static String getSegMentSM4CBCKey() {
        String hexStr;
        if (SM4CBC_SEGMENT_KEY != null) {
            return SM4CBC_SEGMENT_KEY;
        }
        byte[] keyFront = SecurityKeyUtil.getFrontKey();
        String key = ServerProps.getProperty(KEY_STR);
        if (key == null || key.length() == 0) {
            throw new RuntimeException("\u5206\u6bb5\u5bc6\u94a5\u4e0b\uff0cjdbc.password.encode.key\u662f\u5fc5\u987b\u914d\u7f6e.");
        }
        if (key.length() != 16) {
            throw new RuntimeException("key\u503c\u9519\u8bef\uff0c\u5b57\u7b26\u957f\u5ea6\u5e76\u4e0d\u7b49\u4e8e16");
        }
        byte[] keyAfter = SecurityKeyUtil.hexToByte(key);
        byte[] ivByte = SecurityKeyUtil.byteMergerAll(keyFront, keyAfter);
        SM4CBC_SEGMENT_KEY = hexStr = ByteUtils.toHexString((byte[])ivByte);
        return SM4CBC_SEGMENT_KEY;
    }

    private static String getSegMentSM4CBCIv() {
        if (SM4CBC_SEGMENT_IV != null) {
            return SM4CBC_SEGMENT_IV;
        }
        byte[] ivFront = SecurityKeyUtil.getFrontIv();
        String iv = ServerProps.getProperty(iV_STR);
        if (iv == null || iv.length() == 0) {
            throw new RuntimeException("\u5206\u6bb5\u5bc6\u94a5\u4e0b\uff0csm4cbc.iv\u662f\u5fc5\u987b\u914d\u7f6e.");
        }
        if (iv.length() != 16) {
            throw new RuntimeException("iv\u503c\u9519\u8bef\uff0c\u5b57\u7b26\u957f\u5ea6\u5e76\u4e0d\u7b49\u4e8e16");
        }
        byte[] ivAfter = SecurityKeyUtil.hexToByte(iv);
        byte[] ivByte = SecurityKeyUtil.byteMergerAll(ivFront, ivAfter);
        SM4CBC_SEGMENT_IV = SecurityKeyUtil.byteToHex(ivByte);
        return SM4CBC_SEGMENT_IV;
    }

    public static byte[] hexToByte(String hex) {
        int m = 0;
        int n = 0;
        int byteLen = hex.length() / 2;
        byte[] ret = new byte[byteLen];
        for (int i = 0; i < byteLen; ++i) {
            m = i * 2 + 1;
            n = m + 1;
            int intVal = Integer.decode("0x" + hex.substring(i * 2, m) + hex.substring(m, n));
            ret[i] = (byte)intVal;
        }
        return ret;
    }

    public static byte[] byteMergerAll(byte[] ... values) {
        int length_byte = 0;
        for (int i = 0; i < values.length; ++i) {
            length_byte += values[i].length;
        }
        byte[] all_byte = new byte[length_byte];
        int countLength = 0;
        for (int i = 0; i < values.length; ++i) {
            byte[] b = values[i];
            System.arraycopy(b, 0, all_byte, countLength, b.length);
            countLength += b.length;
        }
        return all_byte;
    }

    public static String byteToHex(byte[] bytes) {
        String strHex = "";
        StringBuilder sb = new StringBuilder("");
        for (int n = 0; n < bytes.length; ++n) {
            strHex = Integer.toHexString(bytes[n] & 0xFF);
            sb.append(strHex.length() == 1 ? "0" + strHex : strHex);
        }
        return sb.toString().trim();
    }

    private static byte[] getFrontIv() {
        byte[] ivFront = new byte[8];
        Arrays.fill(ivFront, 0, 1, (byte)121);
        Arrays.fill(ivFront, 1, 2, (byte)103);
        Arrays.fill(ivFront, 2, 3, (byte)83);
        Arrays.fill(ivFront, 3, 4, (byte)79);
        Arrays.fill(ivFront, 4, 5, (byte)70);
        Arrays.fill(ivFront, 5, 6, (byte)116);
        Arrays.fill(ivFront, 6, 7, (byte)126);
        Arrays.fill(ivFront, 7, 8, (byte)109);
        return ivFront;
    }

    private static byte[] getFrontKey() {
        byte[] keyFront = new byte[8];
        Arrays.fill(keyFront, 0, 1, (byte)88);
        Arrays.fill(keyFront, 1, 2, (byte)-101);
        Arrays.fill(keyFront, 2, 3, (byte)-89);
        Arrays.fill(keyFront, 3, 4, (byte)-39);
        Arrays.fill(keyFront, 4, 5, (byte)51);
        Arrays.fill(keyFront, 5, 6, (byte)65);
        Arrays.fill(keyFront, 6, 7, (byte)78);
        Arrays.fill(keyFront, 7, 8, (byte)-20);
        return keyFront;
    }
}

