/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.framework.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpTimeTracer {
    private final Logger startCostLogger = LoggerFactory.getLogger((String)"startcost");
    private final int logThresHold = Integer.parseInt(System.getProperty("ecp.starcost.threshold", "100"));
    private static final char COLUMN_SPLITOR = '\t';
    private static final String SUB_TOTAL = "[subtotal]";
    private long totalEventStartTime;
    private long subEventStartTime;
    private String eventSource;
    private String eventName;

    public UpTimeTracer(String eventSrc, String name) {
        this.eventSource = eventSrc;
        this.eventName = name;
    }

    private void endEvent(long cost, String executor, String remark) {
        if (cost >= (long)this.logThresHold && this.startCostLogger.isInfoEnabled()) {
            this.startCostLogger.info('\t' + this.eventSource + '\t' + this.eventName + '\t' + cost + '\t' + executor + '\t' + remark);
        }
    }

    public void setEventName(String event) {
        this.eventName = event;
    }

    public void begintTotalEvent() {
        this.totalEventStartTime = System.currentTimeMillis();
    }

    public void beginSubEvent() {
        this.subEventStartTime = System.currentTimeMillis();
    }

    public void endTotalEvent() {
        long totalCost = System.currentTimeMillis() - this.totalEventStartTime;
        this.endEvent(totalCost, SUB_TOTAL, null);
    }

    public void endTotalEvent(String remark) {
        long totalCost = System.currentTimeMillis() - this.totalEventStartTime;
        this.endEvent(totalCost, SUB_TOTAL, remark);
    }

    public void endSubEvent(String executor) {
        long subCost = System.currentTimeMillis() - this.subEventStartTime;
        this.endEvent(subCost, executor, null);
    }

    public void endSubEvent(String executor, String remark) {
        long subCost = System.currentTimeMillis() - this.subEventStartTime;
        this.endEvent(subCost, executor, remark);
    }
}

