/*
 * Decompiled with CFR 0.152.
 */
package com.pansoft.xbrl.xbrljson.convert;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.pansoft.xbrl.xbrljson.config.XbrlJsonConfigMgr;
import com.pansoft.xbrl.xbrljson.config.model.JsonConfigItem;
import com.pansoft.xbrl.xbrljson.config.model.XbrlJsonConfig;
import com.pansoft.xbrl.xbrljson.reader.XbrlReader;
import com.pansoft.xbrl.xbrljson.reader.impl.BaseXbrlReader;
import com.pansoft.xbrl.xbrljson.util.StringUtil;
import java.util.List;
import java.util.logging.Logger;
import org.dom4j.DocumentException;

public class XbrlToJson {
    private XbrlReader xbrlReader = new BaseXbrlReader();
    private static Logger log = Logger.getLogger(XbrlToJson.class.toString());

    public JSONObject convertXbrlJsonDataWithPath(String xbrlFilePath, String configId) {
        try {
            JSONObject jsonObject = this.xbrlReader.readXbrlDataWithPath(xbrlFilePath);
            return this.convertXbrlJsonData(jsonObject, configId);
        }
        catch (DocumentException e) {
            log.info(e.toString());
            return null;
        }
    }

    public JSONObject convertXbrlJsonData(String xbrlXml, String configId) {
        try {
            JSONObject jsonObject = this.xbrlReader.readXbrlDataWithXml(xbrlXml);
            return this.convertXbrlJsonData(jsonObject, configId);
        }
        catch (Exception e) {
            log.info(e.toString());
            return null;
        }
    }

    public JSONObject convertXbrlJsonData(JSONObject xbrlJsonData, String configId) {
        if (xbrlJsonData == null) {
            return null;
        }
        if (StringUtil.isBlank(configId)) {
            return null;
        }
        XbrlJsonConfig configObject = XbrlJsonConfigMgr.getInstance().getConfigObject(configId);
        if (configObject == null) {
            log.info("\u6ca1\u6709\u627e\u5230\u914d\u7f6e\u6587\u4ef6\u4fe1\u606f\uff0c\u914d\u7f6e\u7f16\u53f7[" + configId + "]");
            return null;
        }
        JsonConfigItem jsonConfigItem = configObject.getJsonConfig();
        if (jsonConfigItem == null) {
            return null;
        }
        JSONObject jsonObject = new JSONObject(true);
        this.buildJsonObject(jsonConfigItem, xbrlJsonData, jsonObject);
        return jsonObject;
    }

    private void buildJsonObject(JsonConfigItem jsonConfigItem, JSONObject xbrlJsonData, JSONObject parentJsonObject) {
        if (jsonConfigItem == null || xbrlJsonData == null) {
            return;
        }
        List<JsonConfigItem> childList = jsonConfigItem.getChildList();
        if (childList == null || childList.size() == 0) {
            return;
        }
        for (JsonConfigItem item : childList) {
            Object obj;
            String fieldName = item.getFieldName();
            String elementName = item.getElementNsName() + ":" + item.getElementName();
            String elementType = item.getElementValueType();
            List<JsonConfigItem> nextChildList = item.getChildList();
            if ("tuple".equals(elementType)) {
                obj = xbrlJsonData.get((Object)elementName);
                if (obj == null || !(obj instanceof JSONArray)) continue;
                JSONArray objList = (JSONArray)obj;
                JSONArray tupleList = new JSONArray();
                parentJsonObject.put(fieldName, (Object)tupleList);
                for (Object tupleItem : objList) {
                    JSONObject parentNode = new JSONObject(true);
                    tupleList.add((Object)parentNode);
                    this.buildJsonObject(item, (JSONObject)tupleItem, parentNode);
                }
                continue;
            }
            if (nextChildList != null && nextChildList.size() > 0) {
                JSONObject parentNode = new JSONObject(true);
                parentJsonObject.put(fieldName, (Object)parentNode);
                this.buildJsonObject(item, xbrlJsonData, parentNode);
                continue;
            }
            obj = xbrlJsonData.get((Object)elementName);
            if (obj == null) continue;
            parentJsonObject.put(fieldName, obj);
        }
    }

    public XbrlReader getXbrlReader() {
        return this.xbrlReader;
    }

    public void setXbrlReader(XbrlReader xbrlReader) {
        this.xbrlReader = xbrlReader;
    }
}

