/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.ascpect;

import com.ygsoft.abc.service.annotation.JpaVersion;
import com.ygsoft.abc.service.exception.UpdateChangedException;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.orm.ObjectOptimisticLockingFailureException;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class JpaVersionAspect {
    private static final IEcpLog LOG = EcpLogFactory.getLog(JpaVersionAspect.class);

    @Pointcut(value="@annotation(com.ygsoft.abc.service.annotation.JpaVersion)")
    public void jpaVersionPointCut() {
    }

    @Around(value="jpaVersionPointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        MethodSignature signature = (MethodSignature)point.getSignature();
        JpaVersion jpaVersion = signature.getMethod().getAnnotation(JpaVersion.class);
        for (int i = 1; i <= jpaVersion.maxCount(); ++i) {
            try {
                this.info("\u4e50\u89c2\u9501\u7b2c(" + i + ")\u6b21\u5c1d\u8bd5\u3002");
                Object result = point.proceed();
                return result;
            }
            catch (ObjectOptimisticLockingFailureException ex) {
                continue;
            }
        }
        throw new UpdateChangedException("ABC.0003", jpaVersion.tip());
    }

    private void info(String msg) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)msg);
        }
    }
}

