/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.attachment.io;

import com.ygsoft.abc.service.exception.AbcIOException;
import com.ygsoft.abc.service.tool.BlockIOUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.web.multipart.MultipartFile;

public class StreamMultipartFile
implements MultipartFile {
    private String name;
    private String originalFilename;
    private String contentType;
    private Long size;
    private InputStream inputStream;

    public static StreamMultipartFile createFrom(InputStream inputStream, String fileName) {
        try {
            StreamMultipartFile multipartFile = new StreamMultipartFile();
            multipartFile.name = fileName;
            multipartFile.originalFilename = fileName;
            multipartFile.contentType = "application/octet-stream";
            multipartFile.inputStream = inputStream;
            multipartFile.size = inputStream.available();
            return multipartFile;
        }
        catch (Exception e) {
            throw AbcIOException.newInstance("\u521b\u5efaStreamMultipartFile\uff0c\u8bfb\u53d6\u9644\u4ef6size\u5931\u8d25\u3002", e);
        }
    }

    public static StreamMultipartFile createFrom(InputStream inputStream, String fileName, String contentType) {
        try {
            StreamMultipartFile multipartFile = new StreamMultipartFile();
            multipartFile.name = fileName;
            multipartFile.originalFilename = fileName;
            multipartFile.contentType = contentType;
            multipartFile.inputStream = inputStream;
            multipartFile.size = inputStream.available();
            return multipartFile;
        }
        catch (Exception e) {
            throw AbcIOException.newInstance("\u521b\u5efaStreamMultipartFile\uff0c\u8bfb\u53d6\u9644\u4ef6size\u5931\u8d25\u3002", e);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getOriginalFilename() {
        return this.originalFilename;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isEmpty() {
        return this.size == 0L;
    }

    public long getSize() {
        return this.size;
    }

    public byte[] getBytes() throws IOException {
        return BlockIOUtil.toByteArray(this.inputStream);
    }

    public InputStream getInputStream() throws IOException {
        return this.inputStream;
    }

    public void transferTo(File newDest) throws IOException, IllegalStateException {
    }
}

