/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.audit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum AuditOperateType {
    ADD("add", "\u65b0\u589e"),
    DELETE("delete", "\u5220\u9664"),
    EDIT("edit", "\u4fee\u6539"),
    QUERY("query", "\u67e5\u8be2"),
    DOWNLOAD("download", "\u4e0b\u8f7d"),
    UPLOAD("unload", "\u4e0a\u4f20"),
    IMPORT("import", "\u5bfc\u5165"),
    EXPORT("export", "\u5bfc\u51fa"),
    OTHER("other", "\u5176\u4ed6"),
    STATISTICAL_ANALYSIS("statisticalAnalysis", "\u7edf\u8ba1\u5206\u6790"),
    SORT("sort", "\u6392\u5e8f"),
    STOP("stop", "\u505c\u7528"),
    RECOVER("recover", "\u6062\u590d"),
    PRINT("print", "\u6253\u5370"),
    INVALID_ACCESS("invalidAccess", "\u8d8a\u6743\u8bbf\u95ee"),
    BACKUP("barkup", "\u5907\u4efd");

    private String operateId;
    private String operateName;

    public static List<String> getDefaultOperateTypeIds() {
        ArrayList<String> operateTypeIds = new ArrayList<String>();
        for (AuditOperateType operateType : AuditOperateType.values()) {
            operateTypeIds.add(operateType.getOperateId());
        }
        return operateTypeIds;
    }

    public static Map<String, String> getDefaultOperateTypeMap() {
        HashMap<String, String> operateTypes = new HashMap<String, String>();
        for (AuditOperateType operateType : AuditOperateType.values()) {
            operateTypes.put(operateType.getOperateId(), operateType.getOperateName());
        }
        return operateTypes;
    }

    private AuditOperateType(String operateId, String operateName) {
        this.operateId = operateId;
        this.operateName = operateName;
    }

    public String getOperateId() {
        return this.operateId;
    }

    public void setOperateId(String operateId) {
        this.operateId = operateId;
    }

    public String getOperateName() {
        return this.operateName;
    }

    public void setOperateName(String operateName) {
        this.operateName = operateName;
    }
}

