/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.cache;

import com.ygsoft.abc.service.devops.domain.vo.JedisPoolStateVO;
import com.ygsoft.abc.service.exception.AbcCryptoException;
import com.ygsoft.abc.service.exception.CacheException;
import com.ygsoft.abc.service.exception.EmptyValueException;
import com.ygsoft.abc.service.security.DESCoder;
import com.ygsoft.abc.service.tool.PropertyConfigUtil;
import com.ygsoft.ecp.service.exception.EcpCheckException;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

@Deprecated
public final class RedisClientFactory {
    private static final IEcpLog LOG = EcpLogFactory.getLog(RedisClientFactory.class);
    public static final long DEFAULT_ACQUIRETIMEOUT = 20L;
    private static final long DEFAULT_EXPIRETIME = 60000L;
    private static final String LOCK_PREFIX = "abc:lock:";
    private static final Long RELEASE_SUCCESS = 1L;
    private static final int POOL_SIZE = 50;
    private static volatile boolean initPool = false;
    private static final AtomicInteger poolQueueIndex = new AtomicInteger(0);
    private static final BlockingQueue<JedisPool> jedisPoolQueue = new ArrayBlockingQueue<JedisPool>(50);
    private static final String DES_KEY = "s+Ne6d96MtA=";
    public static final RedisClientFactory INSTANCE = new RedisClientFactory();

    private RedisClientFactory() {
    }

    public static void set(String key, String value) {
        if (StringUtil.isEmptyString((String)key) || StringUtil.isEmptyString((String)value)) {
            return;
        }
        Jedis jedis = null;
        try {
            jedis = INSTANCE.getRedisConn();
            if (jedis != null) {
                jedis.set(key.getBytes(), value.getBytes());
            }
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"\u7f13\u5b58Redis\u64cd\u4f5cset\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            }
            throw new CacheException("ABC.0020", e);
        }
        finally {
            if (jedis != null) {
                RedisClientFactory.close((Closeable)jedis);
            }
        }
    }

    public static void set(String key, String value, int expireSeconds) {
        if (StringUtil.isEmptyString((String)key) || StringUtil.isEmptyString((String)value)) {
            return;
        }
        Jedis jedis = null;
        try {
            jedis = INSTANCE.getRedisConn();
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"\u7f13\u5b58Redis\u64cd\u4f5cset\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            }
            throw new CacheException("ABC.0020", e);
        }
        finally {
            if (jedis != null) {
                RedisClientFactory.close((Closeable)jedis);
            }
        }
    }

    public static byte[] get(String key) {
        if (StringUtil.isEmptyString((String)key)) {
            return null;
        }
        byte[] ret = null;
        Jedis jedis = null;
        try {
            jedis = INSTANCE.getRedisConn();
            if (jedis != null) {
                ret = jedis.get(key.getBytes());
            }
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"\u7f13\u5b58Redis\u64cd\u4f5cget\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            }
            throw new CacheException("ABC.0020", e);
        }
        finally {
            if (jedis != null) {
                RedisClientFactory.close((Closeable)jedis);
            }
        }
        return ret;
    }

    public static String getStr(String key) {
        byte[] b = RedisClientFactory.get(key);
        return b == null ? null : new String(b);
    }

    public static void del(String key) {
        if (StringUtil.isEmptyString((String)key)) {
            return;
        }
        Jedis jedis = null;
        try {
            jedis = INSTANCE.getRedisConn();
            if (jedis != null) {
                jedis.del(key.getBytes());
            }
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"\u7f13\u5b58Redis\u64cd\u4f5cdel\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            }
            throw new CacheException("ABC.0020", e);
        }
        finally {
            if (jedis != null) {
                RedisClientFactory.close((Closeable)jedis);
            }
        }
    }

    public static String acquireLock(Jedis conn, String lockName) {
        return RedisClientFactory.acquireLock(conn, lockName, 20L);
    }

    public static String acquireLock(Jedis conn, String lockName, long acquireTimeout) {
        return RedisClientFactory.acquireLockWithTimeout(conn, lockName, acquireTimeout, 60000L);
    }

    public static String acquireLockWithTimeout(Jedis conn, String lockName, long acquireTimeout, long expireTime) {
        return null;
    }

    public static boolean releaseLock(Jedis conn, String lockName, String identifier) {
        if (null == conn) {
            throw new EcpCheckException("ABC.0001", EcpI18nUtil.localizedString((String)"RedisClientFactory_releaseLock_340", (String)"\u53c2\u6570\u9519\u8bef\uff1aconn\u4e3a\u7a7a\u3002"));
        }
        if (StringUtil.isNullOrTrimEmptyString((String)lockName)) {
            throw new EcpCheckException("ABC.0001", EcpI18nUtil.localizedString((String)"RedisClientFactory_releaseLock_343", (String)"\u53c2\u6570\u9519\u8bef\uff1alockName\u4e3a\u7a7a\u3002"));
        }
        if (StringUtil.isNullOrTrimEmptyString((String)identifier)) {
            throw new EcpCheckException("ABC.0001", EcpI18nUtil.localizedString((String)"RedisClientFactory_releaseLock_346", (String)"\u53c2\u6570\u9519\u8bef\uff1aidentifier\u4e3a\u7a7a\u3002"));
        }
        String script = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end";
        String lockKey = LOCK_PREFIX + lockName;
        Object result = conn.eval(script, Collections.singletonList(lockKey), Collections.singletonList(identifier));
        return RELEASE_SUCCESS.equals(result);
    }

    public Jedis getRedisConn() {
        if (RedisPool.getJedisPool() == null) {
            String msg = EcpI18nUtil.localizedString((String)"RedisClientFactory_getRedisConn_392", (String)"Redis\u8fde\u63a5\u6c60\u521d\u59cb\u5316\u5931\u8d25\u3002");
            throw EmptyValueException.newInstance(msg);
        }
        Jedis jedis = RedisPool.getJedisPool().getResource();
        if (jedis != null) {
            jedis.select(PropertyConfigUtil.getRedisDBIndex());
            return jedis;
        }
        String msg = EcpI18nUtil.localizedString((String)"RedisClientFactory_getRedisConn_400", (String)"\u83b7\u53d6Redis\u8fde\u63a5\u5931\u8d25\u3002");
        throw EmptyValueException.newInstance(msg);
    }

    public static List<JedisPoolStateVO> getJedisPoolStates() {
        ArrayList<JedisPoolStateVO> list = new ArrayList<JedisPoolStateVO>();
        for (JedisPool jedisPool : jedisPoolQueue) {
            list.add(JedisPoolStateVO.from(jedisPool));
        }
        return list;
    }

    private static String parseFirst(String str) {
        if (str.contains(",")) {
            return str.split(",")[0];
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] serialize(Object object) {
        ObjectOutputStream oos = null;
        ByteArrayOutputStream baos = null;
        byte[] bytes = null;
        try {
            baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            bytes = baos.toByteArray();
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e);
            }
        }
        finally {
            block15: {
                try {
                    if (oos != null) {
                        oos.close();
                    }
                    if (baos != null) {
                        baos.close();
                    }
                }
                catch (Exception e2) {
                    if (!LOG.isErrorEnabled()) break block15;
                    LOG.error((Object)e2);
                }
            }
        }
        return bytes;
    }

    public static Object deserialize(byte[] bytes) {
        Object obj;
        block2: {
            obj = null;
            ByteArrayInputStream bais = null;
            try {
                bais = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bais);
                obj = ois.readObject();
                ois.close();
                bais.close();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)e);
            }
        }
        return obj;
    }

    public void returnConnection(Jedis jedis) {
        block3: {
            try {
                if (jedis != null) {
                    jedis.close();
                }
            }
            catch (Exception ex) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)("Redis\u8fd4\u56de\u8d44\u6e90\u6c60\u51fa\u73b0\u6545\u969c." + ex.getMessage()), (Throwable)ex);
            }
        }
    }

    public static void close(Closeable closeable) {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) break block3;
                    LOG.error((Object)e);
                }
            }
        }
    }

    public static <T> byte[] serialize(List<T> value) {
        if (value == null) {
            throw new NullPointerException(EcpI18nUtil.localizedString((String)"RedisClientFactory_serialize_728", (String)"Can't serialize null"));
        }
        byte[] rv = null;
        ByteArrayOutputStream bos = null;
        ObjectOutputStream os = null;
        try {
            bos = new ByteArrayOutputStream();
            os = new ObjectOutputStream(bos);
            for (T obj : value) {
                os.writeObject(obj);
            }
            os.writeObject(null);
            os.close();
            bos.close();
            rv = bos.toByteArray();
        }
        catch (IOException e) {
            try {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)e);
                }
                throw new IllegalArgumentException(EcpI18nUtil.localizedString((String)"RedisClientFactory_serialize_747", (String)"Non-serializable object"), e);
            }
            catch (Throwable throwable) {
                RedisClientFactory.close(os);
                RedisClientFactory.close(bos);
                throw throwable;
            }
        }
        RedisClientFactory.close(os);
        RedisClientFactory.close(bos);
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static <T> List<T> deserializeForList(byte[] in) {
        ObjectInputStream is;
        ByteArrayInputStream bis;
        ArrayList<Object> list;
        block7: {
            list = new ArrayList<Object>();
            bis = null;
            is = null;
            try {
                Object obj;
                if (in == null) break block7;
                bis = new ByteArrayInputStream(in);
                is = new ObjectInputStream(bis);
                while ((obj = is.readObject()) != null) {
                    list.add(obj);
                }
                is.close();
                bis.close();
            }
            catch (IOException e) {
                block8: {
                    if (!LOG.isErrorEnabled()) break block8;
                    LOG.error((Object)e);
                }
                RedisClientFactory.close(is);
                RedisClientFactory.close(bis);
            }
            catch (ClassNotFoundException e2) {
                block9: {
                    if (!LOG.isErrorEnabled()) break block9;
                    LOG.error((Object)e2);
                    {
                        catch (Throwable throwable) {
                            RedisClientFactory.close(is);
                            RedisClientFactory.close(bis);
                            throw throwable;
                        }
                    }
                }
                RedisClientFactory.close(is);
                RedisClientFactory.close(bis);
            }
        }
        RedisClientFactory.close(is);
        RedisClientFactory.close(bis);
        return list;
    }

    public static String encryptRedisPassword(String password) {
        DESCoder coder = DESCoder.getInstance();
        String desPassword = password;
        try {
            desPassword = coder.encrypt(password, DES_KEY);
        }
        catch (Exception e) {
            throw new AbcCryptoException("ABC.0032", "redis\u5bc6\u7801\u52a0\u5bc6\u5931\u8d25\u3002", e, new Object[0]);
        }
        return desPassword;
    }

    public static String decryptRedisPassword(String password) {
        DESCoder coder = DESCoder.getInstance();
        String desPassword = password;
        try {
            desPassword = coder.decrypt(password, DES_KEY);
        }
        catch (Exception e) {
            throw new AbcCryptoException("ABC.0032", "redis\u5bc6\u7801\u89e3\u5bc6\u5931\u8d25\u3002", e, new Object[0]);
        }
        return desPassword;
    }

    public static void main(String[] args) {
        String password = "1234.abcd";
        String desPassword = RedisClientFactory.encryptRedisPassword("1234.abcd");
        System.out.println("desPassword:" + desPassword);
        String accessPassword = RedisClientFactory.decryptRedisPassword(desPassword);
        System.out.println("accessPassword:" + accessPassword);
        System.out.println("\u5bc6\u7801\u6821\u9a8c\uff1a" + accessPassword.equals("1234.abcd"));
    }

    private static class RedisPool {
        public static final int REDIS_TIMEOUT = 3000;

        private RedisPool() {
        }

        public static String preEqualSign(String equalSignData) {
            return equalSignData.split("\\=")[0];
        }

        public static String nextEqualSign(String equalSignData) {
            return equalSignData.split("\\=")[1];
        }

        public static Map<String, String> analysisParam(String paramString) {
            return Arrays.asList(paramString.split("\\&")).stream().collect(Collectors.toMap(RedisPool::preEqualSign, RedisPool::nextEqualSign));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private static JedisPool getJedisPool() {
            JedisPool returnJedisPool;
            block9: {
                if (!initPool) {
                    Class<RedisClientFactory> clazz = RedisClientFactory.class;
                    // MONITORENTER : com.ygsoft.abc.service.cache.RedisClientFactory.class
                    if (!initPool) {
                        for (int i = 0; i < 50; ++i) {
                            JedisPool jedisPool = RedisPool.newJedisPool();
                            poolQueueIndex.addAndGet(1);
                            jedisPoolQueue.offer(jedisPool);
                        }
                        initPool = true;
                    }
                    // MONITOREXIT : clazz
                }
                returnJedisPool = null;
                try {
                    long startTime = System.currentTimeMillis();
                    returnJedisPool = (JedisPool)jedisPoolQueue.poll(2L, TimeUnit.SECONDS);
                    long cost = System.currentTimeMillis() - startTime;
                    if (cost >= 20L && LOG.isWarnEnabled()) {
                        LOG.warn((Object)("#####>\u83b7\u53d6Reids\u6c60\u8d44\u6e90\u8017\u65f6\uff1a\uff08" + cost + "\uff09\u6beb\u79d2\u3002"));
                    }
                    if (Objects.isNull(returnJedisPool)) {
                        if (!LOG.isErrorEnabled()) throw EmptyValueException.newInstance("\u83b7\u53d6Reids\u6c60\u8d44\u6e90\u5931\u8d25\u3002");
                        LOG.error((Object)("*****>jedisPoolQueue.size=" + jedisPoolQueue.size()));
                        throw EmptyValueException.newInstance("\u83b7\u53d6Reids\u6c60\u8d44\u6e90\u5931\u8d25\u3002");
                    }
                }
                catch (InterruptedException e) {
                    if (!LOG.isErrorEnabled()) break block9;
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            jedisPoolQueue.offer(returnJedisPool);
            return returnJedisPool;
        }

        private static JedisPool newJedisPool() {
            JedisPool jedisPool;
            JedisPoolConfig config = new JedisPoolConfig();
            config.setMaxIdle(10);
            config.setMaxTotal(10);
            config.setMaxWaitMillis(7000L);
            config.setMinEvictableIdleTimeMillis(1800000L);
            config.setTestWhileIdle(true);
            config.setTimeBetweenEvictionRunsMillis(30000L);
            String serverUrl = PropertyConfigUtil.getRedisIP();
            String[] urlArr = serverUrl.split("\\?");
            String redisHost = urlArr[0];
            String redisPort = PropertyConfigUtil.getStrictProperty("abc.redis.server.port");
            if (urlArr.length > 1) {
                Map<String, String> paramMap = RedisPool.analysisParam(urlArr[1]);
                String requirepass = paramMap.get("requirepass");
                if (paramMap.containsKey("encryptpwd") && Boolean.parseBoolean(paramMap.get("encryptpwd"))) {
                    requirepass = RedisClientFactory.decryptRedisPassword(requirepass);
                }
                jedisPool = new JedisPool((GenericObjectPoolConfig)config, RedisClientFactory.parseFirst(redisHost), Integer.valueOf(RedisClientFactory.parseFirst(redisPort)).intValue(), 3000, requirepass);
            } else {
                jedisPool = new JedisPool((GenericObjectPoolConfig)config, RedisClientFactory.parseFirst(redisHost), Integer.valueOf(RedisClientFactory.parseFirst(redisPort)).intValue(), 3000);
            }
            return jedisPool;
        }
    }
}

