/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.cache.domain.vo;

import com.ygsoft.abc.service.exception.AbcCryptoException;
import com.ygsoft.abc.service.security.DESCoder;
import com.ygsoft.abc.service.tool.PropertyConfigUtil;
import com.ygsoft.ecp.service.model.IValueObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Deprecated
public class RedisConfigVO
implements IValueObject {
    private static final long serialVersionUID = -2062702338734825658L;
    private static final String DES_KEY = "s+Ne6d96MtA=";
    private boolean cluster;
    private List<String> serverList;
    private String password;
    private int database;

    public static RedisConfigVO readConfig() {
        String cluster = PropertyConfigUtil.getProperty("cache.cluster.enabled");
        String server = PropertyConfigUtil.getProperty("abc.redis.server.url");
        String port = PropertyConfigUtil.getProperty("abc.redis.server.port");
        RedisConfigVO configVO = new RedisConfigVO();
        configVO.setCluster(false);
        configVO.setServerList(RedisConfigVO.parseServerList(server, port));
        configVO.setPassword(RedisConfigVO.parsePassword(server));
        return configVO;
    }

    private static List<String> parseServerList(String server, String port) {
        if (server.contains("?")) {
            String[] arr = server.split("\\?");
            String serverUrl = arr[0];
            ArrayList<String> servers = new ArrayList<String>();
            String[] ips = serverUrl.split(",");
            String[] ports = port.split(",");
            for (int i = 0; i < ports.length; ++i) {
                servers.add(ips[i] + ":" + ports[i]);
            }
            return servers;
        }
        ArrayList<String> servers = new ArrayList<String>();
        String[] ips = server.split(",");
        String[] ports = port.split(",");
        for (int i = 0; i < ports.length; ++i) {
            servers.add(ips[i] + ":" + ports[i]);
        }
        return servers;
    }

    private static String parsePassword(String server) {
        if (server.contains("?")) {
            String[] arr = server.split("\\?");
            String param = arr[1];
            Map<String, String> paramMap = RedisConfigVO.analysisParam(param);
            String requirepass = paramMap.get("requirepass");
            if (paramMap.containsKey("encryptpwd") && Boolean.parseBoolean(paramMap.get("encryptpwd"))) {
                requirepass = RedisConfigVO.decrypt(requirepass);
            }
            return requirepass;
        }
        return null;
    }

    private static String decrypt(String password) {
        DESCoder coder = DESCoder.getInstance();
        String desPassword = password;
        try {
            desPassword = coder.decrypt(password, DES_KEY);
        }
        catch (Exception e) {
            throw new AbcCryptoException("ABC.0032", "redis\u5bc6\u7801\u89e3\u5bc6\u5931\u8d25\u3002", e, new Object[0]);
        }
        return desPassword;
    }

    private static Map<String, String> analysisParam(String paramString) {
        return Arrays.asList(paramString.split("\\&")).stream().collect(Collectors.toMap(RedisConfigVO::preEqualSign, RedisConfigVO::nextEqualSign));
    }

    private static String preEqualSign(String equalSignData) {
        return equalSignData.split("\\=")[0];
    }

    private static String nextEqualSign(String equalSignData) {
        return equalSignData.split("\\=")[1];
    }

    public boolean isCluster() {
        return this.cluster;
    }

    public void setCluster(boolean newCluster) {
        this.cluster = newCluster;
    }

    public List<String> getServerList() {
        return this.serverList;
    }

    public void setServerList(List<String> newServerList) {
        this.serverList = newServerList;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String newPassword) {
        this.password = newPassword;
    }

    public int getDatabase() {
        return this.database;
    }

    public void setDatabase(int newDatabase) {
        this.database = newDatabase;
    }
}

