/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.common.domain.bo;

import com.ygsoft.abc.service.exception.CheckFailedException;
import com.ygsoft.abc.service.exception.EmptyValueException;
import com.ygsoft.abc.service.security.kit.Base64Kit;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.apache.commons.codec.binary.Base64;

public class Base64Wrapper
implements Serializable {
    private static final long serialVersionUID = 7783413693924974556L;
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private String originalText;
    private String base64String;
    private byte[] originalData;

    public static Base64Wrapper from(byte[] data) {
        if (data == null) {
            throw EmptyValueException.newInstance("\u53c2\u6570\u9519\u8bef\uff1adata\u4e3a\u7a7a\u3002");
        }
        Base64Wrapper entity = new Base64Wrapper();
        entity.setOriginalData(data);
        return entity;
    }

    public static Base64Wrapper fromOriginalText(String text) {
        if (text == null) {
            throw EmptyValueException.newInstance("\u53c2\u6570\u9519\u8bef\uff1atext\u4e3a\u7a7a\u3002");
        }
        Base64Wrapper entity = new Base64Wrapper();
        entity.setOriginalText(text);
        return entity;
    }

    public static Base64Wrapper fromBase64String(String base64String) {
        if (base64String == null) {
            throw EmptyValueException.newInstance("\u53c2\u6570\u9519\u8bef\uff1abase64String\u4e3a\u7a7a\u3002");
        }
        boolean isBase64 = Base64.isBase64((String)base64String);
        if (!isBase64) {
            throw CheckFailedException.newInstance("\u975eBase64\u7f16\u7801\u5b57\u7b26\u4e32\u3002");
        }
        Base64Wrapper entity = new Base64Wrapper();
        entity.setBase64String(base64String);
        return entity;
    }

    public String getOriginalText() {
        return this.originalText;
    }

    public String getAnyOriginalText() {
        return this.getAnyOriginalText(false);
    }

    public String getAnyOriginalText(boolean allowByteToString) {
        if (!StringUtil.isNullOrTrimEmptyString((String)this.originalText)) {
            return this.originalText;
        }
        if (!StringUtil.isNullOrTrimEmptyString((String)this.base64String)) {
            this.originalText = Base64Kit.standardMode().decodeToString(this.base64String);
            return this.originalText;
        }
        if (this.originalData != null && allowByteToString) {
            this.originalText = new String(this.originalData, UTF_8);
            return this.originalText;
        }
        return null;
    }

    public void setOriginalText(String originalText) {
        this.originalText = originalText;
    }

    public String getBase64String() {
        return this.base64String;
    }

    public String getAnyBase64String() {
        if (!StringUtil.isNullOrTrimEmptyString((String)this.base64String)) {
            return this.base64String;
        }
        if (this.originalData != null) {
            this.base64String = Base64Kit.standardMode().encode(this.originalData);
            return this.base64String;
        }
        if (!StringUtil.isNullOrTrimEmptyString((String)this.originalText)) {
            this.base64String = Base64Kit.standardMode().encodeFromString(this.originalText);
            return this.base64String;
        }
        return null;
    }

    public void setBase64String(String base64String) {
        this.base64String = base64String;
    }

    public byte[] getOriginalData() {
        return this.originalData;
    }

    public byte[] getAnyOriginalData() {
        if (this.originalData != null) {
            return this.originalData;
        }
        if (!StringUtil.isNullOrTrimEmptyString((String)this.base64String)) {
            this.originalData = Base64Kit.standardMode().decode(this.base64String);
            return this.originalData;
        }
        if (!StringUtil.isNullOrTrimEmptyString((String)this.originalText)) {
            this.originalData = this.originalText.getBytes(UTF_8);
            return this.originalData;
        }
        return null;
    }

    public void setOriginalData(byte[] originalData) {
        this.originalData = originalData;
    }
}

