/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.common.util;

import com.ygsoft.abc.service.function.Assertable;
import com.ygsoft.abc.service.function.Workable;
import com.ygsoft.abc.service.tool.CommonUtil;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;

public class ConditionActuator {
    static final IEcpLog LOG = EcpLogFactory.getLog(ConditionActuator.class);
    private static final int DEFAULT_RATE = 200;
    private static final int DEFAULT_INTERVAL = 7;
    private int rate;
    private long deadline;

    private ConditionActuator(int rate, long deadline) {
        this.rate = rate;
        this.deadline = deadline;
    }

    public static ConditionActuator newInstance() {
        return ConditionActuator.newInstance(200, 7);
    }

    public static ConditionActuator newInstance(int rate) {
        return ConditionActuator.newInstance(rate, 7);
    }

    public static ConditionActuator newInstance(int rate, int interval) {
        long startTime = System.currentTimeMillis();
        long deadline = startTime + (long)(interval * 1000);
        return new ConditionActuator(rate, deadline);
    }

    private boolean inTime() {
        long now = System.currentTimeMillis();
        return now <= this.deadline;
    }

    public boolean check(Assertable assertable) {
        boolean flag = false;
        while (this.inTime()) {
            if (!assertable.check()) {
                CommonUtil.sleep(this.rate);
                continue;
            }
            flag = true;
            break;
        }
        return flag;
    }

    public boolean execute(Assertable assertable, Workable workable) {
        if (this.check(assertable)) {
            workable.run();
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        StringBuilder shared = new StringBuilder();
        ConditionActuator actuator = ConditionActuator.newInstance();
        Assertable assertable = () -> shared.length() > 0;
        Workable workable = () -> System.out.println("\u6761\u4ef6\u901a\u8fc7...\u6267\u884c\u4efb\u52a1...");
        long start = System.currentTimeMillis();
        new Thread(() -> {
            CommonUtil.sleep(3000L);
            shared.append("ABC");
        }).start();
        actuator.execute(assertable, workable);
        long end = System.currentTimeMillis();
        System.out.println("\u6267\u884c\u8017\u65f6\uff1a" + (end - start));
    }
}

