/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.concurrent;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.ygsoft.abc.service.tool.CommonUtil;
import com.ygsoft.abc.service.tool.PreconditionUtil;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolExecutorFactory {
    static final IEcpLog LOG = EcpLogFactory.getLog(ThreadPoolExecutorFactory.class);
    private static final ThreadPoolExecutorFactory instance = new ThreadPoolExecutorFactory();
    private static Map<String, ThreadPoolExecutor> threadPoolMap = new ConcurrentHashMap<String, ThreadPoolExecutor>();

    public static ThreadPoolExecutorFactory getInstance() {
        return instance;
    }

    public ThreadPoolExecutor getThreadPoolExecutor(String threadNamePrefix, int corePoolSize, int maxPoolSize, long keepAliveSeconds, int queueSize) {
        return this.getThreadPoolExecutor(threadNamePrefix, corePoolSize, maxPoolSize, keepAliveSeconds, queueSize, new ThreadPoolExecutor.AbortPolicy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadPoolExecutor getThreadPoolExecutor(String threadNamePrefix, int corePoolSize, int maxPoolSize, long keepAliveSeconds, int queueSize, RejectedExecutionHandler handler) {
        PreconditionUtil.checkNotTrimEmpty(threadNamePrefix, "\u53c2\u6570\u9519\u8bef\uff1athreadNamePrefix\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        PreconditionUtil.checkArgument(corePoolSize > 0, "\u53c2\u6570\u9519\u8bef\uff1acorePoolSize\u5fc5\u987b\u5927\u4e8e0\u3002");
        PreconditionUtil.checkArgument(maxPoolSize >= corePoolSize, "\u53c2\u6570\u9519\u8bef\uff1amaxPoolSize\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8ecorePoolSize\u3002");
        PreconditionUtil.checkArgument(queueSize > 0, "\u53c2\u6570\u9519\u8bef\uff1aqueueSize\u5fc5\u987b\u5927\u4e8e0\u3002");
        PreconditionUtil.checkNotNull(handler, "\u53c2\u6570\u9519\u8bef\uff1ahandler\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        if (threadPoolMap.get(threadNamePrefix) != null) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)(">>>>>hit thread-pool " + threadNamePrefix));
            }
            return threadPoolMap.get(threadNamePrefix);
        }
        Map<String, ThreadPoolExecutor> map = threadPoolMap;
        synchronized (map) {
            if (threadPoolMap.get(threadNamePrefix) != null) {
                return threadPoolMap.get(threadNamePrefix);
            }
            ThreadFactory factory = new ThreadFactoryBuilder().setNameFormat(threadNamePrefix + "%s").build();
            ThreadPoolExecutor executor = new ThreadPoolExecutor(corePoolSize, maxPoolSize, keepAliveSeconds, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(queueSize), factory, handler);
            this.addShutdownHook(executor);
            threadPoolMap.put(threadNamePrefix, executor);
        }
        return threadPoolMap.get(threadNamePrefix);
    }

    private void addShutdownHook(ThreadPoolExecutor executor) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"\u7ebf\u7a0b\u6c60\u5f00\u59cb\u5173\u95ed...");
            }
            executor.shutdown();
            try {
                if (!executor.awaitTermination(30L, TimeUnit.SECONDS)) {
                    executor.shutdownNow();
                }
            }
            catch (Exception e) {
                executor.shutdownNow();
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"\u7ebf\u7a0b\u6c60\u5173\u95ed\u5b8c\u6210\u3002");
            }
        }));
    }

    public static void main(String[] args) {
        ThreadPoolExecutor executor = ThreadPoolExecutorFactory.getInstance().getThreadPoolExecutor("abc-pool", 2, 100, 30L, 10);
        int i = 0;
        while (i < 100) {
            int idx = i++;
            executor.execute(() -> {
                for (int j = 0; j < 10; ++j) {
                    System.out.println(Thread.currentThread().getName() + ":i=" + idx + ",j=" + j);
                    CommonUtil.sleep(200L);
                }
            });
        }
    }
}

