/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.devops.domain.vo;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.ygsoft.abc.service.cache.domain.bo.CaffeineCacheWrapper;
import com.ygsoft.ecp.service.model.IValueObject;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CaffeineCacheStateVO
implements IValueObject {
    private static final long serialVersionUID = 6492458519678432550L;
    private String cacheName;
    private Integer expire;
    private Integer size;
    private Long estimatedSize;
    private BigDecimal usageRate;
    private Long requestCount;
    private Long hitCount;
    private BigDecimal hitRate;
    private Long missCount;
    private BigDecimal missRate;
    private Long loadSuccessCount;
    private Long loadFailureCount;
    private Long totalLoadTime;
    private Long evictionCount;
    private Long evictionWeight;

    public static CaffeineCacheStateVO newInstance(CaffeineCacheWrapper wrapper) {
        Cache<String, Object> cache = wrapper.getCache();
        CaffeineCacheStateVO entity = new CaffeineCacheStateVO();
        entity.setCacheName(wrapper.getCacheName());
        entity.setExpire(wrapper.getExpire());
        entity.setSize(wrapper.getSize());
        entity.setEstimatedSize(cache.estimatedSize());
        entity.setUsageRate(CaffeineCacheStateVO.calculateUsageRate(entity.getEstimatedSize(), entity.getSize()));
        entity.copy(cache.stats());
        return entity;
    }

    private void copy(CacheStats cacheStats) {
        this.setRequestCount(cacheStats.requestCount());
        this.setHitCount(cacheStats.hitCount());
        this.setHitRate(CaffeineCacheStateVO.toBigDecimal(cacheStats.hitRate()));
        this.setMissCount(cacheStats.missCount());
        this.setMissRate(CaffeineCacheStateVO.toBigDecimal(cacheStats.missRate()));
        this.setLoadSuccessCount(cacheStats.loadSuccessCount());
        this.setLoadFailureCount(cacheStats.loadFailureCount());
        this.setTotalLoadTime(cacheStats.totalLoadTime());
        this.setEvictionCount(cacheStats.evictionCount());
        this.setEvictionWeight(cacheStats.evictionWeight());
    }

    private static BigDecimal calculateUsageRate(long estimatedSize, int size) {
        double rate = (double)estimatedSize * 1.0 / ((double)size * 1.0);
        return CaffeineCacheStateVO.toBigDecimal(rate);
    }

    private static BigDecimal toBigDecimal(double val) {
        BigDecimal decimal = new BigDecimal(val);
        return decimal.setScale(4, RoundingMode.HALF_UP);
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String newCacheName) {
        this.cacheName = newCacheName;
    }

    public Integer getExpire() {
        return this.expire;
    }

    public void setExpire(Integer newExpire) {
        this.expire = newExpire;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer newSize) {
        this.size = newSize;
    }

    public Long getEstimatedSize() {
        return this.estimatedSize;
    }

    public void setEstimatedSize(Long newEstimatedSize) {
        this.estimatedSize = newEstimatedSize;
    }

    public BigDecimal getUsageRate() {
        return this.usageRate;
    }

    public void setUsageRate(BigDecimal newUsageRate) {
        this.usageRate = newUsageRate;
    }

    public Long getRequestCount() {
        return this.requestCount;
    }

    public void setRequestCount(Long newRequestCount) {
        this.requestCount = newRequestCount;
    }

    public Long getHitCount() {
        return this.hitCount;
    }

    public void setHitCount(Long newHitCount) {
        this.hitCount = newHitCount;
    }

    public BigDecimal getHitRate() {
        return this.hitRate;
    }

    public void setHitRate(BigDecimal newHitRate) {
        this.hitRate = newHitRate;
    }

    public Long getMissCount() {
        return this.missCount;
    }

    public void setMissCount(Long newMissCount) {
        this.missCount = newMissCount;
    }

    public BigDecimal getMissRate() {
        return this.missRate;
    }

    public void setMissRate(BigDecimal newMissRate) {
        this.missRate = newMissRate;
    }

    public Long getLoadSuccessCount() {
        return this.loadSuccessCount;
    }

    public void setLoadSuccessCount(Long newLoadSuccessCount) {
        this.loadSuccessCount = newLoadSuccessCount;
    }

    public Long getLoadFailureCount() {
        return this.loadFailureCount;
    }

    public void setLoadFailureCount(Long newLoadFailureCount) {
        this.loadFailureCount = newLoadFailureCount;
    }

    public Long getTotalLoadTime() {
        return this.totalLoadTime;
    }

    public void setTotalLoadTime(Long newTotalLoadTime) {
        this.totalLoadTime = newTotalLoadTime;
    }

    public Long getEvictionCount() {
        return this.evictionCount;
    }

    public void setEvictionCount(Long newEvictionCount) {
        this.evictionCount = newEvictionCount;
    }

    public Long getEvictionWeight() {
        return this.evictionWeight;
    }

    public void setEvictionWeight(Long newEvictionWeight) {
        this.evictionWeight = newEvictionWeight;
    }
}

