/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.document.function.impl;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Image;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfGState;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.ygsoft.abc.service.document.function.WaterMarkFunction;
import com.ygsoft.abc.service.document.vo.ImageWaterMarkVO;
import com.ygsoft.abc.service.exception.CheckFailedException;
import com.ygsoft.ecp.service.exception.EcpCheckException;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.StringUtils;

public final class ImageWaterMarkFunction
implements WaterMarkFunction<ImageWaterMarkVO> {
    private static final IEcpLog LOG = EcpLogFactory.getLog(ImageWaterMarkFunction.class);
    public static final ImageWaterMarkFunction INSTANCE = new ImageWaterMarkFunction();

    private ImageWaterMarkFunction() {
    }

    @Override
    public void addWaterMark(PdfReader reader, PdfStamper stamper, ImageWaterMarkVO waterMarkVO) {
        block12: {
            this.checkArguments(reader, stamper, waterMarkVO);
            try {
                Image image;
                if (waterMarkVO.getImgData() != null) {
                    image = Image.getInstance((byte[])waterMarkVO.getImgData());
                } else if (StringUtils.isNotEmpty((CharSequence)waterMarkVO.getImgPath())) {
                    image = Image.getInstance((String)waterMarkVO.getImgPath());
                } else {
                    throw CheckFailedException.newInstance("\u6c34\u5370\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                }
                BigDecimal imgWidth = waterMarkVO.getImgWidth();
                BigDecimal imgHeight = waterMarkVO.getImgHeight();
                if (imgWidth != null && imgHeight != null) {
                    image.scaleToFit(imgWidth.floatValue(), imgHeight.floatValue());
                } else {
                    imgWidth = BigDecimal.valueOf(image.getPlainWidth());
                    waterMarkVO.setImgWidth(imgWidth);
                    imgHeight = BigDecimal.valueOf(image.getPlainHeight());
                    waterMarkVO.setImgHeight(imgHeight);
                }
                if (null != waterMarkVO.getDegrees()) {
                    image.setRotationDegrees(waterMarkVO.getDegrees().floatValue());
                }
                PdfGState gs = new PdfGState();
                if (null != waterMarkVO.getOpacity()) {
                    gs.setFillOpacity(waterMarkVO.getOpacity().floatValue());
                    gs.setStrokeOpacity(waterMarkVO.getOpacity().floatValue());
                }
                Rectangle rectangle = reader.getPageSizeWithRotation(1);
                for (int i = 0; i < reader.getNumberOfPages(); ++i) {
                    PdfContentByte content = stamper.getUnderContent(i + 1);
                    content.setGState(gs);
                    if (waterMarkVO.isRepeat()) {
                        this.setWaterMarkForRepeat(rectangle, image, content, waterMarkVO);
                        continue;
                    }
                    this.setWaterMarkForNoRepeat(rectangle, image, content, waterMarkVO);
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block12;
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void checkArguments(PdfReader reader, PdfStamper stamper, ImageWaterMarkVO waterMarkVO) {
        if (null == reader) {
            throw new EcpCheckException("ERR.PDF.UTIL.001", "\u5165\u53c2PdfReader\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (null == stamper) {
            throw new EcpCheckException("ERR.PDF.UTIL.001", "\u5165\u53c2PdfStamper\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (null == waterMarkVO) {
            throw new EcpCheckException("ERR.PDF.UTIL.001", "\u5165\u53c2waterMarkVO\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (StringUtils.isEmpty((CharSequence)waterMarkVO.getImgPath()) && waterMarkVO.getImgData() == null) {
            throw new EcpCheckException("ERR.PDF.UTIL.001", "imgPath\u548cimgData\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002");
        }
    }

    private void setWaterMarkForRepeat(Rectangle rectangle, Image image, PdfContentByte content, ImageWaterMarkVO waterMarkVO) {
        block4: {
            BigDecimal halfUnit = new BigDecimal("2");
            int scale = 8;
            BigDecimal pageWidth = BigDecimal.valueOf(rectangle.getWidth());
            BigDecimal imgWidth = waterMarkVO.getImgWidth();
            BigDecimal repeatCountX = waterMarkVO.getRepeatCountX();
            BigDecimal imgXSpace = pageWidth.subtract(imgWidth.multiply(repeatCountX)).divide(repeatCountX, 8, RoundingMode.HALF_UP);
            BigDecimal imgXMovement = BigDecimal.ZERO.subtract(imgWidth.divide(halfUnit, 8, RoundingMode.HALF_UP));
            BigDecimal pageHeight = BigDecimal.valueOf(rectangle.getHeight());
            BigDecimal imgHeight = waterMarkVO.getImgHeight();
            BigDecimal repeatCountY = waterMarkVO.getRepeatCountY();
            BigDecimal imgYSpace = pageHeight.subtract(imgHeight.multiply(repeatCountY)).divide(repeatCountY, 8, RoundingMode.HALF_UP);
            BigDecimal imgYMovement = BigDecimal.ZERO.subtract(imgHeight.divide(halfUnit, 8, RoundingMode.HALF_UP));
            try {
                for (int j = 0; j < repeatCountY.intValue() + 1; ++j) {
                    float currentY = imgYMovement.floatValue() + (float)j * (imgHeight.floatValue() + imgYSpace.floatValue());
                    for (int k = 0; k < repeatCountX.intValue() + 1; ++k) {
                        float currentX = imgXMovement.floatValue() + (float)k * (imgWidth.floatValue() + imgXSpace.floatValue());
                        image.setAbsolutePosition(currentX, currentY);
                        content.addImage(image);
                    }
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void setWaterMarkForNoRepeat(Rectangle rectangle, Image image, PdfContentByte content, ImageWaterMarkVO waterMarkVO) {
        block2: {
            BigDecimal pageHeight = BigDecimal.valueOf(rectangle.getHeight());
            BigDecimal pageWidth = BigDecimal.valueOf(rectangle.getWidth());
            BigDecimal imgWidth = waterMarkVO.getImgWidth();
            BigDecimal imgHeight = waterMarkVO.getImgHeight();
            BigDecimal halfUnit = new BigDecimal("2");
            BigDecimal halfPageWidth = pageWidth.divide(halfUnit, RoundingMode.HALF_UP);
            BigDecimal halfImgWidth = imgWidth.divide(halfUnit, RoundingMode.HALF_UP);
            float absoluteX = halfPageWidth.subtract(halfImgWidth).floatValue();
            BigDecimal halfPageHeight = pageHeight.divide(halfUnit, RoundingMode.HALF_UP);
            BigDecimal halfImgHeight = imgHeight.divide(halfUnit, RoundingMode.HALF_UP);
            float absoluteY = halfPageHeight.subtract(halfImgHeight).floatValue();
            image.setAbsolutePosition(absoluteX, absoluteY);
            try {
                content.addImage(image);
            }
            catch (DocumentException e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

