/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.document.function.impl;

import com.ygsoft.abc.service.document.function.WordTransferFunction;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.StreamUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.HWPFDocumentCore;
import org.apache.poi.hwpf.converter.WordToHtmlConverter;
import org.w3c.dom.Document;

public final class Word2003TransferFunction
implements WordTransferFunction {
    private static final IEcpLog LOG = EcpLogFactory.getLog(Word2003TransferFunction.class);
    public static final Word2003TransferFunction INSTANCE = new Word2003TransferFunction();

    private Word2003TransferFunction() {
    }

    @Override
    public String transfer2Html(String templatePath) {
        HWPFDocument document = Word2003TransferFunction.getHWPFDocument(templatePath);
        return this.doc2Html(document);
    }

    @Override
    public String transfer2Html(InputStream is) {
        HWPFDocument document = Word2003TransferFunction.getHWPFDocument(is);
        return this.doc2Html(document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doc2Html(HWPFDocument wordDocument) {
        String content = "";
        ByteArrayOutputStream os = null;
        try {
            WordToHtmlConverter wordToHtmlConverter = new WordToHtmlConverter(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument());
            wordToHtmlConverter.processDocument((HWPFDocumentCore)wordDocument);
            Document htmlDocument = wordToHtmlConverter.getDocument();
            DOMSource domSource = new DOMSource(htmlDocument);
            os = new ByteArrayOutputStream();
            StreamResult streamResult = new StreamResult(os);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer serializer = tf.newTransformer();
            serializer.setOutputProperty("encoding", "utf-8");
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("method", "html");
            serializer.transform(domSource, streamResult);
            content = new String(os.toByteArray(), "utf-8");
            StreamUtil.closeStream((OutputStream)os);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        finally {
            StreamUtil.closeStream(os);
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static HWPFDocument getHWPFDocument(String path) {
        HWPFDocument hWPFDocument;
        FileInputStream is = null;
        try {
            HWPFDocument document;
            is = new FileInputStream(new File(path));
            hWPFDocument = document = new HWPFDocument((InputStream)is);
        }
        catch (Exception e) {
            try {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                StreamUtil.closeStream(is);
                throw throwable;
            }
            StreamUtil.closeStream((InputStream)is);
            return null;
        }
        StreamUtil.closeStream((InputStream)is);
        return hWPFDocument;
    }

    private static HWPFDocument getHWPFDocument(InputStream is) {
        try {
            HWPFDocument document = new HWPFDocument(is);
            return document;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

