/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.document.listener;

import com.itextpdf.text.Document;
import com.itextpdf.text.Font;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import com.ygsoft.abc.service.document.util.ITextPdfUtil;
import com.ygsoft.abc.service.document.vo.FooterConfigVO;
import com.ygsoft.abc.service.document.vo.PageConfigVO;
import com.ygsoft.abc.service.types.YesnoEnum;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import org.apache.commons.lang3.StringUtils;

public class ITextPdfDefaultFooterEvent
extends PdfPageEventHelper {
    private static final IEcpLog LOG = EcpLogFactory.getLog(ITextPdfDefaultFooterEvent.class);
    private PageConfigVO pageConfigVO;
    private FooterConfigVO footerConfigVO;
    public PdfTemplate totalNumTemplate;
    private static BaseFont BASE_FONT;
    private static Font FONT;

    public ITextPdfDefaultFooterEvent() {
        this.pageConfigVO = new PageConfigVO();
        this.footerConfigVO = new FooterConfigVO();
        this.createBaseFont();
    }

    public ITextPdfDefaultFooterEvent(PageConfigVO pageConfigVO, FooterConfigVO footerConfigVO) {
        this.pageConfigVO = pageConfigVO;
        this.footerConfigVO = footerConfigVO;
        this.createBaseFont();
    }

    private void createBaseFont() {
        try {
            BASE_FONT = StringUtils.isNotEmpty((CharSequence)this.footerConfigVO.getFontPath()) ? BaseFont.createFont((String)this.footerConfigVO.getFontPath(), (String)"Identity-H", (boolean)false) : BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
            FONT = new Font(BASE_FONT, this.footerConfigVO.getFontSize().floatValue());
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void onEndPage(PdfWriter writer, Document document) {
        try {
            this.addPageFooter(writer, document);
        }
        catch (Exception e) {
            LOG.error((Object)"\u6dfb\u52a0\u9875\u7709\u51fa\u9519", (Throwable)e);
        }
    }

    public void onOpenDocument(PdfWriter writer, Document document) {
        this.totalNumTemplate = writer.getDirectContent().createTemplate(50.0f, 50.0f);
    }

    public void onCloseDocument(PdfWriter writer, Document document) {
        this.totalNumTemplate.beginText();
        this.totalNumTemplate.setFontAndSize(BASE_FONT, this.footerConfigVO.getFontSize().floatValue());
        this.totalNumTemplate.showText(" " + writer.getPageNumber() + " \u9875");
        this.totalNumTemplate.endText();
        this.totalNumTemplate.closePath();
    }

    private void addPageFooter(PdfWriter writer, Document document) {
        PdfContentByte pdfContentByte = writer.getDirectContent();
        String footTextLeft = "\u7b2c " + writer.getPageNumber() + " \u9875 / \u5171";
        Phrase footer = new Phrase(footTextLeft, FONT);
        float len = BASE_FONT.getWidthPoint(footTextLeft, this.footerConfigVO.getFontSize().floatValue());
        float urx1 = (document.rightMargin() + document.right() + document.leftMargin() - document.left() - len) / 2.0f + 20.0f;
        float urx2 = (document.rightMargin() + document.right() + document.leftMargin() - document.left()) / 2.0f + 20.0f;
        float ury = document.bottom() - 25.0f;
        ColumnText.showTextAligned((PdfContentByte)pdfContentByte, (int)1, (Phrase)footer, (float)urx1, (float)ury, (float)0.0f);
        pdfContentByte.addTemplate(this.totalNumTemplate, urx2, ury);
        if (this.footerConfigVO.getIsShowUpperLine() == YesnoEnum.YES) {
            this.showUpperLine(writer);
        }
    }

    private void showUpperLine(PdfWriter writer) {
        Rectangle rectangle = ITextPdfUtil.getRectangle(this.pageConfigVO);
        PdfPTable table = new PdfPTable(1);
        PdfPCell blankCell = new PdfPCell(new Phrase("", FONT));
        blankCell.disableBorderSide(14);
        table.addCell(blankCell);
        table.setTotalWidth(rectangle.getWidth() - (this.pageConfigVO.getMarginLeft().floatValue() + this.pageConfigVO.getMarginRight().floatValue()));
        table.writeSelectedRows(0, -1, this.pageConfigVO.getMarginLeft().floatValue(), 30.0f, writer.getDirectContent());
    }
}

