/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.document.type;

import com.ygsoft.abc.service.exception.CheckFailedException;

public enum FontType {
    ST("\u5b8b\u4f53", "simsun.ttc", "SimSun", "font-family: SimSun;", "(font-family:)(\\s*)(\u5b8b\u4f53;)"),
    FS("\u4eff\u5b8b", "simfang.ttf", "FangSong", "font-family: FangSong;", "(font-family:)(\\s*)(\u4eff\u5b8b;)"),
    XST("\u65b0\u5b8b\u4f53", "simsun.ttc", "NSimSun", "font-family: NSimSun;", "(font-family:)(\\s*)(\u65b0\u5b8b\u4f53;)"),
    HT("\u9ed1\u4f53", "simhei.ttf", "SimHei", "font-family: SimHei;", "(font-family:)(\\s*)(\u9ed1\u4f53;)"),
    KT("\u6977\u4f53", "simkai.ttf", "KaiTi", "font-family: KaiTi;", "(font-family:)(\\s*)(\u6977\u4f53;)"),
    HWST("\u534e\u6587\u5b8b\u4f53", "STSONG.TTF", "STSong", "font-family: STSong;", "(font-family:)(\\s*)(\u534e\u6587\u5b8b\u4f53;)"),
    HWFS("\u534e\u6587\u4eff\u5b8b", "STFANGSO.TTF", "STFangsong", "font-family: STFangsong;", "(font-family:)(\\s*)(\u534e\u6587\u4eff\u5b8b;)"),
    HWXH("\u534e\u6587\u7ec6\u9ed1", "STXIHEI.TTF", "STXihei", "font-family: STXihei;", "(font-family:)(\\s*)(\u534e\u6587\u7ec6\u9ed1;)"),
    HWKT("\u534e\u6587\u6977\u4f53", "STKAITI.TTF", "STKaiti", "font-family: STKaiti;", "(font-family:)(\\s*)(\u534e\u6587\u6977\u4f53;)"),
    HWXK("\u534e\u6587\u884c\u6977", "STXINGKA.TTF", "STXingkai", "font-family: STXingkai;", "(font-family:)(\\s*)(\u534e\u6587\u884c\u6977;)"),
    FZYT("\u65b9\u6b63\u59da\u4f53", "FZYTK.TTF", "FZYaoTi", "font-family: FZYaoTi;", "(font-family:)(\\s*)(\u65b9\u6b63\u59da\u4f53;)"),
    FZST("\u65b9\u6b63\u8212\u4f53", "FZSTK.TTF", "FZShuTi", "font-family: FZShuTi;", "(font-family:)(\\s*)(\u65b9\u6b63\u8212\u4f53;)"),
    WRYH("\u5fae\u8f6f\u96c5\u9ed1\uff08\u5e38\u89c4\uff09", "msyh.ttc", "Microsoft YaHei", "font-family: Microsoft YaHei;", "(font-family:)(\\s*)(\u5fae\u8f6f\u96c5\u9ed1;)");

    private String desc;
    private String fileName;
    private String fontName;
    private String cssStyle;
    private String cssRegx;

    public static FontType getByFontName(String fontName) {
        for (FontType fontType : FontType.values()) {
            if (!fontType.getFontName().equals(fontName)) continue;
            return fontType;
        }
        throw CheckFailedException.newInstance("\u4e0d\u652f\u6301\u7684\u5b57\u4f53\u7c7b\u578b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002fontName=" + fontName);
    }

    private FontType(String desc, String fileName, String fontName, String cssStyle, String cssRegx) {
        this.desc = desc;
        this.fileName = fileName;
        this.fontName = fontName;
        this.cssStyle = cssStyle;
        this.cssRegx = cssRegx;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public String getCssStyle() {
        return this.cssStyle;
    }

    public void setCssStyle(String cssStyle) {
        this.cssStyle = cssStyle;
    }

    public String getCssRegx() {
        return this.cssRegx;
    }

    public void setCssRegx(String cssRegx) {
        this.cssRegx = cssRegx;
    }
}

