/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.document.util;

import com.ygsoft.abc.service.document.function.impl.Excel2003TransferFunction;
import com.ygsoft.ecp.service.exception.EcpCheckException;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Entities;
import org.jsoup.select.Elements;

public final class ExcelUtil {
    private static final IEcpLog LOG = EcpLogFactory.getLog(ExcelUtil.class);
    private static final String REGEX_BODY_TAG = "<body([\\s\\S]*?)>";
    private static final String REGEX_FONT_FAMILY = "(font-family)([\\s\\S]*?)(;)";
    private static final String REGEX_SHEET_NAME = "<h2>([\\s\\S]*?)</h2>";
    private static final String REGEX_COLUMN_NAME = "<thead>[\\s\\S]*?</thead>";
    private static final String REGEX_STYLE_TAG = "<style([\\s\\S]*?)>";
    private static final String REGEX_ROW_NUMBER = "<th class=\"rownumber\">([\\s\\S]*?)</th>";
    private static final String IMG_PLACEHOLDER_REGEX = "\\#\\{.*?\\}";
    private static final Pattern IMG_PLACEHOLDER_PATTERN = Pattern.compile("\\#\\{.*?\\}");
    private static final String PAGE_DOM = "<div style='page-break-before:always'></div>";
    private static final String AVOID_TR_BREAK_CSS = "table tr{ page-break-inside: avoid;}";
    private static final String IMAGE_SCALE_HEIGHT = System.getProperty("image.scale.height", "35");

    private ExcelUtil() {
    }

    public static String transferExcel2Html(HSSFWorkbook excelBook, String fontName, boolean isScaleImage) {
        String html;
        block4: {
            if (null == excelBook) {
                throw new EcpCheckException("ERR.EXCEL.UTIL.001", "\u5165\u53c2excelBook\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            if (StringUtils.isEmpty((CharSequence)fontName)) {
                throw new EcpCheckException("ERR.EXCEL.UTIL.001", "\u5165\u53c2fontName\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            html = "";
            try {
                html = Excel2003TransferFunction.INSTANCE.transfer2Html(excelBook, fontName);
                html = ExcelUtil.handleSheetName(html);
                html = ExcelUtil.clearColumnNameAndRownum(html);
                html = ExcelUtil.handleFontFamily(html, fontName);
                html = ExcelUtil.translationHtmlTag(html);
                html = ExcelUtil.avoidTrBreak(html);
                html = ExcelUtil.handleImagePlaceholder(html, isScaleImage);
                html = ExcelUtil.formatHtml(html);
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return html;
    }

    public static String transferExcel2Html(String templatePath, String fontName, boolean isScaleImage) {
        String html;
        block7: {
            if (StringUtils.isEmpty((CharSequence)templatePath)) {
                throw new EcpCheckException("ERR.EXCEL.UTIL.001", "\u5165\u53c2templatePath\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            if (StringUtils.isEmpty((CharSequence)fontName)) {
                throw new EcpCheckException("ERR.EXCEL.UTIL.001", "\u5165\u53c2fontName\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            if (!templatePath.endsWith(".xls") && !templatePath.endsWith(".xlsx")) {
                throw new EcpCheckException("ERR.EXCEL.UTIL.002", "\u975e\u6cd5\u683c\u5f0f\u3002");
            }
            html = "";
            try {
                if (templatePath.endsWith(".xls")) {
                    html = Excel2003TransferFunction.INSTANCE.transfer2Html(templatePath, fontName);
                }
                if (templatePath.endsWith(".xlsx")) {
                    throw new EcpCheckException("ERR.EXCEL.UTIL.003", "\u6682\u4e0d\u652f\u6301xlsx\u6587\u6863\u683c\u5f0f\u3002");
                }
                html = ExcelUtil.handleSheetName(html);
                html = ExcelUtil.clearColumnNameAndRownum(html);
                html = ExcelUtil.handleFontFamily(html, fontName);
                html = ExcelUtil.translationHtmlTag(html);
                html = ExcelUtil.avoidTrBreak(html);
                html = ExcelUtil.handleImagePlaceholder(html, isScaleImage);
                html = ExcelUtil.formatHtml(html);
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block7;
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return html;
    }

    private static String formatHtml(String html) {
        Document doc = Jsoup.parse((String)html);
        String style = doc.attr("style");
        if (StringUtils.isNotEmpty((CharSequence)style) && style.contains("width")) {
            doc.attr("style", "");
        }
        Elements divs = doc.select("div");
        for (Element div : divs) {
            String divStyle = div.attr("style");
            if (!StringUtils.isNotEmpty((CharSequence)divStyle) || !divStyle.contains("width")) continue;
            div.attr("style", "");
        }
        doc.outputSettings().syntax(Document.OutputSettings.Syntax.xml);
        doc.outputSettings().escapeMode(Entities.EscapeMode.xhtml);
        return doc.html();
    }

    private static String translationHtmlTag(String html) {
        return html.replaceAll("&lt;", "<").replaceAll("&gt;", ">");
    }

    private static String avoidTrBreak(String html) {
        Pattern pattern = Pattern.compile(REGEX_STYLE_TAG);
        Matcher m = pattern.matcher(html);
        if (m.find()) {
            String targetStr = m.group(0);
            return html.replace(targetStr, targetStr + AVOID_TR_BREAK_CSS);
        }
        return html;
    }

    private static String handleImagePlaceholder(String html, boolean isScaleImage) {
        Matcher matcher = IMG_PLACEHOLDER_PATTERN.matcher(html);
        String htmlTemp = html;
        while (matcher.find()) {
            int height;
            String tmp = matcher.group();
            String[] tmpArr = tmp.substring(2, tmp.length() - 1).split(",");
            String key = tmpArr[0];
            String imgText = "";
            if (tmpArr.length > 1) {
                height = Integer.parseInt(tmpArr[1]);
                imgText = "<img style=\"height:" + height + "px; \" src=\"data:image/png;base64, ${" + key + "}\" />";
            } else if (isScaleImage) {
                height = Integer.parseInt(IMAGE_SCALE_HEIGHT);
                imgText = "<img style=\"height:" + height + "px; \" src=\"data:image/png;base64, ${" + key + "}\" />";
            } else {
                imgText = "<img src=\"data:image/png;base64, ${" + key + "}\" />";
            }
            htmlTemp = htmlTemp.replace(tmp, imgText);
        }
        return htmlTemp;
    }

    private static String handleSheetName(String html) {
        Pattern pattern = Pattern.compile(REGEX_SHEET_NAME);
        Matcher matcher = pattern.matcher(html);
        String htmlTemp = html;
        int i = 0;
        while (matcher.find()) {
            String tmp = matcher.group();
            htmlTemp = i == 0 ? htmlTemp.replace(tmp, "") : htmlTemp.replace(tmp, PAGE_DOM);
            ++i;
        }
        return htmlTemp;
    }

    private static String clearColumnNameAndRownum(String html) {
        return html.replaceAll(REGEX_COLUMN_NAME, "").replaceAll(REGEX_ROW_NUMBER, "");
    }

    private static String handleFontFamily(String html, String fontName) {
        return html.replaceAll(REGEX_FONT_FAMILY, "").replaceAll(REGEX_BODY_TAG, "<body style=\"font-family:" + fontName + ";\">");
    }
}

