/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.document.util;

import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public final class FreemarkerUtil {
    private static final IEcpLog LOG = EcpLogFactory.getLog(FreemarkerUtil.class);
    private static Configuration CONFIG = new Configuration(Configuration.VERSION_2_3_22);
    private static String FTL_CLASS_PATH = System.getProperty("ftl.classpath.dir", "/template");
    private static String FTL_ABS_PATH = System.getProperty("ftl.absolute.dir", "");
    private static StringTemplateLoader STRING_TEMPLATE_LOADER;
    private static ClassTemplateLoader CLASS_TEMPLATE_LOADER;
    private static FileTemplateLoader FILE_TEMPLATE_LOADER;

    private FreemarkerUtil() {
    }

    public static String renderFromStr(String templateContent, Object param) {
        String strFtlName = "default_ftl_name";
        CONFIG.setTemplateLoader((TemplateLoader)STRING_TEMPLATE_LOADER);
        STRING_TEMPLATE_LOADER.putTemplate("default_ftl_name", templateContent);
        return FreemarkerUtil.process("default_ftl_name", param);
    }

    public static String renderFromClassPath(String templateName, Object param) {
        CONFIG.setTemplateLoader((TemplateLoader)CLASS_TEMPLATE_LOADER);
        return FreemarkerUtil.process(templateName, param);
    }

    public static String renderFromFile(String templateName, Object param) {
        CONFIG.setTemplateLoader((TemplateLoader)FILE_TEMPLATE_LOADER);
        return FreemarkerUtil.process(templateName, param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String process(String templateName, Object param) {
        String string;
        StringWriter writer = null;
        try {
            Template template = CONFIG.getTemplate(templateName);
            writer = new StringWriter();
            template.process(param, (Writer)writer);
            string = writer.toString();
        }
        catch (TemplateException | IOException e) {
            String string2;
            try {
                LOG.error((Object)"\u6a21\u677f\u6e32\u67d3\u5931\u8d25\u3002", e);
                string2 = "";
            }
            catch (Throwable throwable) {
                FreemarkerUtil.closeStringWriter(writer);
                throw throwable;
            }
            FreemarkerUtil.closeStringWriter(writer);
            return string2;
        }
        FreemarkerUtil.closeStringWriter(writer);
        return string;
    }

    private static void closeStringWriter(Writer writer) {
        try {
            if (null != writer) {
                writer.close();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"StringWriter\u5173\u95ed\u5f02\u5e38\u3002", (Throwable)e);
        }
    }

    static {
        try {
            CONFIG.setDefaultEncoding("UTF-8");
            CONFIG.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
            STRING_TEMPLATE_LOADER = new StringTemplateLoader();
            CLASS_TEMPLATE_LOADER = new ClassTemplateLoader(FreemarkerUtil.class, FTL_CLASS_PATH);
            FILE_TEMPLATE_LOADER = new FileTemplateLoader(new File(FTL_ABS_PATH));
        }
        catch (IOException e) {
            LOG.error((Object)"Freemarker Configuration\u521d\u59cb\u5316\u5931\u8d25\u3002", (Throwable)e);
        }
    }
}

