/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.document.util;

import com.itextpdf.text.Document;
import com.itextpdf.text.FontProvider;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.RectangleReadOnly;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.tool.xml.XMLWorkerFontProvider;
import com.itextpdf.tool.xml.XMLWorkerHelper;
import com.ygsoft.abc.service.document.listener.ITextHeaderFooterHandler;
import com.ygsoft.abc.service.document.type.PaperDirection;
import com.ygsoft.abc.service.document.vo.FooterConfigVO;
import com.ygsoft.abc.service.document.vo.HeaderConfigVO;
import com.ygsoft.abc.service.document.vo.PageConfigVO;
import com.ygsoft.abc.service.exception.CheckFailedException;
import com.ygsoft.abc.service.types.YesnoEnum;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.PaperSize;

public final class ITextPdfUtil {
    private static final IEcpLog LOG = EcpLogFactory.getLog(ITextPdfUtil.class);
    private static final Pattern TABLE_TAG_PATTERN = Pattern.compile("<table([\\s\\S]*?)>");

    private ITextPdfUtil() {
    }

    public static ByteArrayOutputStream transferHtml2PDF(InputStream htmlInput, PageConfigVO pageConfigVO, HeaderConfigVO headerConfig, FooterConfigVO footerConfig) {
        try {
            byte[] bytes = StreamUtil.getBytes((InputStream)htmlInput);
            String html = new String(bytes);
            return ITextPdfUtil.transferHtml2PDF(html, pageConfigVO, headerConfig, footerConfig, null, null);
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static ByteArrayOutputStream transferHtml2PDF(String html, PageConfigVO pageConfigVO, HeaderConfigVO headerConfig, FooterConfigVO footerConfig) {
        return ITextPdfUtil.transferHtml2PDF(html, pageConfigVO, headerConfig, footerConfig, null, null);
    }

    public static ByteArrayOutputStream transferHtml2PDF(InputStream htmlInput, PageConfigVO pageConfigVO, PdfPageEventHelper headerHelper, PdfPageEventHelper footerHelper) {
        try {
            byte[] bytes = StreamUtil.getBytes((InputStream)htmlInput);
            String html = new String(bytes);
            return ITextPdfUtil.transferHtml2PDF(html, pageConfigVO, null, null, headerHelper, footerHelper);
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static ByteArrayOutputStream transferHtml2PDF(String html, PageConfigVO pageConfigVO, PdfPageEventHelper headerHelper, PdfPageEventHelper footerHelper) {
        return ITextPdfUtil.transferHtml2PDF(html, pageConfigVO, null, null, headerHelper, footerHelper);
    }

    public static ByteArrayOutputStream transferHtml2PDF(InputStream htmlInput, PageConfigVO pageConfigVO) {
        try {
            byte[] bytes = StreamUtil.getBytes((InputStream)htmlInput);
            String html = new String(bytes);
            return ITextPdfUtil.transferHtml2PDF(html, pageConfigVO);
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static ByteArrayOutputStream transferHtml2PDF(String html, PageConfigVO pageConfigVO) {
        return ITextPdfUtil.transferHtml2PDF(html, pageConfigVO, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteArrayOutputStream transferHtml2PDF(String html, PageConfigVO pageConfigVO, HeaderConfigVO headerConfig, FooterConfigVO footerConfig, PdfPageEventHelper headerHelper, PdfPageEventHelper footerHelper) {
        if (StringUtils.isEmpty((CharSequence)html)) {
            return new ByteArrayOutputStream();
        }
        Document document = new Document(ITextPdfUtil.getRectangle(pageConfigVO));
        String tempHtml = html;
        if (pageConfigVO.getRepeatTableHeader() == YesnoEnum.YES) {
            tempHtml = ITextPdfUtil.repeatTableHeader(tempHtml);
        }
        document.setMargins(pageConfigVO.getMarginLeft().floatValue(), pageConfigVO.getMarginRight().floatValue(), pageConfigVO.getMarginTop().floatValue(), pageConfigVO.getMarginBottom().floatValue());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PdfWriter writer = null;
        try {
            writer = PdfWriter.getInstance((Document)document, (OutputStream)bos);
            ITextHeaderFooterHandler.handleHeaderAndFooter(writer, pageConfigVO, headerConfig, footerConfig, headerHelper, footerHelper);
            document.open();
            String fontPath = System.getProperty("pdf.font.dir", "");
            XMLWorkerHelper.getInstance().parseXHtml(writer, document, (InputStream)new ByteArrayInputStream(tempHtml.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8, (FontProvider)new XMLWorkerFontProvider(fontPath));
            document.close();
            ByteArrayOutputStream byteArrayOutputStream = bos;
            return byteArrayOutputStream;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            ByteArrayOutputStream byteArrayOutputStream = null;
            return byteArrayOutputStream;
        }
        finally {
            if (null != writer) {
                writer.close();
            }
            StreamUtil.closeStream((OutputStream)bos);
        }
    }

    public static Rectangle getRectangle(PageConfigVO pageConfigVO) {
        Rectangle rectangle;
        if (null == pageConfigVO) {
            return PageSize.A4;
        }
        PaperSize paperSize = pageConfigVO.getPaperSize();
        if (null == paperSize) {
            return PageSize.A4;
        }
        if (paperSize == PaperSize.A3_PAPER) {
            rectangle = PageSize.A3;
        } else if (paperSize == PaperSize.A5_PAPER) {
            rectangle = PageSize.A5;
        } else if (paperSize == PaperSize.A4_PAPER) {
            rectangle = PageSize.A4;
        } else {
            throw CheckFailedException.newInstance("\u6682\u4e0d\u652f\u6301\u7684\u7eb8\u5f20\u5927\u5c0f\u3002PaperSize=" + paperSize.toString());
        }
        if (pageConfigVO.getPaperDirection() == PaperDirection.LANDSCAPE) {
            return new RectangleReadOnly(rectangle.getHeight(), rectangle.getWidth());
        }
        return rectangle;
    }

    private static String repeatTableHeader(String html) {
        String tempHtml = html;
        Matcher m = TABLE_TAG_PATTERN.matcher(tempHtml);
        if (m.find()) {
            String targetStr = m.group(0);
            String styleTag = "style=\"";
            if (targetStr.contains("style=\"")) {
                String repeatHeaderCss = targetStr.replace("style=\"", "style=\"repeat-header:yes;");
                tempHtml = tempHtml.replace(targetStr, repeatHeaderCss);
            } else {
                String bodyTag = "<table";
                String repeatHeaderCss = targetStr.replace("style=\"", "style=\"repeat-header:yes;");
                tempHtml = tempHtml.replace("<table", "<table style=\"repeat-header:yes;\"");
            }
        }
        return tempHtml;
    }
}

