/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.document.util;

import com.itextpdf.text.Image;
import com.itextpdf.text.pdf.PdfCopy;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.codec.Base64;
import com.ygsoft.abc.service.document.function.WaterMarkFunction;
import com.ygsoft.abc.service.document.function.impl.ImageWaterMarkFunction;
import com.ygsoft.abc.service.document.function.impl.TextWaterMarkFunction;
import com.ygsoft.abc.service.document.util.ITextRenderUtil;
import com.ygsoft.abc.service.document.vo.ImageWaterMarkVO;
import com.ygsoft.abc.service.document.vo.PageConfigVO;
import com.ygsoft.abc.service.document.vo.TextWaterMarkVO;
import com.ygsoft.abc.service.exception.CheckFailedException;
import com.ygsoft.ecp.service.exception.EcpCheckException;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.ConvertUtil;
import com.ygsoft.ecp.service.tool.StreamUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.poi.ss.usermodel.PaperSize;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Entities;
import org.w3c.dom.Element;
import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.extend.ReplacedElement;
import org.xhtmlrenderer.extend.ReplacedElementFactory;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.pdf.ITextFSImage;
import org.xhtmlrenderer.pdf.ITextImageElement;
import org.xhtmlrenderer.pdf.ITextRenderer;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.simple.extend.FormSubmissionListener;

public final class PdfUtil {
    private static final IEcpLog LOG = EcpLogFactory.getLog(PdfUtil.class);
    private static final Integer DPI = 100;
    private static final String IMG_TYPE = "png";
    private static final String BLANK_SIZE = System.getProperty("pdf.blank.size", "200");
    private static final String STYLE_TAG_REGEX = "<style([\\s\\S]*?)>";
    private static final Pattern STYLE_TAG_PATTERN = Pattern.compile("<style([\\s\\S]*?)>");

    private PdfUtil() {
    }

    public static ByteArrayOutputStream mergePdfByClassPath(List<String> classPaths) {
        ArrayList<PdfReader> pdfReaders = new ArrayList<PdfReader>();
        try {
            for (String classPath : classPaths) {
                InputStream in = PdfUtil.class.getResourceAsStream(classPath);
                PdfReader pdfReader1 = new PdfReader(in);
                pdfReaders.add(pdfReader1);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return PdfUtil.mergePdf(pdfReaders);
    }

    public static ByteArrayOutputStream mergePdfByAbsolutePath(List<String> absolutePaths) {
        ArrayList<PdfReader> pdfReaders = new ArrayList<PdfReader>();
        try {
            for (String absolutePath : absolutePaths) {
                PdfReader pdfReader1 = new PdfReader(absolutePath);
                pdfReaders.add(pdfReader1);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return PdfUtil.mergePdf(pdfReaders);
    }

    public static ByteArrayOutputStream mergePdfByBos(List<ByteArrayOutputStream> byteArrayOutputStreams) {
        ArrayList<PdfReader> pdfReaders = new ArrayList<PdfReader>();
        try {
            for (ByteArrayOutputStream bos : byteArrayOutputStreams) {
                PdfReader pdfReader1 = new PdfReader(bos.toByteArray());
                pdfReaders.add(pdfReader1);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return PdfUtil.mergePdf(pdfReaders);
    }

    public static ByteArrayOutputStream mergePdfByBytes(List<byte[]> pdfByteList) {
        ArrayList<PdfReader> pdfReaders = new ArrayList<PdfReader>();
        try {
            for (byte[] pdfByte : pdfByteList) {
                PdfReader pdfReader1 = new PdfReader(pdfByte);
                pdfReaders.add(pdfReader1);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return PdfUtil.mergePdf(pdfReaders);
    }

    public static ByteArrayOutputStream mergePdfByInputStream(List<InputStream> inputStreams) {
        ArrayList<PdfReader> pdfReaders = new ArrayList<PdfReader>();
        try {
            for (InputStream is : inputStreams) {
                PdfReader pdfReader1 = new PdfReader(is);
                pdfReaders.add(pdfReader1);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return PdfUtil.mergePdf(pdfReaders);
    }

    public static ByteArrayOutputStream addWaterMark(byte[] pdfBytes, TextWaterMarkVO textVO) {
        PdfUtil.checkArguments(pdfBytes, textVO);
        return PdfUtil.addWaterMarkCommon(pdfBytes, textVO, TextWaterMarkFunction.INSTANCE);
    }

    public static ByteArrayOutputStream addWaterMark(byte[] pdfBytes, ImageWaterMarkVO imageVO) {
        PdfUtil.checkArguments(pdfBytes, imageVO);
        return PdfUtil.addWaterMarkCommon(pdfBytes, imageVO, ImageWaterMarkFunction.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <T> ByteArrayOutputStream addWaterMarkCommon(byte[] pdfBytes, T t, WaterMarkFunction<T> func) {
        block6: {
            ByteArrayOutputStream byteArrayOutputStream;
            PdfReader reader = null;
            PdfStamper stamper = null;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                reader = new PdfReader(pdfBytes);
                PdfReader.unethicalreading = true;
                stamper = new PdfStamper(reader, (OutputStream)os);
                func.addWaterMark(reader, stamper, t);
                byteArrayOutputStream = os;
                PdfUtil.closePdfStamper(stamper);
            }
            catch (Exception e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
                break block6;
            }
            finally {
                PdfUtil.closePdfStamper(stamper);
                PdfUtil.closePdfReader(reader);
            }
            PdfUtil.closePdfReader(reader);
            return byteArrayOutputStream;
        }
        return null;
    }

    public static ByteArrayOutputStream transferHtml2PDF(InputStream htmlInput) {
        try {
            byte[] bytes = StreamUtil.getBytes((InputStream)htmlInput);
            String html = new String(bytes);
            return PdfUtil.transferHtml2PDF(html);
        }
        catch (IOException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            return new ByteArrayOutputStream();
        }
    }

    public static ByteArrayOutputStream transferHtml2PDF(InputStream htmlInput, PageConfigVO pageConfigVO) {
        try {
            byte[] bytes = StreamUtil.getBytes((InputStream)htmlInput);
            String html = new String(bytes);
            html = PdfUtil.paperConfig(html, pageConfigVO);
            return PdfUtil.transferHtml2PDF(html);
        }
        catch (IOException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            return new ByteArrayOutputStream();
        }
    }

    public static ByteArrayOutputStream transferHtml2PDF(String html) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ITextRenderer renderer = ITextRenderUtil.getITextRenderer();
            renderer.setDocumentFromString(html);
            renderer.layout();
            renderer.createPDF((OutputStream)outputStream);
            outputStream.flush();
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        finally {
            StreamUtil.closeStream((OutputStream)outputStream);
        }
        return outputStream;
    }

    public static ByteArrayOutputStream transferHtml2PDF(String html, PageConfigVO pageConfigVO) {
        String tempHtml = html;
        tempHtml = PdfUtil.paperConfig(tempHtml, pageConfigVO);
        return PdfUtil.transferHtml2PDF(tempHtml);
    }

    public static ByteArrayOutputStream transferHtmlWithImg2PDF(String html) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ITextRenderer renderer = ITextRenderUtil.getITextRenderer();
            renderer.getSharedContext().setReplacedElementFactory(new ReplacedElementFactory(){

                public ReplacedElement createReplacedElement(LayoutContext c, BlockBox box, UserAgentCallback uac, int cssWidth, int cssHeight) {
                    String attribute;
                    FSImage fsImage;
                    Element e = box.getElement();
                    if (e == null) {
                        return null;
                    }
                    String nodeName = e.getNodeName();
                    if (nodeName.equals("img") && (fsImage = PdfUtil.buildImage(attribute = e.getAttribute("src"), uac)) != null) {
                        if (cssWidth != -1 || cssHeight != -1) {
                            fsImage.scale(cssWidth, cssHeight);
                        }
                        return new ITextImageElement(fsImage);
                    }
                    return null;
                }

                public void reset() {
                }

                public void remove(Element e) {
                }

                public void setFormSubmissionListener(FormSubmissionListener listener) {
                }
            });
            renderer.getSharedContext().getTextRenderer().setSmoothingThreshold(1.0f);
            renderer.setDocumentFromString(html);
            renderer.layout();
            renderer.createPDF((OutputStream)outputStream);
            outputStream.flush();
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        finally {
            StreamUtil.closeStream((OutputStream)outputStream);
        }
        return outputStream;
    }

    protected static FSImage buildImage(String srcAttr, UserAgentCallback uac) {
        FSImage fiImg = null;
        if (srcAttr.toLowerCase().startsWith("data:image/")) {
            String base64Code = srcAttr.substring(srcAttr.indexOf("base64,") + "base64,".length());
            byte[] decodedBytes = Base64.decode((String)base64Code);
            try {
                fiImg = new ITextFSImage(Image.getInstance((byte[])decodedBytes));
            }
            catch (Exception ex) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        } else {
            fiImg = uac.getImageResource(srcAttr).getImage();
        }
        return fiImg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<byte[]> transferPDF2Image(byte[] pdfBytes) {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        PDDocument document = null;
        PDFRenderer renderer = null;
        try {
            document = PDDocument.load((byte[])pdfBytes);
            renderer = new PDFRenderer(document);
            for (int i = 0; i < document.getNumberOfPages(); ++i) {
                BufferedImage bufferedImage = renderer.renderImageWithDPI(i, (float)DPI.intValue());
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, IMG_TYPE, out);
                result.add(out.toByteArray());
                StreamUtil.closeStream((OutputStream)out);
            }
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        finally {
            PdfUtil.closePDDocument(document);
        }
        return result;
    }

    public static String formatHtml(String html) {
        Document doc = Jsoup.parse((String)html);
        doc.outputSettings().syntax(Document.OutputSettings.Syntax.xml);
        doc.outputSettings().escapeMode(Entities.EscapeMode.xhtml);
        return doc.html();
    }

    private static void checkArguments(byte[] pdfData, TextWaterMarkVO waterMarkVO) {
        if (null == pdfData || pdfData.length == 0) {
            throw new EcpCheckException("ERR.PDF.UTIL.001", "\u5165\u53c2pdfData\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (null == waterMarkVO) {
            throw new EcpCheckException("ERR.PDF.UTIL.001", "\u5165\u53c2waterMarkVO\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (StringUtils.isEmpty((CharSequence)waterMarkVO.getFontPath())) {
            throw new EcpCheckException("ERR.PDF.UTIL.001", "\u5165\u53c2waterMarkVO.fontPath\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (StringUtils.isEmpty((CharSequence)waterMarkVO.getText())) {
            throw new EcpCheckException("ERR.PDF.UTIL.001", "\u5165\u53c2waterMarkVO.text\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
    }

    private static void checkArguments(byte[] pdfData, ImageWaterMarkVO waterMarkVO) {
        if (null == pdfData || pdfData.length == 0) {
            throw new EcpCheckException("ERR.PDF.UTIL.001", "\u5165\u53c2pdfData\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (null == waterMarkVO) {
            throw new EcpCheckException("ERR.PDF.UTIL.001", "\u5165\u53c2waterMarkVO\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (StringUtils.isEmpty((CharSequence)waterMarkVO.getImgPath()) && waterMarkVO.getImgData() == null) {
            throw new EcpCheckException("ERR.PDF.UTIL.001", "imgPath\u548cimgData\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002");
        }
    }

    private static void closePdfStamper(PdfStamper stamper) {
        block3: {
            if (null != stamper) {
                try {
                    stamper.close();
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) break block3;
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private static void closePdfReader(PdfReader reader) {
        block3: {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) break block3;
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private static void closePDDocument(PDDocument document) {
        block3: {
            if (null != document) {
                try {
                    document.close();
                }
                catch (IOException e) {
                    if (!LOG.isErrorEnabled()) break block3;
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static ByteArrayOutputStream removeBlankPage(ByteArrayOutputStream outputStream) {
        return PdfUtil.removeBlankPage(outputStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteArrayOutputStream removeBlankPage(ByteArrayOutputStream outputStream, Integer blankSize) {
        PdfReader pdfReader = null;
        com.itextpdf.text.Document document = null;
        PdfCopy writer = null;
        int tempBlankSize = blankSize != null ? blankSize : ConvertUtil.toInt((Object)BLANK_SIZE);
        try {
            pdfReader = new PdfReader(outputStream.toByteArray());
            document = new com.itextpdf.text.Document(pdfReader.getPageSizeWithRotation(1));
            writer = new PdfCopy(document, (OutputStream)outputStream);
            document.open();
            PdfImportedPage page = null;
            for (int i = 1; i <= pdfReader.getNumberOfPages(); ++i) {
                byte[] bContent = pdfReader.getPageContent(i);
                ByteArrayOutputStream bs = new ByteArrayOutputStream();
                bs.write(bContent);
                if (bs.size() > tempBlankSize) {
                    page = writer.getImportedPage(pdfReader, i);
                    writer.addPage(page);
                }
                bs.close();
            }
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        finally {
            if (null != pdfReader) {
                pdfReader.close();
            }
            if (null != document) {
                document.close();
            }
            if (null != writer) {
                writer.close();
            }
        }
        return outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteArrayOutputStream mergePdf(List<PdfReader> pdfReaders) {
        com.itextpdf.text.Document document = null;
        ByteArrayOutputStream bos = null;
        PdfCopy pdfCopy = null;
        try {
            document = new com.itextpdf.text.Document();
            bos = new ByteArrayOutputStream();
            pdfCopy = new PdfCopy(document, (OutputStream)bos);
            document.open();
            for (PdfReader pdfReader : pdfReaders) {
                int numberOfPages = pdfReader.getNumberOfPages();
                for (int i = 1; i <= numberOfPages; ++i) {
                    document.newPage();
                    PdfImportedPage page = pdfCopy.getImportedPage(pdfReader, i);
                    pdfCopy.addPage(page);
                }
                pdfReader.close();
            }
            ByteArrayOutputStream byteArrayOutputStream = bos;
            return byteArrayOutputStream;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            ByteArrayOutputStream byteArrayOutputStream = null;
            return byteArrayOutputStream;
        }
        finally {
            if (null != document) {
                document.close();
            }
            if (null != pdfCopy) {
                pdfCopy.close();
            }
            StreamUtil.closeStream((OutputStream)bos);
        }
    }

    private static String paperConfig(String html, PageConfigVO pageConfigVO) {
        Matcher m = STYLE_TAG_PATTERN.matcher(html);
        if (m.find()) {
            String targetStr = m.group(0);
            return html.replace(targetStr, targetStr + PdfUtil.getPageConfigCss(pageConfigVO));
        }
        return html;
    }

    private static String getPageConfigCss(PageConfigVO pageConfigVO) {
        String paperSizeS;
        PaperSize paperSize = pageConfigVO.getPaperSize();
        if (paperSize == PaperSize.A3_PAPER) {
            paperSizeS = "A3";
        } else if (paperSize == PaperSize.A5_PAPER) {
            paperSizeS = "A5";
        } else if (paperSize == PaperSize.A4_PAPER) {
            paperSizeS = "A4";
        } else {
            throw CheckFailedException.newInstance("\u6682\u4e0d\u652f\u6301\u7684\u7eb8\u5f20\u5927\u5c0f\u3002PaperSize=" + paperSize.toString());
        }
        return "@page{size: " + paperSizeS + " " + pageConfigVO.getPaperDirection().getCss() + "; margin:" + pageConfigVO.getMarginTop() + " " + pageConfigVO.getMarginRight() + " " + pageConfigVO.getMarginBottom() + " " + pageConfigVO.getMarginLeft() + ";}";
    }
}

