/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.domain.vo;

import com.ygsoft.abc.service.exception.PermissionException;
import com.ygsoft.abc.service.tool.BlockValidatorUtil;
import com.ygsoft.ecp.service.model.IValueObject;
import org.springframework.web.multipart.MultipartFile;

public class FileNameVO
implements IValueObject {
    private static final long serialVersionUID = -4645030134807039439L;
    private String name;
    private String des;
    private String ext;

    public static FileNameVO newInstance(MultipartFile file) {
        return FileNameVO.newInstance(file.getOriginalFilename());
    }

    public static FileNameVO newInstance(String fileName) {
        if (!BlockValidatorUtil.checkFileName(fileName)) {
            throw PermissionException.newInstance("\u6587\u4ef6\u540d\u4e0d\u5408\u89c4\u3002");
        }
        int dotIndex = fileName.lastIndexOf(".");
        String realName = fileName.substring(0, dotIndex);
        String ext = fileName.substring(dotIndex + 1);
        FileNameVO fileNameVO = new FileNameVO();
        fileNameVO.setName(fileName);
        fileNameVO.setDes(realName);
        fileNameVO.setExt(ext);
        return fileNameVO;
    }

    public boolean isPDF() {
        return "PDF".equalsIgnoreCase(this.ext);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getDes() {
        return this.des;
    }

    public void setDes(String newDes) {
        this.des = newDes;
    }

    public String getExt() {
        return this.ext;
    }

    public void setExt(String newExt) {
        this.ext = newExt;
    }
}

