/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.domain.vo;

import com.itextpdf.text.pdf.security.PdfPKCS7;
import com.ygsoft.abc.service.exception.AbcServiceException;
import com.ygsoft.abc.service.tool.BlockDateUtil;
import com.ygsoft.ecp.service.model.IValueObject;
import java.security.cert.X509Certificate;
import java.util.Date;

public class SignatureDetailVO
implements IValueObject {
    private static final long serialVersionUID = 1546132245053325671L;
    private static final String DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private boolean verify;
    private String serialNo;
    private String issuerDN;
    private String subjectDN;
    private String notBefore;
    private String notAfter;
    private String signDate;
    private String location;

    public static SignatureDetailVO newFrom(PdfPKCS7 pdfPKCS7) {
        try {
            X509Certificate signCert = pdfPKCS7.getSigningCertificate();
            SignatureDetailVO entity = new SignatureDetailVO();
            entity.setVerify(pdfPKCS7.verify());
            entity.setSerialNo(signCert.getSerialNumber().toString());
            entity.setIssuerDN(signCert.getIssuerX500Principal().getName());
            entity.setSubjectDN(signCert.getSubjectX500Principal().getName());
            entity.setSignDate(SignatureDetailVO.format(pdfPKCS7.getSignDate().getTime()));
            entity.setNotBefore(SignatureDetailVO.format(signCert.getNotBefore()));
            entity.setNotAfter(SignatureDetailVO.format(signCert.getNotAfter()));
            entity.setLocation(pdfPKCS7.getLocation());
            return entity;
        }
        catch (Exception e) {
            throw new AbcServiceException("ABC.0015", e);
        }
    }

    private static String format(Date date) {
        return BlockDateUtil.formatDate(date, DATE_PATTERN);
    }

    public boolean isVerify() {
        return this.verify;
    }

    public void setVerify(boolean newVerify) {
        this.verify = newVerify;
    }

    public String getSerialNo() {
        return this.serialNo;
    }

    public void setSerialNo(String newSerialNo) {
        this.serialNo = newSerialNo;
    }

    public String getIssuerDN() {
        return this.issuerDN;
    }

    public void setIssuerDN(String newIssuerDN) {
        this.issuerDN = newIssuerDN;
    }

    public String getSubjectDN() {
        return this.subjectDN;
    }

    public void setSubjectDN(String newSubjectDN) {
        this.subjectDN = newSubjectDN;
    }

    public String getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(String newNotBefore) {
        this.notBefore = newNotBefore;
    }

    public String getNotAfter() {
        return this.notAfter;
    }

    public void setNotAfter(String newNotAfter) {
        this.notAfter = newNotAfter;
    }

    public String getSignDate() {
        return this.signDate;
    }

    public void setSignDate(String newSignDate) {
        this.signDate = newSignDate;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }
}

