/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.excel;

import com.alibaba.ans.shaded.com.alibaba.fastjson.JSON;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.utils.CollectionUtils;
import com.alibaba.fastjson.JSONArray;
import com.ygsoft.abc.service.consts.ExcelConst;
import com.ygsoft.abc.service.excel.IExcelExportHandler;
import com.ygsoft.ecp.service.exception.EcpRuntimeException;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;

public abstract class AbstractExcelExportHandler
implements IExcelExportHandler {
    private static final IEcpLog LOG = EcpLogFactory.getLog(AbstractExcelExportHandler.class);
    private static volatile Map<String, CellStyle> dataTypeCellStyleMap = new HashMap<String, CellStyle>();

    @Override
    public byte[] excuteExport(Map<String, Object> param, String configFilePath) {
        if (StringUtil.isEmptyString((String)configFilePath)) {
            throw new EcpRuntimeException("\u5bfc\u5165\u51fa\u9519", EcpI18nUtil.localizedString((String)"RedisClientFactory_excuteExport_63", (String)"\u5217\u89c4\u5219\u914d\u7f6e\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a\u3002"));
        }
        List<Map<String, String>> colRules = this.readColumnRule(configFilePath);
        List<Map<String, Object>> exportDatas = this.getExportData(param);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("\u5f85\u5bfc\u51fa\u7684\u6570\u636e--->>>" + JSON.toJSONString(exportDatas)));
        }
        return this.createExcel(exportDatas, colRules);
    }

    protected abstract List<Map<String, Object>> getExportData(Map<String, Object> var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] createExcel(List<Map<String, Object>> exportData, List<Map<String, String>> colRules) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet();
        int rowIndex = 0;
        int cellIndex = 0;
        HSSFRow row = sheet.createRow(rowIndex++);
        HSSFCell cell = null;
        String headerName = "";
        String columnName = "";
        HashMap<String, Map<String, String>> name2ColumnRule = new HashMap<String, Map<String, String>>();
        HashMap<String, Integer> name2ColumnIndex = new HashMap<String, Integer>();
        CellStyle headerCellStyle = AbstractExcelExportHandler.getTabHeaderCellStyle((Workbook)workbook);
        for (Map<String, String> map : colRules) {
            cell = row.createCell(cellIndex);
            headerName = map.get("columnText");
            columnName = map.get("columnName");
            name2ColumnRule.put(columnName, map);
            name2ColumnIndex.put(columnName, cellIndex);
            cell.setCellStyle(headerCellStyle);
            cell.setCellValue(headerName);
            sheet.setColumnWidth(cellIndex++, headerName.getBytes().length * 280);
        }
        HSSFCellStyle cellStyle = workbook.createCellStyle();
        for (Map<String, Object> map : exportData) {
            row = sheet.createRow(rowIndex++);
            for (String rowKey : map.keySet()) {
                Object value = map.get(rowKey);
                cell = row.createCell(((Integer)name2ColumnIndex.get(rowKey)).intValue());
                this.setCellValue((Workbook)workbook, (Cell)cell, value, (Map)name2ColumnRule.get(rowKey), (CellStyle)cellStyle);
            }
        }
        try {
            Throwable map = null;
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                workbook.write((OutputStream)byteArrayOutputStream);
                dataTypeCellStyleMap.clear();
                Object object = byteArrayOutputStream.toByteArray();
                return object;
            }
            catch (Throwable object) {
                Throwable throwable = object;
                throw object;
            }
        }
        catch (IOException iOException) {
            this.errorLog("\u6570\u636e\u6d41\u6587\u4ef6\u8f6c\u6362\u5f02\u5e38", iOException);
            return null;
        }
    }

    private void setCellValue(Workbook workbook, Cell cell, Object value, Map<String, String> rule, CellStyle cellStyle) {
        String dataType = rule.get("columnType");
        cell.setCellStyle(this.getCellStyleByDataType(workbook, dataType, cellStyle));
        if (null == value) {
            cell.setCellValue("");
            return;
        }
        switch (dataType) {
            case "number": {
                int scale = 2;
                if (rule.containsKey("scale") && !StringUtil.isNullOrTrimEmptyString((String)rule.get("scale"))) {
                    try {
                        scale = Integer.valueOf(rule.get("scale"));
                    }
                    catch (NumberFormatException e) {
                        this.errorLog("\u6570\u503c\u6570\u636e\u7cbe\u786e\u5ea6\u83b7\u53d6\u5f02\u5e38", e);
                    }
                }
                BigDecimal numValue = new BigDecimal(value.toString());
                cell.setCellValue(String.valueOf(numValue.setScale(scale, 4)));
                return;
            }
            case "date": {
                String dateFormat = "yyyy-MM-dd";
                if (rule.containsKey("pattern") && !StringUtil.isNullOrTrimEmptyString((String)rule.get("pattern"))) {
                    dateFormat = rule.get("pattern");
                }
                try {
                    SimpleDateFormat format = new SimpleDateFormat(dateFormat);
                    cell.setCellValue(format.format((Date)value));
                }
                catch (Exception e) {
                    this.errorLog("\u65e5\u671f\u6570\u636e\u683c\u5f0f\u5316\u5f02\u5e38\uff0c" + value + "\u8f6c\u6362\u4e3a\uff1a" + dateFormat, e);
                }
                return;
            }
        }
        cell.setCellValue(value.toString());
    }

    private List<Map<String, String>> readColumnRule(String configFilePath) {
        String fileContent = this.readFile(configFilePath);
        List ruleList = null;
        try {
            ruleList = (List)JSONArray.parseObject((String)fileContent, List.class);
        }
        catch (Exception e) {
            String msg = "\u89e3\u6790\u5217\u89c4\u5219\u914d\u7f6e\u6587\u4ef6\u3002";
            this.errorLog("\u89e3\u6790\u5217\u89c4\u5219\u914d\u7f6e\u6587\u4ef6\u3002", e);
            throw new EcpRuntimeException("\u5bfc\u5165\u51fa\u9519", "\u89e3\u6790\u5217\u89c4\u5219\u914d\u7f6e\u6587\u4ef6\u3002");
        }
        if (CollectionUtils.isEmpty((Collection)ruleList)) {
            throw new EcpRuntimeException("\u5bfc\u5165\u51fa\u9519", EcpI18nUtil.localizedString((String)"RedisClientFactory_readColumnRule_223", (String)"\u5217\u89c4\u5219\u914d\u7f6e\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\u3002"));
        }
        this.checkColRule(ruleList);
        return ruleList;
    }

    private String readFile(String filePath) {
        BufferedReader bufReader = null;
        StringBuilder rule = new StringBuilder("");
        try {
            InputStream in = this.getClass().getResourceAsStream(filePath);
            bufReader = new BufferedReader(new InputStreamReader(in));
            String line = null;
            while (StringUtil.isNotEmpty((String)(line = bufReader.readLine()))) {
                rule.append(line);
            }
        }
        catch (Exception e) {
            String msg = EcpI18nUtil.localizedString((String)"RedisClientFactory_readFile_258", (String)("\u8bfb\u53d6\u6587\u4ef6\uff1a" + filePath + "\u5931\u8d25\u3002\u539f\u56e0\uff1a"), (Object[])new Object[]{filePath}) + e.getMessage();
            this.errorLog(msg, e);
            throw new EcpRuntimeException("\u5bfc\u5165\u51fa\u9519", msg);
        }
        finally {
            if (null != bufReader) {
                try {
                    bufReader.close();
                }
                catch (IOException e) {
                    this.errorLog("\u5173\u95ed\u6587\u4ef6\u6d41\u5931\u8d25\uff1a" + e.getMessage(), e);
                    throw new EcpRuntimeException("\u5bfc\u5165\u51fa\u9519", EcpI18nUtil.localizedString((String)"RedisClientFactory_readFile_258", (String)"\u5173\u95ed\u6587\u4ef6\u6d41\u5931\u8d25\u3002"));
                }
            }
        }
        return rule.toString();
    }

    private void checkColRule(List<Map<String, String>> rules) {
        rules.forEach(item -> {
            if (!item.containsKey("columnText")) {
                throw new EcpRuntimeException("\u5bfc\u5165\u51fa\u9519", EcpI18nUtil.localizedString((String)"RedisClientFactory_checkColRule_275", (String)"\u5217\u89c4\u5219\u914d\u7f6e\u6587\u4ef6\u7f3a\u5931columnText\u914d\u7f6e\u9879\u3002"));
            }
            if (!item.containsKey("columnName")) {
                throw new EcpRuntimeException("\u5bfc\u5165\u51fa\u9519", EcpI18nUtil.localizedString((String)"RedisClientFactory_checkColRule_280", (String)"\u5217\u89c4\u5219\u914d\u7f6e\u6587\u4ef6\u7f3a\u5931columnName\u914d\u7f6e\u9879\u3002"));
            }
            if (item.containsKey("columnType")) {
                String dateType = (String)item.get("columnType");
                if (StringUtil.isNullOrTrimEmptyString((String)dateType) || !ExcelConst.DATA_TYPES.containsKey(dateType.toLowerCase())) {
                    throw new EcpRuntimeException("\u5bfc\u5165\u51fa\u9519", EcpI18nUtil.localizedString((String)"RedisClientFactory_checkColRule_288", (String)"\u5217\u89c4\u5219\u914d\u7f6e\u6587\u4ef6\u4e2dcolumnType\u914d\u7f6e\u9879\u914d\u7f6e\u6709\u8bef\u3002"));
                }
            } else {
                item.put("columnType", "string");
            }
        });
    }

    public static CellStyle getTabHeaderCellStyle(Workbook workbook) {
        Font font = workbook.createFont();
        font.setFontHeightInPoints((short)10);
        font.setBold(true);
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setFont(font);
        return cellStyle;
    }

    private CellStyle getCellStyleByDataType(Workbook workbook, String dataType, CellStyle cellStyle) {
        if (dataTypeCellStyleMap.containsKey(dataType)) {
            return dataTypeCellStyleMap.get(dataType);
        }
        Font font = workbook.createFont();
        font.setFontHeightInPoints((short)10);
        cellStyle.setFont(font);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        switch (dataType) {
            case "date": {
                cellStyle.setAlignment(HorizontalAlignment.CENTER);
                break;
            }
            case "number": {
                cellStyle.setAlignment(HorizontalAlignment.RIGHT);
                break;
            }
            case "string": {
                cellStyle.setAlignment(HorizontalAlignment.LEFT);
                break;
            }
            default: {
                cellStyle.setAlignment(HorizontalAlignment.CENTER);
            }
        }
        dataTypeCellStyleMap.put(dataType, cellStyle);
        return cellStyle;
    }

    private void errorLog(String msg, Exception e) {
        if (LOG.isErrorEnabled()) {
            LOG.error((Object)msg, (Throwable)e);
        }
    }
}

