/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.jpa.util;

import com.google.common.collect.Lists;
import com.ygsoft.abc.service.exception.BeyondInSizeException;
import com.ygsoft.abc.service.jpa.util.SpecificationFactory;
import com.ygsoft.abc.service.tool.BlockCollectionUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.Specifications;

public class SpecificationBuilder<T> {
    private static final int MAX_ITEM_SIZE = 1000;
    private Specifications<T> root = null;

    public static <T> SpecificationBuilder<T> newInstance() {
        return new SpecificationBuilder<T>();
    }

    private Specifications<T> composedAnd(Specifications<T> specs) {
        if (this.root == null) {
            return specs;
        }
        return this.root.and(specs);
    }

    private Specifications<T> composedOr(Specifications<T> specs) {
        if (this.root == null) {
            return specs;
        }
        return this.root.or(specs);
    }

    public SpecificationBuilder<T> equal(String attribute, Object value) {
        if (Objects.isNull(value)) {
            return this;
        }
        Specifications specs = Specifications.where(SpecificationFactory.equal(attribute, value));
        this.root = this.composedAnd(specs);
        return this;
    }

    public SpecificationBuilder<T> notEqual(String attribute, Object value) {
        if (Objects.isNull(value)) {
            return this;
        }
        Specifications specs = Specifications.where(SpecificationFactory.notEqual(attribute, value));
        this.root = this.composedAnd(specs);
        return this;
    }

    public SpecificationBuilder<T> like(String attribute, String value) {
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            return this;
        }
        Specifications specs = Specifications.where(SpecificationFactory.like(attribute, value));
        this.root = this.composedAnd(specs);
        return this;
    }

    public SpecificationBuilder<T> in(String attribute, Collection<?> c) {
        if (BlockCollectionUtil.isEmpty(c)) {
            return this;
        }
        if (c.size() > 1000) {
            throw BeyondInSizeException.newInstance("\u8d85\u51fain\u8303\u56f4\u4e0a\u9650\u3002");
        }
        Specifications specs = Specifications.where(SpecificationFactory.in(attribute, c));
        this.root = this.composedAnd(specs);
        return this;
    }

    public SpecificationBuilder<T> between(String attribute, int min, int max) {
        Specifications specs = Specifications.where(SpecificationFactory.between(attribute, min, max));
        this.root = this.composedAnd(specs);
        return this;
    }

    public SpecificationBuilder<T> between(String attribute, long min, long max) {
        Specifications specs = Specifications.where(SpecificationFactory.between(attribute, min, max));
        this.root = this.composedAnd(specs);
        return this;
    }

    public SpecificationBuilder<T> between(String attribute, BigDecimal min, BigDecimal max) {
        if (Objects.isNull(min) && Objects.isNull(max)) {
            return this;
        }
        if (Objects.isNull(min) || Objects.isNull(max)) {
            if (!Objects.isNull(min)) {
                return this.greaterThanOrEqualTo(attribute, min);
            }
            if (!Objects.isNull(max)) {
                return this.lessThanOrEqualTo(attribute, max);
            }
        }
        Specifications specs = Specifications.where(SpecificationFactory.between(attribute, min, max));
        this.root = this.composedAnd(specs);
        return this;
    }

    public SpecificationBuilder<T> between(String attribute, Date min, Date max) {
        if (Objects.isNull(min) && Objects.isNull(max)) {
            return this;
        }
        if (Objects.isNull(min) || Objects.isNull(max)) {
            if (!Objects.isNull(min)) {
                return this.greaterThanOrEqualTo(attribute, min);
            }
            if (!Objects.isNull(max)) {
                return this.lessThanOrEqualTo(attribute, max);
            }
        }
        Specifications specs = Specifications.where(SpecificationFactory.between(attribute, min, max));
        this.root = this.composedAnd(specs);
        return this;
    }

    public SpecificationBuilder<T> greaterThan(String attribute, int value) {
        Specifications specs = Specifications.where(SpecificationFactory.greaterThan(attribute, value));
        this.root = this.composedAnd(specs);
        return this;
    }

    public SpecificationBuilder<T> greaterThan(String attribute, long value) {
        Specifications specs = Specifications.where(SpecificationFactory.greaterThan(attribute, value));
        this.root = this.composedAnd(specs);
        return this;
    }

    public SpecificationBuilder<T> greaterThan(String attribute, BigDecimal value) {
        if (Objects.isNull(value)) {
            return this;
        }
        Specifications specs = Specifications.where(SpecificationFactory.greaterThan(attribute, value));
        this.root = this.composedAnd(specs);
        return this;
    }

    public SpecificationBuilder<T> greaterThan(String attribute, Date value) {
        if (Objects.isNull(value)) {
            return this;
        }
        Specifications specs = Specifications.where(SpecificationFactory.greaterThan(attribute, value));
        this.root = this.composedAnd(specs);
        return this;
    }

    public SpecificationBuilder<T> lessThan(String attribute, int value) {
        Specifications specs = Specifications.where(SpecificationFactory.lessThan(attribute, value));
        this.root = this.composedAnd(specs);
        return this;
    }

    public SpecificationBuilder<T> lessThan(String attribute, long value) {
        Specifications specs = Specifications.where(SpecificationFactory.lessThan(attribute, value));
        this.root = this.composedAnd(specs);
        return this;
    }

    public SpecificationBuilder<T> lessThan(String attribute, BigDecimal value) {
        if (Objects.isNull(value)) {
            return this;
        }
        Specifications specs = Specifications.where(SpecificationFactory.lessThan(attribute, value));
        this.root = this.composedAnd(specs);
        return this;
    }

    public SpecificationBuilder<T> lessThan(String attribute, Date value) {
        if (Objects.isNull(value)) {
            return this;
        }
        Specifications specs = Specifications.where(SpecificationFactory.lessThan(attribute, value));
        this.root = this.composedAnd(specs);
        return this;
    }

    public SpecificationBuilder<T> greaterThanOrEqualTo(String attribute, int value) {
        Specifications specs = Specifications.where(SpecificationFactory.greaterThanOrEqualTo(attribute, value));
        this.root = this.composedAnd(specs);
        return this;
    }

    public SpecificationBuilder<T> greaterThanOrEqualTo(String attribute, long value) {
        Specifications specs = Specifications.where(SpecificationFactory.greaterThanOrEqualTo(attribute, value));
        this.root = this.composedAnd(specs);
        return this;
    }

    public SpecificationBuilder<T> greaterThanOrEqualTo(String attribute, BigDecimal value) {
        if (Objects.isNull(value)) {
            return this;
        }
        Specifications specs = Specifications.where(SpecificationFactory.greaterThanOrEqualTo(attribute, value));
        this.root = this.composedAnd(specs);
        return this;
    }

    public SpecificationBuilder<T> greaterThanOrEqualTo(String attribute, Date value) {
        if (Objects.isNull(value)) {
            return this;
        }
        Specifications specs = Specifications.where(SpecificationFactory.greaterThanOrEqualTo(attribute, value));
        this.root = this.composedAnd(specs);
        return this;
    }

    public SpecificationBuilder<T> lessThanOrEqualTo(String attribute, int value) {
        Specifications specs = Specifications.where(SpecificationFactory.lessThanOrEqualTo(attribute, value));
        this.root = this.composedAnd(specs);
        return this;
    }

    public SpecificationBuilder<T> lessThanOrEqualTo(String attribute, long value) {
        Specifications specs = Specifications.where(SpecificationFactory.lessThanOrEqualTo(attribute, value));
        this.root = this.composedAnd(specs);
        return this;
    }

    public SpecificationBuilder<T> lessThanOrEqualTo(String attribute, BigDecimal value) {
        if (Objects.isNull(value)) {
            return this;
        }
        Specifications specs = Specifications.where(SpecificationFactory.lessThanOrEqualTo(attribute, value));
        this.root = this.composedAnd(specs);
        return this;
    }

    public SpecificationBuilder<T> lessThanOrEqualTo(String attribute, Date value) {
        if (Objects.isNull(value)) {
            return this;
        }
        Specifications specs = Specifications.where(SpecificationFactory.lessThanOrEqualTo(attribute, value));
        this.root = this.composedAnd(specs);
        return this;
    }

    public SpecificationBuilder<T> where(Specification<T> spec) {
        Specifications specs;
        this.root = specs = Specifications.where(spec);
        return this;
    }

    public SpecificationBuilder<T> and(Specification<T> spec) {
        Specifications specs = Specifications.where(spec);
        this.root = this.composedAnd(specs);
        return this;
    }

    public SpecificationBuilder<T> or(Specification<T> spec) {
        Specifications specs = Specifications.where(spec);
        this.root = this.composedOr(specs);
        return this;
    }

    public Specification<T> build() {
        if (this.root == null) {
            return EmptySpecification.getInstance();
        }
        return this.root;
    }

    public static void main(String[] args) {
        SpecificationBuilder specBuilder = SpecificationBuilder.newInstance();
        Specification spec = specBuilder.equal("orgGid", "121sds32324dfg1333").like("displayName", "\u674e").in("interests", Lists.newArrayList((Object[])new String[]{"basketball", "football", "skiing"})).build();
    }

    static class EmptySpecification<T>
    implements Specification<T> {
        private static EmptySpecification instance = new EmptySpecification();

        private EmptySpecification() {
        }

        public static <T> EmptySpecification<T> getInstance() {
            return instance;
        }

        public Predicate toPredicate(Root<T> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder) {
            ArrayList restrictions = new ArrayList();
            criteriaQuery.where(restrictions.toArray(new Predicate[restrictions.size()]));
            return criteriaQuery.getRestriction();
        }
    }
}

