/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.jpa.util;

import com.ygsoft.abc.service.tool.BlockSqlUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import javax.persistence.criteria.Expression;
import org.springframework.data.jpa.domain.Specification;

public final class SpecificationFactory {
    public static <T> Specification<T> like(String attribute, String value) {
        String likeValue = BlockSqlUtil.buildLikeValue(value);
        return (root, query, cb) -> cb.like((Expression)root.get(attribute), likeValue, '\\');
    }

    public static <T> Specification<T> equal(String attribute, Object value) {
        return (root, query, cb) -> cb.equal((Expression)root.get(attribute), value);
    }

    public static <T> Specification<T> notEqual(String attribute, Object value) {
        return (root, query, cb) -> cb.notEqual((Expression)root.get(attribute), value);
    }

    public static <T> Specification<T> between(String attribute, int min, int max) {
        return (root, query, cb) -> cb.between((Expression)root.get(attribute), (Comparable)Integer.valueOf(min), (Comparable)Integer.valueOf(max));
    }

    public static <T> Specification<T> between(String attribute, long min, long max) {
        return (root, query, cb) -> cb.between((Expression)root.get(attribute), (Comparable)Long.valueOf(min), (Comparable)Long.valueOf(max));
    }

    public static <T> Specification<T> between(String attribute, BigDecimal min, BigDecimal max) {
        return (root, query, cb) -> cb.between((Expression)root.get(attribute), (Comparable)min, (Comparable)max);
    }

    public static <T> Specification<T> between(String attribute, Date min, Date max) {
        return (root, query, cb) -> cb.between((Expression)root.get(attribute), (Comparable)min, (Comparable)max);
    }

    public static <T> Specification<T> in(String attribute, Collection<?> c) {
        return (root, query, cb) -> root.get(attribute).in(c);
    }

    public static <T> Specification<T> greaterThan(String attribute, BigDecimal value) {
        return (root, query, cb) -> cb.greaterThan((Expression)root.get(attribute), (Comparable)value);
    }

    public static <T> Specification<T> greaterThan(String attribute, int value) {
        return (root, query, cb) -> cb.greaterThan((Expression)root.get(attribute), (Comparable)Integer.valueOf(value));
    }

    public static <T> Specification<T> greaterThan(String attribute, long value) {
        return (root, query, cb) -> cb.greaterThan((Expression)root.get(attribute), (Comparable)Long.valueOf(value));
    }

    public static <T> Specification<T> greaterThan(String attribute, Date value) {
        return (root, query, cb) -> cb.greaterThan((Expression)root.get(attribute), (Comparable)value);
    }

    public static <T> Specification<T> lessThan(String attribute, BigDecimal value) {
        return (root, query, cb) -> cb.lessThan((Expression)root.get(attribute), (Comparable)value);
    }

    public static <T> Specification<T> lessThan(String attribute, int value) {
        return (root, query, cb) -> cb.lessThan((Expression)root.get(attribute), (Comparable)Integer.valueOf(value));
    }

    public static <T> Specification<T> lessThan(String attribute, long value) {
        return (root, query, cb) -> cb.lessThan((Expression)root.get(attribute), (Comparable)Long.valueOf(value));
    }

    public static <T> Specification<T> lessThan(String attribute, Date value) {
        return (root, query, cb) -> cb.lessThan((Expression)root.get(attribute), (Comparable)value);
    }

    public static <T> Specification<T> greaterThanOrEqualTo(String attribute, BigDecimal value) {
        return (root, query, cb) -> cb.greaterThanOrEqualTo((Expression)root.get(attribute), (Comparable)value);
    }

    public static <T> Specification<T> greaterThanOrEqualTo(String attribute, int value) {
        return (root, query, cb) -> cb.greaterThanOrEqualTo((Expression)root.get(attribute), (Comparable)Integer.valueOf(value));
    }

    public static <T> Specification<T> greaterThanOrEqualTo(String attribute, long value) {
        return (root, query, cb) -> cb.greaterThanOrEqualTo((Expression)root.get(attribute), (Comparable)Long.valueOf(value));
    }

    public static <T> Specification<T> greaterThanOrEqualTo(String attribute, Date value) {
        return (root, query, cb) -> cb.greaterThanOrEqualTo((Expression)root.get(attribute), (Comparable)value);
    }

    public static <T> Specification<T> lessThanOrEqualTo(String attribute, BigDecimal value) {
        return (root, query, cb) -> cb.lessThanOrEqualTo((Expression)root.get(attribute), (Comparable)value);
    }

    public static <T> Specification<T> lessThanOrEqualTo(String attribute, int value) {
        return (root, query, cb) -> cb.lessThanOrEqualTo((Expression)root.get(attribute), (Comparable)Integer.valueOf(value));
    }

    public static <T> Specification<T> lessThanOrEqualTo(String attribute, long value) {
        return (root, query, cb) -> cb.lessThanOrEqualTo((Expression)root.get(attribute), (Comparable)Long.valueOf(value));
    }

    public static <T> Specification<T> lessThanOrEqualTo(String attribute, Date value) {
        return (root, query, cb) -> cb.lessThanOrEqualTo((Expression)root.get(attribute), (Comparable)value);
    }
}

