/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.jpautils;

import com.ygsoft.abc.service.jpautils.IPredicateService;
import com.ygsoft.abc.service.tool.BlockDateUtil;
import com.ygsoft.abc.service.tool.BlockSqlUtil;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.Attribute;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.util.CollectionUtils;

public final class PredicateUtil {
    private static final IEcpLog LOG = EcpLogFactory.getLog(PredicateUtil.class);
    public static final String ID = "id";
    public static final String START = "start";
    public static final String END = "end";
    public static final String LIST = "List";
    public static final String EQUAL = "Equal";
    private static HashSet<Class> CLASS_SET;
    private static HashSet<Class> UN_SUPPORT_CLASS_SET;
    private static Map<Class, IPredicateService> CLASS_IPREDICATESERVICE_MAP;

    private static void buildIPredicateServicesMap() {
        CLASS_IPREDICATESERVICE_MAP.put(List.class, (cb, root, predicates, displayName, getValue, propertiesSet) -> {
            String fieldName = displayName.replace(LIST, "");
            if (!propertiesSet.contains(fieldName)) {
                return;
            }
            predicates.add(cb.in((Expression)root.get(fieldName)).value(getValue));
        });
        CLASS_IPREDICATESERVICE_MAP.put(Date.class, (cb, root, predicates, displayName, getValue, propertiesSet) -> {
            Date dateValue = (Date)getValue;
            if (displayName.toLowerCase().startsWith(START)) {
                String fieldName = PredicateUtil.buildStartEnd(displayName);
                if (!propertiesSet.contains(fieldName)) {
                    return;
                }
                predicates.add(cb.greaterThanOrEqualTo((Expression)root.get(fieldName), (Comparable)(PredicateUtil.timeZero(dateValue) ? BlockDateUtil.setZeroTime(dateValue) : dateValue)));
            } else if (displayName.toLowerCase().startsWith(END)) {
                String fieldName = PredicateUtil.buildStartEnd(displayName);
                if (!propertiesSet.contains(fieldName)) {
                    return;
                }
                predicates.add(cb.lessThanOrEqualTo((Expression)root.get(fieldName), (Comparable)(PredicateUtil.timeZero(dateValue) ? BlockDateUtil.setLastTime(dateValue) : dateValue)));
            }
        });
        CLASS_IPREDICATESERVICE_MAP.put(Integer.class, (cb, root, predicates, displayName, getValue, propertiesSet) -> {
            if (displayName.toLowerCase().startsWith(START)) {
                String fieldName = PredicateUtil.buildStartEnd(displayName);
                if (!propertiesSet.contains(fieldName)) {
                    return;
                }
                predicates.add(cb.greaterThanOrEqualTo((Expression)root.get(fieldName), (Comparable)((Integer)getValue)));
            } else if (displayName.toLowerCase().startsWith(END)) {
                String fieldName = PredicateUtil.buildStartEnd(displayName);
                if (!propertiesSet.contains(fieldName)) {
                    return;
                }
                predicates.add(cb.lessThanOrEqualTo((Expression)root.get(fieldName), (Comparable)((Integer)getValue)));
            } else {
                String fieldName = displayName;
                if (!propertiesSet.contains(fieldName)) {
                    return;
                }
                predicates.add(cb.equal((Expression)root.get(fieldName), getValue));
            }
        });
        CLASS_IPREDICATESERVICE_MAP.put(Integer.TYPE, CLASS_IPREDICATESERVICE_MAP.get(Integer.class));
        CLASS_IPREDICATESERVICE_MAP.put(BigDecimal.class, (cb, root, predicates, displayName, getValue, propertiesSet) -> {
            if (displayName.toLowerCase().startsWith(START)) {
                String fieldName = PredicateUtil.buildStartEnd(displayName);
                if (!propertiesSet.contains(fieldName)) {
                    return;
                }
                predicates.add(cb.greaterThanOrEqualTo((Expression)root.get(fieldName), (Comparable)((BigDecimal)getValue)));
            } else if (displayName.toLowerCase().startsWith(END)) {
                String fieldName = PredicateUtil.buildStartEnd(displayName);
                if (!propertiesSet.contains(fieldName)) {
                    return;
                }
                predicates.add(cb.lessThanOrEqualTo((Expression)root.get(fieldName), (Comparable)((BigDecimal)getValue)));
            }
        });
        CLASS_IPREDICATESERVICE_MAP.put(String.class, (cb, root, predicates, displayName, getValue, propertiesSet) -> {
            String fieldName = displayName;
            if (displayName.endsWith(EQUAL)) {
                fieldName = displayName.replace(EQUAL, "");
                if (!propertiesSet.contains(fieldName)) {
                    return;
                }
                predicates.add(cb.equal((Expression)root.get(fieldName), getValue));
            } else {
                if (!propertiesSet.contains(fieldName)) {
                    return;
                }
                if (displayName.toLowerCase().endsWith(ID)) {
                    predicates.add(cb.equal((Expression)root.get(fieldName), getValue));
                } else {
                    predicates.add(cb.like((Expression)root.get(fieldName), "%" + BlockSqlUtil.escapeLikeValue((String)getValue) + "%", '\\'));
                }
            }
        });
    }

    private static void buildClassSet() {
        CLASS_SET = new HashSet();
        CLASS_SET.add(Integer.class);
        CLASS_SET.add(Double.class);
        CLASS_SET.add(Long.class);
        CLASS_SET.add(Float.class);
        CLASS_SET.add(String.class);
        CLASS_SET.add(Date.class);
        CLASS_SET.add(List.class);
        CLASS_SET.add(ArrayList.class);
        CLASS_SET.add(BigDecimal.class);
        CLASS_SET.add(Enum.class);
        CLASS_IPREDICATESERVICE_MAP = new HashMap<Class, IPredicateService>();
    }

    private static void buildUnClassSet() {
        UN_SUPPORT_CLASS_SET = new HashSet();
        UN_SUPPORT_CLASS_SET.add(Byte.TYPE);
        UN_SUPPORT_CLASS_SET.add(Short.TYPE);
        UN_SUPPORT_CLASS_SET.add(Integer.TYPE);
        UN_SUPPORT_CLASS_SET.add(Long.TYPE);
        UN_SUPPORT_CLASS_SET.add(Double.TYPE);
        UN_SUPPORT_CLASS_SET.add(Float.TYPE);
        UN_SUPPORT_CLASS_SET.add(Boolean.TYPE);
        UN_SUPPORT_CLASS_SET.add(Character.TYPE);
    }

    private PredicateUtil() {
    }

    public static List<Predicate> buildPredicateList(Object paramsVO, CriteriaBuilder cb, Root root) {
        if (paramsVO == null) {
            return new ArrayList<Predicate>();
        }
        Class<?> cls = paramsVO.getClass();
        Field[] fields = cls.getDeclaredFields();
        HashSet<String> propertiesSet = new HashSet<String>();
        for (Object o : root.getModel().getAttributes()) {
            Attribute el = (Attribute)o;
            propertiesSet.add(el.getName());
        }
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        for (Field field : fields) {
            Object getValue;
            PropertyDescriptor pd;
            if (PredicateUtil.filterField(field)) continue;
            try {
                pd = new PropertyDescriptor(field.getName(), cls);
            }
            catch (IntrospectionException e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)e.getMessage(), (Throwable)e);
                continue;
            }
            Method getMethod = pd.getReadMethod();
            String displayName = pd.getDisplayName();
            try {
                getValue = getMethod.invoke(paramsVO, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            if (PredicateUtil.isEmpty(getValue)) continue;
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("getValueType " + pd.getPropertyType()));
            }
            if (pd.getPropertyType().isEnum()) {
                predicates.add(cb.equal((Expression)root.get(displayName), getValue));
                continue;
            }
            IPredicateService predicateService = CLASS_IPREDICATESERVICE_MAP.get(pd.getPropertyType());
            predicateService.buildPredicateListByCond(cb, root, predicates, displayName, getValue, propertiesSet);
        }
        return predicates;
    }

    public static <T> Specification<T> buildSpecification(Object paramsVO) {
        Specification spec = (root, query, cb) -> {
            List<Predicate> predicates = PredicateUtil.buildPredicateList(paramsVO, cb, root);
            return query.where((Expression)cb.and(predicates.toArray(new Predicate[predicates.size()]))).getRestriction();
        };
        return spec;
    }

    private static boolean filterField(Field field) {
        return Modifier.isStatic(field.getModifiers()) || UN_SUPPORT_CLASS_SET.contains(field.getType());
    }

    private static String buildStartEnd(String s) {
        String res = s;
        if (s.startsWith(START)) {
            res = PredicateUtil.toLowerCamel(s.substring(START.length()));
        } else if (s.startsWith(END)) {
            res = PredicateUtil.toLowerCamel(s.substring(END.length()));
        }
        return res;
    }

    private static boolean timeZero(Date date) {
        return date.getHours() == 0 && date.getMinutes() == 0 && date.getSeconds() == 0;
    }

    private static String toLowerCamel(String s) {
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    public static boolean isEmpty(Object o) {
        boolean containType = false;
        if (o == null) {
            return true;
        }
        for (Class cls : CLASS_SET) {
            if (!cls.isAssignableFrom(o.getClass())) continue;
            containType = true;
        }
        if (!containType) {
            throw new RuntimeException(EcpI18nUtil.localizedString((String)"PredicateUtil_isEmpty_350", (String)"\u6682\u65f6\u4e0d\u652f\u6301\u7684\u7c7b\u578b\u3002") + o.getClass());
        }
        if (o instanceof String) {
            return StringUtil.isNullOrTrimEmptyString((String)((String)o));
        }
        if (o instanceof List) {
            return CollectionUtils.isEmpty((Collection)((List)o));
        }
        return false;
    }

    static {
        PredicateUtil.buildClassSet();
        PredicateUtil.buildIPredicateServicesMap();
        PredicateUtil.buildUnClassSet();
    }
}

