/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.login;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ygsoft.abc.service.annotation.TLog;
import com.ygsoft.abc.service.cache.ContextContainerRedisClient;
import com.ygsoft.abc.service.cache.LoginContextRedisClient;
import com.ygsoft.abc.service.cache.RedisClientFactory;
import com.ygsoft.abc.service.exception.AbcServiceException;
import com.ygsoft.abc.service.exception.RestRuntimeException;
import com.ygsoft.abc.service.login.domain.vo.LoginContextVO;
import com.ygsoft.abc.service.tool.MappServiceUtil;
import com.ygsoft.ecp.framework.token.TokenHolder;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.RedisUtil;
import com.ygsoft.necp.core.service.mapp.MappService;

public final class ContextKit {
    private static final IEcpLog LOG = EcpLogFactory.getLog(ContextKit.class);
    private static final int TOKEN_EXPIRE_SECONDS = 43200;
    public static final ContextKit INSTANCE = new ContextKit();
    private static final String URL_ABC_LOGIN_CONTEXT_QUERY = "/abc/mapp/basic4a/query/user/relation/{v1}?tenantid={v2}";
    private static final String URL_ECP_4A_TENANT_QUERY = "/necp/mapp/4a/query/systemtenant/findListPageData?page=0&pageSize=1&sort=createtime&dsc=0";
    private static final String DEFAULT_TENANT_KEY = "abc:global:tenantId";
    private static final String F_TENANTID = "tenantid";

    private ContextKit() {
    }

    @TLog(checkArguments=true)
    public LoginContextVO afterLoginSuccessfully(String userName, String tenantId) {
        String token = TokenHolder.INSTANCE.getToken();
        this.checkToken(token);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"\u5f00\u59cb\u4ece4a\u5fae\u670d\u52a1\u83b7\u53d6\u7528\u6237\u767b\u5f55\u4e0a\u4e0b\u6587\u3002");
        }
        LoginContextVO loginContext = MappServiceUtil.doGet(URL_ABC_LOGIN_CONTEXT_QUERY, LoginContextVO.class, userName, tenantId);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("\u7ed3\u675f\u4ece\u5fae\u670d\u52a1\u83b7\u53d6\u7528\u6237\u767b\u5f55\u4e0a\u4e0b\u6587\uff0c\u503c\u4e3a\uff1a" + JSON.toJSONString((Object)loginContext)));
        }
        ContextContainerRedisClient.INSTANCE.setToken(token, loginContext.getUserId());
        LoginContextRedisClient.setCache(loginContext);
        return loginContext;
    }

    @TLog(checkArguments=true)
    public LoginContextVO afterLoginSuccessfully(String userName) {
        return this.afterLoginSuccessfully(userName, this.getDefaultBizTenantId());
    }

    private void checkToken(String token) {
        if (token == null || "".equals(token.trim())) {
            String err = EcpI18nUtil.localizedString((String)"ContextKit_checkToken_129", (String)"\u672a\u83b7\u53d6\u5230\u7528\u6237\u7684token");
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)err);
            }
            throw new AbcServiceException("ABC.0015", err);
        }
    }

    public String getUserGid() {
        String token = TokenHolder.INSTANCE.getToken();
        this.checkToken(token);
        return ContextContainerRedisClient.INSTANCE.getToken(token);
    }

    public LoginContextVO getLoginContextVO() {
        String userGid = this.getUserGid();
        return LoginContextRedisClient.getObject(userGid, true);
    }

    public String getDefaultBizTenantId() {
        String tenantId = RedisUtil.getRedisService().get("abc", DEFAULT_TENANT_KEY);
        if (null == tenantId || "".equals(tenantId.trim())) {
            tenantId = this.getDefaultBizTenantIdInRest();
            RedisClientFactory.set(DEFAULT_TENANT_KEY, tenantId);
        }
        return tenantId;
    }

    private String getDefaultBizTenantIdInRest() {
        JSONArray jsonArray;
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"\u5f00\u59cb\u4eceecp-4a\u5fae\u670d\u52a1\u83b7\u53d6\u9ed8\u8ba4\u79df\u6237\u3002");
        }
        String jsonStr = (String)MappService.INSTANCE.doPost(URL_ECP_4A_TENANT_QUERY, null, String.class, new Object[0]);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("\u7ed3\u675f\u4eceecp-4a\u5fae\u670d\u52a1\u83b7\u53d6\u9ed8\u8ba4\u79df\u6237\uff0c\u503c\u4e3a\uff1a" + jsonStr));
        }
        if ((jsonArray = JSONObject.parseArray((String)jsonStr)).isEmpty() || !jsonArray.getJSONObject(0).containsKey((Object)F_TENANTID)) {
            String err = EcpI18nUtil.localizedString((String)"ContextKit_getDefaultBizTenantIdInRest_184", (String)"\u672a\u83b7\u53d6\u5230\u9ed8\u8ba4\u7684\u79df\u6237\u3002");
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)err);
            }
            throw new RestRuntimeException("E0200.0002", err);
        }
        return jsonArray.getJSONObject(0).getString(F_TENANTID);
    }
}

