/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.login;

import com.alibaba.fastjson.JSON;
import com.ygsoft.abc.service.cache.ContextContainerRedisClient;
import com.ygsoft.abc.service.cache.LoginContextRedisClient;
import com.ygsoft.abc.service.exception.CheckFailedException;
import com.ygsoft.abc.service.login.domain.vo.ExtendLoginContext;
import com.ygsoft.abc.service.tool.PreconditionUtil;
import com.ygsoft.abc.service.tool.PropertyConfigUtil;
import com.ygsoft.ecp.core.framework.context.ILoginContext;
import com.ygsoft.ecp.core.framework.internal.context.LoginContext;
import com.ygsoft.ecp.framework.token.TokenHolder;
import com.ygsoft.ecp.mapp.common.service.util.LoginContextUtil;
import com.ygsoft.ecp.service.date.EcpDate;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.time.ZoneId;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;

public class ExtendContextContainer {
    private static final IEcpLog LOG = EcpLogFactory.getLog(ExtendContextContainer.class);
    public static final ExtendContextContainer INSTANCE = new ExtendContextContainer();

    private ExtendContextContainer() {
    }

    public static ExtendLoginContext getLoginContextWithoutProto() {
        String tokenId = TokenHolder.INSTANCE.getToken();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)String.format("\u4ecetoken(%s)\u4e0b\u83b7\u53d6\u6269\u5c55\u4e0a\u4e0b\u6587\u3002", tokenId));
        }
        String userId = ContextContainerRedisClient.INSTANCE.getToken(tokenId);
        ExtendLoginContext newLoginContext = LoginContextRedisClient.getLoginContext(userId, true);
        return newLoginContext;
    }

    public static ExtendLoginContext getLoginContext(boolean checkNull) {
        ExtendLoginContext context = ExtendContextContainer.getLoginContext();
        if (checkNull && Objects.isNull((Object)context)) {
            throw CheckFailedException.newInstance("\u4e1a\u52a1\u4e0a\u4e0b\u6587\u4e3a\u7a7a\u3002");
        }
        return context;
    }

    private static ExtendLoginContext buildMockLoginContext() {
        ExtendLoginContext loginContext = new ExtendLoginContext();
        loginContext.setUserId("1");
        loginContext.setUserGid("UserGid:001");
        loginContext.setUserName("UserName:001");
        loginContext.setUserDisplayName("UserDisplayName:001");
        loginContext.setUserCode("UserCode:001");
        loginContext.setUserType(1);
        loginContext.setLoginOrgId("110");
        loginContext.setLoginOrgGid("OrgGid:001");
        loginContext.setLoginOrgName("OrgName:001");
        return loginContext;
    }

    public static ExtendLoginContext getLoginContext() {
        LoginContext loginContext;
        if (PropertyConfigUtil.isUnitTest()) {
            return ExtendContextContainer.buildMockLoginContext();
        }
        String tokenId = TokenHolder.INSTANCE.getToken();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)String.format("\u4ecetoken(%s)\u4e0b\u83b7\u53d6\u6269\u5c55\u4e0a\u4e0b\u6587\u3002", tokenId));
        }
        if (Objects.isNull(loginContext = (LoginContext)LoginContextUtil.getLoginContext())) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"###>LoginContext\u4e3a\u7a7a\u3002");
            }
            return null;
        }
        ExtendLoginContext extendLoginContext = LoginContextRedisClient.getLoginContext(loginContext.getUserId(), true);
        if (Objects.isNull((Object)extendLoginContext) && LOG.isWarnEnabled()) {
            LOG.warn((Object)"###>ExtendLoginContext\u4e3a\u7a7a\u3002");
        }
        return extendLoginContext;
    }

    public static boolean checkToken() {
        String tokenId = TokenHolder.INSTANCE.getToken();
        if (StringUtil.isNullOrTrimEmptyString((String)tokenId)) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"token\u5931\u6548\u3002");
            }
            return false;
        }
        LoginContext loginContext = (LoginContext)LoginContextUtil.getLoginContext();
        if (Objects.isNull(loginContext)) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"loginContext\u5931\u6548\u3002");
            }
            return false;
        }
        ExtendLoginContext extendContext = LoginContextRedisClient.getLoginContext(loginContext.getUserId(), false);
        if (Objects.isNull((Object)extendContext)) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"extendLoginContext\u5931\u6548\u3002");
            }
            return false;
        }
        return true;
    }

    public static String getUserGid() {
        ExtendLoginContext context = ExtendContextContainer.getLoginContext();
        return context.getUserGid();
    }

    public static String getUserGid(boolean checkNull) {
        ExtendLoginContext context = ExtendContextContainer.getLoginContext();
        if (checkNull && Objects.isNull((Object)context)) {
            throw CheckFailedException.newInstance("\u4e1a\u52a1\u4e0a\u4e0b\u6587\u4e3a\u7a7a\u3002");
        }
        if (Objects.isNull((Object)context)) {
            return "robot";
        }
        return context.getUserGid();
    }

    public static String getToken() {
        String tokenId = TokenHolder.INSTANCE.getToken();
        return tokenId;
    }

    public static String getTenantGid() {
        ExtendLoginContext context = ExtendContextContainer.getLoginContext();
        PreconditionUtil.checkNotNull(context, "\u4e1a\u52a1\u4e0a\u4e0b\u6587\u4e3a\u7a7a\u3002");
        return context.getTenantId();
    }

    public static boolean isTimeOut(ILoginContext loginContext) {
        boolean isTimeOut;
        if (loginContext == null) {
            return true;
        }
        long mNow = System.currentTimeMillis();
        EcpDate logDate = loginContext.getLoginDate();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(logDate.getYear(), logDate.getMonth() - 1, logDate.getDay(), logDate.getHour(), logDate.getMinute(), logDate.getSecond());
        long mlog = calendar.getTimeInMillis();
        long seconds = (mNow - mlog) / 1000L;
        long outTime = ExtendContextContainer.getTimeout();
        boolean bl = isTimeOut = seconds >= outTime;
        if (isTimeOut && LOG.isInfoEnabled()) {
            LOG.info((Object)("isTimeOut\u4f1a\u8bdd\u8d85\u65f6\u6821\u9a8c\uff0c\u6700\u8fd1\u8bbf\u95ee\u65f6\u95f4 \uff1a" + seconds + " \u5927\u4e8e\u9650\u5236\u65f6\u95f4\uff08\u79d2\uff09 " + outTime + ", \u4e0a\u4e0b\u6587\uff1a" + JSON.toJSONString((Object)loginContext)));
        }
        return isTimeOut;
    }

    private static int getTimeout() {
        String propTimeout = System.getProperty("umc.session.timeout");
        if (null != propTimeout) {
            return Integer.parseInt(propTimeout) * 60;
        }
        return 1800;
    }

    public static void main(String[] args) {
        Date now = new Date();
        com.ygsoft.ecp.framework.date.EcpDate ecpDate = new com.ygsoft.ecp.framework.date.EcpDate(now);
        System.out.println("now=" + now.getTime());
        System.out.println("ecpDate=" + ecpDate.getMillisecond());
        System.out.println("ecpDate=" + ecpDate.getSecond());
        System.out.println("ecpDate=" + ecpDate.toDateString());
        System.out.println("ecpDate=" + ecpDate.toCalendar().getTimeInMillis());
        Locale local = Locale.CHINA;
        System.out.println("local=" + local);
        Locale local2 = new Locale(local.getLanguage());
        System.out.println("local2=" + local2);
        TimeZone timeZone = TimeZone.getDefault();
        System.out.println("timeZone=" + timeZone);
        System.out.println("timeZone=" + timeZone.getID());
        System.out.println("zoneId=" + timeZone.toZoneId().getId());
        TimeZone timeZone2 = TimeZone.getTimeZone(ZoneId.of("Asia/Shanghai"));
        System.out.println("timeZone2=" + timeZone2);
    }
}

