/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.rest.util;

import com.alibaba.fastjson.JSONObject;
import com.ygsoft.abc.service.exception.EmptyValueException;
import com.ygsoft.abc.service.exception.InvalidJsonTypeException;
import com.ygsoft.abc.service.exception.MappServiceCallException;
import com.ygsoft.abc.service.rest.domain.vo.GwReceiveListVO;
import com.ygsoft.abc.service.rest.domain.vo.GwRespResultVO;
import com.ygsoft.abc.service.rest.domain.vo.GwStdReceiveVO;
import com.ygsoft.abc.service.rest.domain.vo.StdPageContentVO;
import com.ygsoft.abc.service.rest.domain.vo.StdReceiveEntityVO;
import com.ygsoft.abc.service.rest.domain.vo.StdReceiveListVO;
import com.ygsoft.abc.service.rest.domain.vo.StdReceivePageVO;
import com.ygsoft.abc.service.rest.domain.vo.StdReceiveVO;
import com.ygsoft.abc.service.tool.BlockJSONUtil;
import com.ygsoft.alibaba.fastjson.JSONArray;
import com.ygsoft.alibaba.fastjson.util.TypeUtils;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.JSONUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import com.ygsoft.necp.core.service.dcispec.PageModel;
import com.ygsoft.necp.core.service.mapp.MappService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class StdMappServiceUtil {
    private static final IEcpLog LOG = EcpLogFactory.getLog(StdMappServiceUtil.class);
    private static final String EMPTY_STRING = "";
    private static final String PREFIX_URI_VALUE = "{";
    private static final String POSTFIX_URI_VALUE = "}";
    private static final String JSON_OBJECT_PATTERN = "^\\{.*\\}$";
    private static final String JSON_ARRAY_PATTERN = "^\\[.*\\]$";

    public static <T> PageModel<T> toPageModel(StdPageContentVO<T> pageContent) {
        PageModel pageModel = new PageModel();
        pageModel.setContent(pageContent.getContent());
        pageModel.setPage(pageContent.getNumber().intValue());
        pageModel.setPageSize(pageContent.getSize().intValue());
        pageModel.setSize(pageContent.getNumberOfElements().intValue());
        pageModel.setTotalCounts((long)pageContent.getTotalElements().intValue());
        pageModel.setTotalPages(pageContent.getTotalPages().intValue());
        pageModel.setFirst(pageContent.isFirst());
        pageModel.setLast(pageContent.isLast());
        return pageModel;
    }

    public static <T> StdReceiveEntityVO<T> doGetEntity(String url, Class<T> responseType, Object ... uriVariables) {
        StdMappServiceUtil.checkArgs(url, StdReceiveEntityVO.class);
        if (LOG.isInfoEnabled()) {
            String tipMsg = String.format("doGet---url:%s\uff0curiVariables:%s", url, StdMappServiceUtil.buildUriVariables(uriVariables));
            LOG.info((Object)tipMsg);
        }
        String body = (String)MappService.INSTANCE.doGet(url, String.class, uriVariables);
        StdMappServiceUtil.checkRespResult(body);
        StdReceiveEntityVO respEntity = (StdReceiveEntityVO)com.ygsoft.alibaba.fastjson.JSONObject.parseObject((String)body, StdReceiveEntityVO.class);
        if (respEntity.getData() != null) {
            respEntity.setData(StdMappServiceUtil.castToObject(respEntity.getData().toString(), responseType));
        }
        return respEntity;
    }

    public static <T> StdReceiveEntityVO<T> doPostReturnEntity(String url, Object request, Class<T> responseType, Object ... uriVariables) {
        StdMappServiceUtil.checkArgs(url, StdReceiveEntityVO.class);
        if (LOG.isInfoEnabled()) {
            String tipMsg = String.format("doPost---url:%s\uff0curiVariables:%s\uff0crequest:%s", url, StdMappServiceUtil.buildUriVariables(uriVariables), JSONUtil.toJsonWithoutJcls((Object)request));
            LOG.info((Object)tipMsg);
        }
        String body = null;
        body = uriVariables == null || uriVariables.length == 0 ? (String)MappService.INSTANCE.doPost(url, request, String.class, new Object[0]) : (String)MappService.INSTANCE.doPost(url, request, String.class, uriVariables);
        if (Objects.isNull(body)) {
            return null;
        }
        StdMappServiceUtil.checkRespResult(body);
        StdReceiveEntityVO respEntity = StdMappServiceUtil.castToObject(body, StdReceiveEntityVO.class);
        if (respEntity.getData() != null) {
            respEntity.setData(StdMappServiceUtil.castToObject(respEntity.getData().toString(), responseType));
        }
        return respEntity;
    }

    public static <T> GwRespResultVO<T> doGWPostReturnEntity(String url, Object request, Class<T> responseType, Object ... uriVariables) {
        StdMappServiceUtil.checkArgs(url, GwRespResultVO.class);
        if (LOG.isInfoEnabled()) {
            String tipMsg = String.format("doPost---url:%s\uff0curiVariables:%s\uff0crequest:%s", url, StdMappServiceUtil.buildUriVariables(uriVariables), JSONUtil.toJsonWithoutJcls((Object)request));
            LOG.info((Object)tipMsg);
        }
        String body = null;
        body = uriVariables == null || uriVariables.length == 0 ? (String)MappService.INSTANCE.doPost(url, request, String.class, new Object[0]) : (String)MappService.INSTANCE.doPost(url, request, String.class, uriVariables);
        if (Objects.isNull(body)) {
            return null;
        }
        GwRespResultVO respEntity = StdMappServiceUtil.castToObject(body, GwRespResultVO.class);
        if (respEntity.getData() != null) {
            respEntity.setData(StdMappServiceUtil.castToObject(respEntity.getData().toString(), responseType));
        }
        return respEntity;
    }

    public static <T> StdReceiveListVO<T> doPostReturnList(String url, Object request, Class<T> responseType, Object ... uriVariables) {
        String body;
        StdMappServiceUtil.checkArgs(url, responseType);
        if (LOG.isInfoEnabled()) {
            String tipMsg = String.format("doPost---url:%s\uff0curiVariables:%s\uff0crequest:%s", url, StdMappServiceUtil.buildUriVariables(uriVariables), JSONUtil.toJsonWithoutJcls((Object)request));
            LOG.info((Object)tipMsg);
        }
        if (Objects.isNull(body = (String)MappService.INSTANCE.doPost(url, request, String.class, uriVariables))) {
            return null;
        }
        StdMappServiceUtil.checkRespResult(body);
        StdReceiveListVO respEntity = StdMappServiceUtil.castToObject(body, StdReceiveListVO.class);
        if (respEntity.getData() != null) {
            List<T> data = StdMappServiceUtil.castToList(respEntity.getData().toString(), responseType);
            respEntity.setData(data);
        }
        return respEntity;
    }

    public static <T> GwReceiveListVO<T> doGwPostReturnList(String url, Object request, Class<T> responseType, Object ... uriVariables) {
        String body;
        StdMappServiceUtil.checkArgs(url, responseType);
        if (LOG.isInfoEnabled()) {
            String tipMsg = String.format("doPost---url:%s\uff0curiVariables:%s\uff0crequest:%s", url, StdMappServiceUtil.buildUriVariables(uriVariables), JSONUtil.toJsonWithoutJcls((Object)request));
            LOG.info((Object)tipMsg);
        }
        if (Objects.isNull(body = (String)MappService.INSTANCE.doPost(url, request, String.class, uriVariables))) {
            return null;
        }
        StdMappServiceUtil.GwCheckRespResult(body);
        GwReceiveListVO respEntity = StdMappServiceUtil.castToObject(body, GwReceiveListVO.class);
        if (respEntity.getData() != null) {
            List<T> data = StdMappServiceUtil.castToList(respEntity.getData().toString(), responseType);
            respEntity.setData(data);
        }
        return respEntity;
    }

    public static <T> StdReceiveListVO<T> doGetList(String url, Class<T> responseType, Object ... uriVariables) {
        StdMappServiceUtil.checkArgs(url, responseType);
        if (LOG.isInfoEnabled()) {
            String tipMsg = String.format("doGet---url:%s\uff0curiVariables:%s", url, StdMappServiceUtil.buildUriVariables(uriVariables));
            LOG.info((Object)tipMsg);
        }
        String body = (String)MappService.INSTANCE.doGet(url, String.class, uriVariables);
        StdMappServiceUtil.checkRespResult(body);
        return StdMappServiceUtil.castToRespResultList(body, responseType);
    }

    public static <T> GwReceiveListVO<T> doGwGetList(String url, Class<T> responseType, Object ... uriVariables) {
        StdMappServiceUtil.checkArgs(url, responseType);
        if (LOG.isInfoEnabled()) {
            String tipMsg = String.format("doGet---url:%s\uff0curiVariables:%s", url, StdMappServiceUtil.buildUriVariables(uriVariables));
            LOG.info((Object)tipMsg);
        }
        String body = (String)MappService.INSTANCE.doGet(url, String.class, uriVariables);
        StdMappServiceUtil.GwCheckRespResult(body);
        return StdMappServiceUtil.gwCastToRespResultList(body, responseType);
    }

    private static <T> StdReceiveListVO<T> castToRespResultList(String body, Class<T> responseType) {
        StdReceiveListVO respList = (StdReceiveListVO)com.ygsoft.alibaba.fastjson.JSONObject.parseObject((String)body, StdReceiveListVO.class);
        if (respList.getData() != null) {
            String contentJson = com.ygsoft.alibaba.fastjson.JSONObject.toJSONString(respList.getData());
            respList.setData(StdMappServiceUtil.castToList(contentJson, responseType));
        }
        return respList;
    }

    private static <T> GwReceiveListVO<T> gwCastToRespResultList(String body, Class<T> responseType) {
        GwReceiveListVO respList = (GwReceiveListVO)com.ygsoft.alibaba.fastjson.JSONObject.parseObject((String)body, GwReceiveListVO.class);
        if (respList.getData() != null) {
            String contentJson = com.ygsoft.alibaba.fastjson.JSONObject.toJSONString(respList.getData());
            respList.setData(StdMappServiceUtil.castToList(contentJson, responseType));
        }
        return respList;
    }

    public static <T> StdReceivePageVO<T> doGetPage(String url, Class<T> responseType, Object ... uriVariables) {
        StdMappServiceUtil.checkArgs(url, responseType);
        if (LOG.isInfoEnabled()) {
            String tipMsg = String.format("doGet---url:%s\uff0curiVariables:%s", url, StdMappServiceUtil.buildUriVariables(uriVariables));
            LOG.info((Object)tipMsg);
        }
        String body = (String)MappService.INSTANCE.doGet(url, String.class, uriVariables);
        StdMappServiceUtil.checkRespResult(body);
        return StdMappServiceUtil.castToRespResultPage(body, responseType);
    }

    private static <T> StdReceivePageVO<T> castToRespResultPage(String body, Class<T> responseType) {
        StdReceiveEntityVO recEntity = (StdReceiveEntityVO)BlockJSONUtil.fromJsonString(body, StdReceiveEntityVO.class, PageModel.class);
        PageModel pageContent = (PageModel)BlockJSONUtil.deserializedGeneric(recEntity.getData(), responseType);
        recEntity.setData(pageContent);
        StdReceivePageVO respPage = StdReceivePageVO.newFrom(recEntity);
        respPage.setData(pageContent);
        return respPage;
    }

    public static <T> T castToObject(String body, Class<T> responseType) {
        if (String.class == responseType) {
            return (T)body;
        }
        if (StdMappServiceUtil.isJsonObject(body)) {
            if (com.ygsoft.alibaba.fastjson.JSONObject.class == responseType) {
                return (T)com.ygsoft.alibaba.fastjson.JSONObject.parseObject((String)body);
            }
            if (JSONObject.class == responseType) {
                return (T)JSONObject.parseObject((String)body);
            }
            return (T)JSONUtil.fromJsonString((String)body, responseType);
        }
        if (StdMappServiceUtil.isJsonArray(body)) {
            String msg = "json\u5b57\u7b26\u4e32body=" + body + "\uff0c\u4e0d\u662f\u5355\u7eaf\u5bf9\u8c61\u3002";
            throw new InvalidJsonTypeException("ABC.0026", msg);
        }
        return (T)TypeUtils.castToJavaBean((Object)body, responseType);
    }

    public static <T> List<T> castToList(String body, Class<T> responseType) {
        if (!StdMappServiceUtil.isJsonArray(body)) {
            String msg = "json\u5b57\u7b26\u4e32body=" + body + "\uff0c\u4e0d\u662fJSONArray\u3002";
            throw new InvalidJsonTypeException("ABC.0026", msg);
        }
        JSONArray jsonArray = com.ygsoft.alibaba.fastjson.JSONObject.parseArray((String)body);
        ArrayList<Object> resultList = new ArrayList<Object>();
        if (jsonArray != null && jsonArray.size() > 0) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                resultList.add(jsonArray.getObject(i, responseType));
            }
        }
        return resultList;
    }

    private static boolean isJsonObject(String body) {
        return body.matches(JSON_OBJECT_PATTERN);
    }

    private static boolean isJsonArray(String body) {
        return body.matches(JSON_ARRAY_PATTERN);
    }

    private static <T> void checkArgs(String url, Class<T> responseType) {
        if (StringUtil.isNullOrTrimEmptyString((String)url)) {
            throw EmptyValueException.newInstance("\u53c2\u6570\u9519\u8bef\uff1aurl\u4e3a\u7a7a\u3002");
        }
        if (null == responseType) {
            throw EmptyValueException.newInstance("\u53c2\u6570\u9519\u8bef\uff1aresponseType\u4e3a\u7a7a\u3002");
        }
    }

    private static String buildUriVariables(Object ... uriVariables) {
        if (null == uriVariables) {
            return EMPTY_STRING;
        }
        StringBuilder sb = new StringBuilder();
        for (Object obj : uriVariables) {
            sb.append(PREFIX_URI_VALUE).append(obj).append(POSTFIX_URI_VALUE);
        }
        return sb.toString();
    }

    private static void checkRespResult(String body) {
        if (StringUtil.isNullOrTrimEmptyString((String)body)) {
            StdMappServiceUtil.logError("doGet\u8c03\u7528\u5931\u8d25\uff1a" + body, null);
            throw MappServiceCallException.newInstance("\u8fd4\u56deResponseBody\u4e3a\u7a7a\u3002");
        }
        StdReceiveVO respResult = StdMappServiceUtil.castToObject(body, StdReceiveVO.class);
        if (respResult.getCode().isFail()) {
            throw MappServiceCallException.newInstance(respResult.getMessage());
        }
    }

    private static void GwCheckRespResult(String body) {
        if (StringUtil.isNullOrTrimEmptyString((String)body)) {
            StdMappServiceUtil.logError("doGet\u8c03\u7528\u5931\u8d25\uff1a" + body, null);
            throw MappServiceCallException.newInstance("\u8fd4\u56deResponseBody\u4e3a\u7a7a\u3002");
        }
        GwStdReceiveVO respResult = StdMappServiceUtil.castToObject(body, GwStdReceiveVO.class);
        if (!respResult.success()) {
            throw MappServiceCallException.newInstance(respResult.getMessage());
        }
    }

    private static void logError(Object obj, Throwable e) {
        if (LOG.isErrorEnabled()) {
            if (null == e) {
                LOG.error((Object)("\n###" + obj));
            } else {
                LOG.error((Object)("\n###" + obj), e);
            }
        }
    }
}

