/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.security;

import java.io.UnsupportedEncodingException;

public class Base64Coder {
    private static final String base64EncodeChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static final int[] base64DecodeChars = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1};

    public static String base64decode(String inStr) {
        StringBuffer out = new StringBuffer("");
        if (inStr.length() > 3 && "#@$".equals(inStr.substring(0, 3))) {
            String str = inStr.substring(3);
            int i = 0;
            int len = str.length();
            while (i < len) {
                int c2;
                int c1;
                do {
                    c1 = base64DecodeChars[str.codePointAt(i++) & 0xFF];
                } while (i < len && c1 == -1);
                if (c1 == -1) break;
                do {
                    c2 = base64DecodeChars[str.codePointAt(i++) & 0xFF];
                } while (i < len && c2 == -1);
                if (c2 != -1) {
                    int c3;
                    out.append((char)(c1 << 2 | (c2 & 0x30) >> 4));
                    do {
                        if ((c3 = str.codePointAt(i++) & 0xFF) == 61) {
                            return out.toString();
                        }
                        c3 = base64DecodeChars[c3];
                    } while (i < len && c3 == -1);
                    if (c3 != -1) {
                        int c4;
                        out.append((char)((c2 & 0xF) << 4 | (c3 & 0x3C) >> 2));
                        do {
                            if ((c4 = str.codePointAt(i++) & 0xFF) == 61) {
                                return out.toString();
                            }
                            c4 = base64DecodeChars[c4];
                        } while (i < len && c4 == -1);
                        if (c4 != -1) {
                            out.append((char)((c3 & 3) << 6 | c4));
                            continue;
                        }
                    }
                }
                break;
            }
        } else {
            out = new StringBuffer(inStr);
        }
        return out.toString();
    }

    public static String base64encode(String inStr) {
        String out = "";
        int i = 0;
        int len = inStr.length();
        while (i < len) {
            int c1 = inStr.charAt(i++) & 0xFF;
            if (i == len) {
                out = out + base64EncodeChars.charAt(c1 >> 2);
                out = out + base64EncodeChars.charAt((c1 & 3) << 4);
                out = out + "==";
                break;
            }
            char c2 = inStr.charAt(i++);
            if (i == len) {
                out = out + base64EncodeChars.charAt(c1 >> 2);
                out = out + base64EncodeChars.charAt((c1 & 3) << 4 | (c2 & 0xF0) >> 4);
                out = out + base64EncodeChars.charAt((c2 & 0xF) << 2);
                out = out + "=";
                break;
            }
            char c3 = inStr.charAt(i++);
            out = out + base64EncodeChars.charAt(c1 >> 2);
            out = out + base64EncodeChars.charAt((c1 & 3) << 4 | (c2 & 0xF0) >> 4);
            out = out + base64EncodeChars.charAt((c2 & 0xF) << 2 | (c3 & 0xC0) >> 6);
            out = out + base64EncodeChars.charAt(c3 & 0x3F);
        }
        if (out.length() > 0) {
            out = "#@$" + out;
        }
        return out;
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        String s1 = "DXTYBZ=0 AND XMBM='201511'";
        String s2 = "RFhUWUJaPTAgQU5EIFhNQk09JzIwMTUxMSc=";
        System.out.println(Base64Coder.base64decode(s2));
        System.out.println("null : " + Base64Coder.base64decode(""));
        String s3 = "384927";
        System.out.println("s3 : " + Base64Coder.base64encode(s3));
        System.out.println("s3 : " + Base64Coder.base64decode(Base64Coder.base64encode(s3)));
    }
}

