/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.security;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;

public class RSAExternalUtil {
    private static final String RSA_ALGORITHM = "RSA";
    public static final String SIGN_ALGORITHMS = "SHA1withRSA";
    private static final int MAX_ENCRYPT_BLOCK = 117;
    private static final int MAX_DECRYPT_BLOCK = 128;

    private RSAExternalUtil() {
    }

    private static Cipher getCiper() {
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(RSA_ALGORITHM);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException("\u6784\u9020RSA Ciper\u5931\u8d25\u3002", e);
        }
        return cipher;
    }

    public static String byteToBase64Str(byte[] contend) {
        return Base64.getEncoder().encodeToString(contend);
    }

    public static byte[] base64StrToByte(String base64Str) {
        try {
            return Base64.getDecoder().decode(base64Str.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("base64\u7f16\u7801\u5b57\u7b26\u4e32\u8f6c\u6362\u6210\u5b57\u8282\u6570\u7ec4\u51fa\u9519\u3002", e);
        }
    }

    public static String getKeyString(Key key) throws Exception {
        byte[] keyBytes = key.getEncoded();
        return RSAExternalUtil.byteToBase64Str(keyBytes);
    }

    public static PublicKey getPublicKey(String key) throws Exception {
        byte[] bytes = RSAExternalUtil.base64StrToByte(key);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(bytes);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
        PublicKey publicKey = keyFactory.generatePublic(keySpec);
        return publicKey;
    }

    public static PrivateKey getPrivateKey(String key) throws Exception {
        byte[] keyBytes = RSAExternalUtil.base64StrToByte(key);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
        PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
        return privateKey;
    }

    public static String encryptBlockByPublicKey(String publicKey, String plainText) {
        try {
            Cipher cipher = RSAExternalUtil.getCiper();
            cipher.init(1, RSAExternalUtil.getPublicKey(publicKey));
            byte[] encryptData = plainText.getBytes("UTF-8");
            int inputLen = encryptData.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(encryptData, offSet, 117) : cipher.doFinal(encryptData, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 117;
            }
            byte[] decryptedData = out.toByteArray();
            out.close();
            return RSAExternalUtil.byteToBase64Str(decryptedData);
        }
        catch (Exception e) {
            throw new RuntimeException("\u4f7f\u7528\u516c\u94a5\u5bf9\u6570\u636e\u5206\u6bb5\u52a0\u5bc6\u6355\u83b7\u5230\u5f02\u5e38,\u5f02\u5e38\u7684\u4fe1\u606f\u4e3a:" + e.getMessage(), e);
        }
    }

    public static String decryptBlockByPrivateKey(String privateKey, String enStr) {
        try {
            Cipher cipher = RSAExternalUtil.getCiper();
            cipher.init(2, RSAExternalUtil.getPrivateKey(privateKey));
            byte[] encryptedData = RSAExternalUtil.base64StrToByte(enStr);
            int inputLen = encryptedData.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offset = 0;
            int i = 0;
            while (inputLen - offset > 0) {
                byte[] cache = inputLen - offset > 128 ? cipher.doFinal(encryptedData, offset, 128) : cipher.doFinal(encryptedData, offset, inputLen - offset);
                out.write(cache, 0, cache.length);
                offset = ++i * 128;
            }
            byte[] bytes = out.toByteArray();
            out.close();
            return new String(bytes);
        }
        catch (Exception e) {
            throw new RuntimeException("\u4f7f\u7528\u79c1\u94a5\u5bf9\u6570\u636e\u5206\u6bb5\u63a5\u5bc6\u6355\u83b7\u5230\u5f02\u5e38,\u5f02\u5e38\u7684\u4fe1\u606f\u4e3a:" + e.getMessage(), e);
        }
    }

    public static String encryptBlockByPrivateKey(String privateKey, String plainText) {
        try {
            Cipher cipher = RSAExternalUtil.getCiper();
            cipher.init(1, RSAExternalUtil.getPrivateKey(privateKey));
            byte[] encryptData = plainText.getBytes("UTF-8");
            int inputLen = encryptData.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(encryptData, offSet, 117) : cipher.doFinal(encryptData, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 117;
            }
            byte[] decryptedData = out.toByteArray();
            out.close();
            return RSAExternalUtil.byteToBase64Str(decryptedData);
        }
        catch (Exception e) {
            throw new RuntimeException("\u4f7f\u7528\u79c1\u94a5\u5bf9\u6570\u636e\u5206\u6bb5\u52a0\u5bc6\u6355\u83b7\u5230\u5f02\u5e38,\u5f02\u5e38\u7684\u4fe1\u606f\u4e3a:" + e.getMessage(), e);
        }
    }

    public static String decryptBlockByPublicKey(String publicKey, String enStr) {
        try {
            Cipher cipher = RSAExternalUtil.getCiper();
            cipher.init(2, RSAExternalUtil.getPublicKey(publicKey));
            byte[] encryptedData = RSAExternalUtil.base64StrToByte(enStr);
            int inputLen = encryptedData.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offset = 0;
            int i = 0;
            while (inputLen - offset > 0) {
                byte[] cache = inputLen - offset > 128 ? cipher.doFinal(encryptedData, offset, 128) : cipher.doFinal(encryptedData, offset, inputLen - offset);
                out.write(cache, 0, cache.length);
                offset = ++i * 128;
            }
            byte[] bytes = out.toByteArray();
            out.close();
            return new String(bytes);
        }
        catch (Exception e) {
            throw new RuntimeException("\u4f7f\u7528\u516c\u94a5\u5bf9\u6570\u636e\u5206\u6bb5\u63a5\u5bc6\u6355\u83b7\u5230\u5f02\u5e38,\u5f02\u5e38\u7684\u4fe1\u606f\u4e3a:" + e.getMessage(), e);
        }
    }

    public static String getMD5(String msg) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("\u627e\u4e0d\u5230md5\u7b97\u6cd5\u3002", e);
        }
        md.reset();
        md.update(msg.getBytes());
        byte[] bytes = md.digest();
        String result = "";
        for (byte b : bytes) {
            result = result + String.format("%02x", b);
        }
        return result;
    }

    public static void main(String[] args) {
        String publicKey = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCN7nO9uqo0mM8f7h1jhESW9InWP5qqChWpOt2R6Q3BGqzgTgOw5x5+JXgPmsHEPWulqJ55qZFC6H1eKgIeLH03eO9k2CC2DD4LDTeoZDPPD8u3PESf53inYH7mDoec+JsxDivdxb7vBykxVyBfvur9IQOdxK6tb98q5pukTxPR7QIDAQAB";
        System.out.println("\u516c\u94a5\uff1aMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCN7nO9uqo0mM8f7h1jhESW9InWP5qqChWpOt2R6Q3BGqzgTgOw5x5+JXgPmsHEPWulqJ55qZFC6H1eKgIeLH03eO9k2CC2DD4LDTeoZDPPD8u3PESf53inYH7mDoec+JsxDivdxb7vBykxVyBfvur9IQOdxK6tb98q5pukTxPR7QIDAQAB");
        String privateKey = "MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBAI3uc726qjSYzx/uHWOERJb0idY/mqoKFak63ZHpDcEarOBOA7DnHn4leA+awcQ9a6WonnmpkULofV4qAh4sfTd472TYILYMPgsNN6hkM88Py7c8RJ/neKdgfuYOh5z4mzEOK93Fvu8HKTFXIF++6v0hA53Erq1v3yrmm6RPE9HtAgMBAAECgYAWdLDJRvxhAABdW+44bZfwjlY0mLGez6Ont9GQoV/0uoS5pH4/AgI4ETOSvHiF1PXwKuKP+z0paeFUAa9+GKni3Z+Kr4dbVJON76nkqroU1lAtMNbv4SL9o6Gir76mgih5V+XNbt+PRSO2Fv1c7hMXQvO6HMpIdr6/BF7w6hlLfQJBAMPML3SaMuobIn+ay+ufXM58n+SpXs6VX6VY7p3Lx6zMJ40A5NP5UZj+juI9ZbDyOxmGE8IP2aqfwrKvOvd8FscCQQC5kk0jSJ7WBekwkG87TtvdZG9IsPAqOQGAD5DZKOcgVPZi2KBkoA86sMOfC1IPWpE+Ju23W9Cos7kBx/z7M42rAkAYtFGkh7Q235eZvCFQqHngP8843bntnOFFjpQE6upVviibXOqCaGnIQQ4sM4z6J4YXcVha2v8ezSuWug9ZnJmPAkAWjOzKyNxkbbt0p1idAGw/byEG2FmXB+5ivYGAojPT/f8i6+gx0jGHlEtxXFLQgtT7lId2rLWiipSE3uSjMhSZAkBY2Lflnbr6cfrsP6rCUAAaL0a9gu+vV1KRMzGK9YT025iMg3fJ3LDn8Q2fjH5vl8bNKZo3QYCgnvETQL1x19sT";
        System.out.println("\u79c1\u94a5\uff1aMIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBAI3uc726qjSYzx/uHWOERJb0idY/mqoKFak63ZHpDcEarOBOA7DnHn4leA+awcQ9a6WonnmpkULofV4qAh4sfTd472TYILYMPgsNN6hkM88Py7c8RJ/neKdgfuYOh5z4mzEOK93Fvu8HKTFXIF++6v0hA53Erq1v3yrmm6RPE9HtAgMBAAECgYAWdLDJRvxhAABdW+44bZfwjlY0mLGez6Ont9GQoV/0uoS5pH4/AgI4ETOSvHiF1PXwKuKP+z0paeFUAa9+GKni3Z+Kr4dbVJON76nkqroU1lAtMNbv4SL9o6Gir76mgih5V+XNbt+PRSO2Fv1c7hMXQvO6HMpIdr6/BF7w6hlLfQJBAMPML3SaMuobIn+ay+ufXM58n+SpXs6VX6VY7p3Lx6zMJ40A5NP5UZj+juI9ZbDyOxmGE8IP2aqfwrKvOvd8FscCQQC5kk0jSJ7WBekwkG87TtvdZG9IsPAqOQGAD5DZKOcgVPZi2KBkoA86sMOfC1IPWpE+Ju23W9Cos7kBx/z7M42rAkAYtFGkh7Q235eZvCFQqHngP8843bntnOFFjpQE6upVviibXOqCaGnIQQ4sM4z6J4YXcVha2v8ezSuWug9ZnJmPAkAWjOzKyNxkbbt0p1idAGw/byEG2FmXB+5ivYGAojPT/f8i6+gx0jGHlEtxXFLQgtT7lId2rLWiipSE3uSjMhSZAkBY2Lflnbr6cfrsP6rCUAAaL0a9gu+vV1KRMzGK9YT025iMg3fJ3LDn8Q2fjH5vl8bNKZo3QYCgnvETQL1x19sT");
        String enStr = "cvPcnyqiXBgRZ6DSxaNZpwqYRMtd8C/DGpKJkhqHxNBP0uc2oJugfPBelIp4TOw53PkeLhl+3aMvbpFCvvgEo0fL1GLrEU9B3sBkU7+i0Phjz7tUToXa0f5obHJ2jjRoaatqDdIQXYZ64PQ8UKZWeJw426464FQXVLjmQiGvNixJFmeB/or5wdJtZvQzAn17Sva4GOQ9wrTBt6HBOJ/lgZWA2KWR9yIslGk49+Y4d3zeSLgJOvHxxm0PxWLQm5fDA0suW/tCxrlBSM3jbIGuqiGryYHCLbi6/K6zWMx5GBQWhVAnzBl5GkSMLm+Il0AY647rdmdIAUQ28YgejKgeeSNgt77cEZW61UGXU5KyApDis2UQwfFYI7IQnUAZB+OQGcS/zqPpHNUapJflzAdsAgGPtRCpzYZQXZ9e/9tTkdIZEZEugxEDFJDvT/qQYdC3XfNY1lRRBCGlqlzq7SAtlrwhyszVBZCZXlJRx6gmcybUop/r6HR71bO6br/zrjo1fD33KgwXBTXEoR6TCPT7cCiyapPhg96ILuSDQqUHNrI/TsXA4Vt7KxEaDDfxpgRaLa4YR5fX8UtefX2PrUwmhGl15aqyW4MRPl3qnUtMaYdSOdNw2BWx+x8lDVDiym5Th6rEYTgcWlRvivN5tS62OJ+xE2KsAb2OurDWOU/ewY19glGpGFXoidnY/G/b/yd+OxM25z9OfuyTPIFCmih3dt2ZJ4S3QwDIev7uo1zLl65Fn36csVYHmNTtzUZXi8nFDL4cJ18moY5eSon8rKUe7AraM51bMKF1lilpE6tBMxTU0oUWDwH+xkaTHbMbplV13bu9KerM+kpPOtXZcGXijU03nh8RGrSe01fhHv4umT2e2PnVCJRS/dbkR2rmAv1AKgFfrOyZ7QG2HRSSwc9TVLVuR+2B3phMUMEpMZTQuiGeGqzgUCkemTRC+/Ls6DK8B0R21bQfKR/xRTo1HpbXxdD028Qpp8ugkDsDAQlbc06odabPzZHqJchEphZXATg0FSaMdRukm8qAlbcH0tY7cQNKIBm6UjCBb//OAlpfiAKdoagNkYxL2mvH19ART9T/BTEVAasZ2g3axXtFanBk1ZlpIGtp08KBgYE6tQZE8zZQNrDr53S0Zj98/lUB+WB9qRp3AByLeiDCcelGWOJTZKljgiFWzG6EwSvBVSuWycEjgwWR7X0UJdfg0lA0s5vcdKaRr2dK+x9G2qKbPqN3UrfXagVGmtbTDHv0ssBHC8zzc1Xd0GBg2Lw4BHPI2NKmGBMNh4HAiAbNFqQAMx7WsdLH51jJGu5Nfhox59yG3OOp0AR+K8fNnzXegZKJWgIa28X9NLK+zEJAIJB0R2sLnyBA4dxwW3t5k9Sj8cf2iZhEudDw6pvvnELef4gFg4LCowlgd4dz+N75uIuNYGD6imabHMSdW9kUNiHWHMLErgI4WF9c8A6tjPEuuuJSTS/bQBve0LyhCcNOhpKLrq7G4+lyzkWuEbFN6XhmmdqfJLbjOT5anlKtCml90M/Vh80vBoxXCUOQ95otqOTirNZS8nB99CHV8Hku9dfcVYNP8EtbWHsjGnFxioMBuDGwtokuLwgNgx9aPUEPULgynJgZoBuGZjJwEWjvxcSZzNxwdC1c35iCKKC/L4y0bFNo5SBjLDcFWLhFonp+ZAyULN7hPxpmjMhqCrZKmDBT8MwDQ3SKaYzdbTqrKfKpI9Y+IHtQc1Ihfmrhh5+usuPYnFgDIH+FdRt5sU4PY7uAhP6q0JokXOWbx3fyL0zobmDbOVDh9BFMHPyICw1iXi0vnV6/5kNOZ+GgiO5dH68bVDD6IqbXLn8BDuYKq3BRHtbwr5rZv5FyRZizO8tsYPrUHqNvBw==";
        String json = RSAExternalUtil.decryptBlockByPublicKey("MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCN7nO9uqo0mM8f7h1jhESW9InWP5qqChWpOt2R6Q3BGqzgTgOw5x5+JXgPmsHEPWulqJ55qZFC6H1eKgIeLH03eO9k2CC2DD4LDTeoZDPPD8u3PESf53inYH7mDoec+JsxDivdxb7vBykxVyBfvur9IQOdxK6tb98q5pukTxPR7QIDAQAB", "cvPcnyqiXBgRZ6DSxaNZpwqYRMtd8C/DGpKJkhqHxNBP0uc2oJugfPBelIp4TOw53PkeLhl+3aMvbpFCvvgEo0fL1GLrEU9B3sBkU7+i0Phjz7tUToXa0f5obHJ2jjRoaatqDdIQXYZ64PQ8UKZWeJw426464FQXVLjmQiGvNixJFmeB/or5wdJtZvQzAn17Sva4GOQ9wrTBt6HBOJ/lgZWA2KWR9yIslGk49+Y4d3zeSLgJOvHxxm0PxWLQm5fDA0suW/tCxrlBSM3jbIGuqiGryYHCLbi6/K6zWMx5GBQWhVAnzBl5GkSMLm+Il0AY647rdmdIAUQ28YgejKgeeSNgt77cEZW61UGXU5KyApDis2UQwfFYI7IQnUAZB+OQGcS/zqPpHNUapJflzAdsAgGPtRCpzYZQXZ9e/9tTkdIZEZEugxEDFJDvT/qQYdC3XfNY1lRRBCGlqlzq7SAtlrwhyszVBZCZXlJRx6gmcybUop/r6HR71bO6br/zrjo1fD33KgwXBTXEoR6TCPT7cCiyapPhg96ILuSDQqUHNrI/TsXA4Vt7KxEaDDfxpgRaLa4YR5fX8UtefX2PrUwmhGl15aqyW4MRPl3qnUtMaYdSOdNw2BWx+x8lDVDiym5Th6rEYTgcWlRvivN5tS62OJ+xE2KsAb2OurDWOU/ewY19glGpGFXoidnY/G/b/yd+OxM25z9OfuyTPIFCmih3dt2ZJ4S3QwDIev7uo1zLl65Fn36csVYHmNTtzUZXi8nFDL4cJ18moY5eSon8rKUe7AraM51bMKF1lilpE6tBMxTU0oUWDwH+xkaTHbMbplV13bu9KerM+kpPOtXZcGXijU03nh8RGrSe01fhHv4umT2e2PnVCJRS/dbkR2rmAv1AKgFfrOyZ7QG2HRSSwc9TVLVuR+2B3phMUMEpMZTQuiGeGqzgUCkemTRC+/Ls6DK8B0R21bQfKR/xRTo1HpbXxdD028Qpp8ugkDsDAQlbc06odabPzZHqJchEphZXATg0FSaMdRukm8qAlbcH0tY7cQNKIBm6UjCBb//OAlpfiAKdoagNkYxL2mvH19ART9T/BTEVAasZ2g3axXtFanBk1ZlpIGtp08KBgYE6tQZE8zZQNrDr53S0Zj98/lUB+WB9qRp3AByLeiDCcelGWOJTZKljgiFWzG6EwSvBVSuWycEjgwWR7X0UJdfg0lA0s5vcdKaRr2dK+x9G2qKbPqN3UrfXagVGmtbTDHv0ssBHC8zzc1Xd0GBg2Lw4BHPI2NKmGBMNh4HAiAbNFqQAMx7WsdLH51jJGu5Nfhox59yG3OOp0AR+K8fNnzXegZKJWgIa28X9NLK+zEJAIJB0R2sLnyBA4dxwW3t5k9Sj8cf2iZhEudDw6pvvnELef4gFg4LCowlgd4dz+N75uIuNYGD6imabHMSdW9kUNiHWHMLErgI4WF9c8A6tjPEuuuJSTS/bQBve0LyhCcNOhpKLrq7G4+lyzkWuEbFN6XhmmdqfJLbjOT5anlKtCml90M/Vh80vBoxXCUOQ95otqOTirNZS8nB99CHV8Hku9dfcVYNP8EtbWHsjGnFxioMBuDGwtokuLwgNgx9aPUEPULgynJgZoBuGZjJwEWjvxcSZzNxwdC1c35iCKKC/L4y0bFNo5SBjLDcFWLhFonp+ZAyULN7hPxpmjMhqCrZKmDBT8MwDQ3SKaYzdbTqrKfKpI9Y+IHtQc1Ihfmrhh5+usuPYnFgDIH+FdRt5sU4PY7uAhP6q0JokXOWbx3fyL0zobmDbOVDh9BFMHPyICw1iXi0vnV6/5kNOZ+GgiO5dH68bVDD6IqbXLn8BDuYKq3BRHtbwr5rZv5FyRZizO8tsYPrUHqNvBw==");
        System.out.println("\u89e3\u5bc6\u540e\uff1a" + json);
        String plainText = "\u8fd9\u662f\u539f\u59cb\u5b57\u7b26\u4e32\u3002";
        String md5_2 = RSAExternalUtil.getMD5("\u8fd9\u662f\u539f\u59cb\u5b57\u7b26\u4e32\u3002");
        System.out.println("md5\u503c\uff1a" + md5_2);
    }
}

