/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.security;

import com.ygsoft.abc.service.domain.vo.Base64KeyPair;
import com.ygsoft.abc.service.exception.AbcCryptoException;
import com.ygsoft.abc.service.exception.AbcSignatureException;
import com.ygsoft.abc.service.exception.EmptyValueException;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.JSONUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;

public final class RSAUtil {
    private static final IEcpLog LOG = EcpLogFactory.getLog(RSAUtil.class);
    private static final int KEY_LENGTH = 1024;
    private static final String RSA_ALGORITHM = "RSA";
    public static final String SIGN_ALGORITHMS = "SHA1withRSA";
    private static final int MAX_ENCRYPT_BLOCK = 117;
    private static final int MAX_DECRYPT_BLOCK = 128;

    private RSAUtil() {
    }

    private static Cipher getCiper() {
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(RSA_ALGORITHM);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException("\u6784\u9020RSA Ciper\u5931\u8d25\u3002", e);
        }
        return cipher;
    }

    public static KeyPair generateKeyPair() {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(RSA_ALGORITHM);
            keyPairGenerator.initialize(1024);
            return keyPairGenerator.generateKeyPair();
        }
        catch (Exception e) {
            throw new AbcCryptoException("ABC.0032", EcpI18nUtil.localizedString((String)"RSAUtil_generateKeyPair_72", (String)"\u751f\u6210\u5bc6\u94a5\u5bf9\u5931\u8d25\u3002"));
        }
    }

    public static Base64KeyPair transferBase64KeyPair(KeyPair keyPair) {
        if (null == keyPair) {
            String msg = EcpI18nUtil.localizedString((String)"RSAUtil_transferBase64KeyPair_84", (String)"\u53c2\u6570\u9519\u8bef\uff1akeyPair\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        PublicKey publicKey = keyPair.getPublic();
        String base64PublicKey = new String(Base64.getEncoder().encode(publicKey.getEncoded()));
        PrivateKey privateKey = keyPair.getPrivate();
        String base64PrivateKey = new String(Base64.getEncoder().encode(privateKey.getEncoded()));
        return new Base64KeyPair(base64PublicKey, base64PrivateKey);
    }

    public static PublicKey base64ToPublicKey(String base64PublicKey) {
        if (StringUtil.isNullOrTrimEmptyString((String)base64PublicKey)) {
            String msg = EcpI18nUtil.localizedString((String)"RSAUtil_base64ToPublicKey_104", (String)"\u53c2\u6570\u9519\u8bef\uff1abase64PublicKey\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        try {
            byte[] keyBytes = Base64.getDecoder().decode(base64PublicKey.getBytes());
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
            return keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            throw new AbcCryptoException("ABC.0032", EcpI18nUtil.localizedString((String)"RSAUtil_base64ToPublicKey_113", (String)"Base64\u8f6c\u516c\u94a5\u5931\u8d25\u3002"));
        }
    }

    public static PrivateKey base64ToPrivateKey(String base64PrivateKey) {
        if (StringUtil.isNullOrTrimEmptyString((String)base64PrivateKey)) {
            String msg = EcpI18nUtil.localizedString((String)"RSAUtil_base64ToPrivateKey_125", (String)"\u53c2\u6570\u9519\u8bef\uff1abase64PrivateKey\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        try {
            byte[] keyBytes = Base64.getDecoder().decode(base64PrivateKey.getBytes());
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
            return keyFactory.generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw new AbcCryptoException("ABC.0032", EcpI18nUtil.localizedString((String)"RSAUtil_base64ToPrivateKey_134", (String)"Base64\u8f6c\u79c1\u94a5\u5931\u8d25\u3002"));
        }
    }

    public static byte[] encrypt(byte[] content, String base64PublicKey) {
        if (content == null || content.length == 0) {
            String msg = EcpI18nUtil.localizedString((String)"RSAUtil_encrypt_147", (String)"\u53c2\u6570\u9519\u8bef\uff1acontent\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        if (StringUtil.isNullOrTrimEmptyString((String)base64PublicKey)) {
            String msg = EcpI18nUtil.localizedString((String)"RSAUtil_encrypt_151", (String)"\u53c2\u6570\u9519\u8bef\uff1abase64PublicKey\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        return RSAUtil.encrypt(content, RSAUtil.base64ToPublicKey(base64PublicKey));
    }

    public static byte[] encrypt(byte[] content, PublicKey publicKey) {
        if (content == null || content.length == 0) {
            String msg = EcpI18nUtil.localizedString((String)"RSAUtil_eencrypt_166", (String)"\u53c2\u6570\u9519\u8bef\uff1acontent\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        if (publicKey == null) {
            String msg = EcpI18nUtil.localizedString((String)"RSAUtil_eencrypt_170", (String)"\u53c2\u6570\u9519\u8bef\uff1apublicKey\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        try {
            Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
            cipher.init(1, publicKey);
            return cipher.doFinal(content);
        }
        catch (Exception e) {
            throw new AbcCryptoException("ABC.0032", EcpI18nUtil.localizedString((String)"RSAUtil_eencrypt_179", (String)"\u516c\u94a5\u52a0\u5bc6\u5931\u8d25\u3002"));
        }
    }

    public static byte[] decrypt(byte[] content, String base64PrivateKey) {
        if (content == null || content.length == 0) {
            String msg = EcpI18nUtil.localizedString((String)"RSAUtil_decrypt_192", (String)"\u53c2\u6570\u9519\u8bef\uff1acontent\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        if (StringUtil.isNullOrTrimEmptyString((String)base64PrivateKey)) {
            String msg = EcpI18nUtil.localizedString((String)"RSAUtil_decrypt_196", (String)"\u53c2\u6570\u9519\u8bef\uff1abase64PrivateKey\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        return RSAUtil.decrypt(content, RSAUtil.base64ToPrivateKey(base64PrivateKey));
    }

    public static byte[] decrypt(byte[] content, PrivateKey privateKey) {
        if (content == null || content.length == 0) {
            String msg = EcpI18nUtil.localizedString((String)"RSAUtil_decrypt_211", (String)"\u53c2\u6570\u9519\u8bef\uff1acontent\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        if (privateKey == null) {
            String msg = EcpI18nUtil.localizedString((String)"RSAUtil_decrypt_215", (String)"\u53c2\u6570\u9519\u8bef\uff1aprivateKey\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        try {
            Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
            cipher.init(2, privateKey);
            return cipher.doFinal(content);
        }
        catch (Exception e) {
            throw new AbcCryptoException("ABC.0032", EcpI18nUtil.localizedString((String)"RSAUtil_decrypt_223", (String)"\u79c1\u94a5\u89e3\u5bc6\u5931\u8d25\u3002"));
        }
    }

    public static String sign(byte[] content, String base64PrivateKey) {
        if (content == null || content.length == 0) {
            String msg = EcpI18nUtil.localizedString((String)"RSAUtil_sign_236", (String)"\u53c2\u6570\u9519\u8bef\uff1acontent\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        if (StringUtil.isNullOrTrimEmptyString((String)base64PrivateKey)) {
            String msg = EcpI18nUtil.localizedString((String)"RSAUtil_sign_240", (String)"\u53c2\u6570\u9519\u8bef\uff1abase64PrivateKey\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        return RSAUtil.sign(content, RSAUtil.base64ToPrivateKey(base64PrivateKey));
    }

    public static String sign(byte[] content, PrivateKey privateKey) {
        if (content == null || content.length == 0) {
            String msg = EcpI18nUtil.localizedString((String)"RSAUtil_sign_254", (String)"\u53c2\u6570\u9519\u8bef\uff1acontent\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        if (privateKey == null) {
            String msg = EcpI18nUtil.localizedString((String)"RSAUtil_sign_258", (String)"\u53c2\u6570\u9519\u8bef\uff1aprivateKey\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        try {
            Signature signature = Signature.getInstance(SIGN_ALGORITHMS);
            signature.initSign(privateKey);
            signature.update(content);
            byte[] signed = signature.sign();
            return new String(Base64.getEncoder().encode(signed));
        }
        catch (Exception e) {
            throw new AbcSignatureException("ABC.0033", EcpI18nUtil.localizedString((String)"RSAUtil_sign_269", (String)"\u6570\u636e\u7b7e\u540d\u5931\u8d25\u3002"));
        }
    }

    public static boolean check(byte[] content, String sign, String base64PublicKey) {
        if (content == null || content.length == 0) {
            String msg = EcpI18nUtil.localizedString((String)"RSAUtil_check_283", (String)"\u53c2\u6570\u9519\u8bef\uff1acontent\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        if (StringUtil.isNullOrTrimEmptyString((String)sign)) {
            String msg = EcpI18nUtil.localizedString((String)"RSAUtil_check_287", (String)"\u53c2\u6570\u9519\u8bef\uff1asign\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        if (StringUtil.isNullOrTrimEmptyString((String)base64PublicKey)) {
            String msg = EcpI18nUtil.localizedString((String)"RSAUtil_check_291", (String)"\u53c2\u6570\u9519\u8bef\uff1abase64PublicKey\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        return RSAUtil.check(content, sign, RSAUtil.base64ToPublicKey(base64PublicKey));
    }

    public static boolean check(byte[] content, String sign, PublicKey publicKey) {
        if (content == null || content.length == 0) {
            String msg = EcpI18nUtil.localizedString((String)"RSAUtil_check_307", (String)"\u53c2\u6570\u9519\u8bef\uff1acontent\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        if (StringUtil.isNullOrTrimEmptyString((String)sign)) {
            String msg = EcpI18nUtil.localizedString((String)"RSAUtil_check_311", (String)"\u53c2\u6570\u9519\u8bef\uff1asign\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        if (publicKey == null) {
            String msg = EcpI18nUtil.localizedString((String)"RSAUtil_check_315", (String)"\u53c2\u6570\u9519\u8bef\uff1apublicKey\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        try {
            Signature signature = Signature.getInstance(SIGN_ALGORITHMS);
            signature.initVerify(publicKey);
            signature.update(content);
            boolean verify = signature.verify(Base64.getDecoder().decode(sign));
            return verify;
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"\n###\u9a8c\u7b7e\u540d\u5931\u8d25\u3002", (Throwable)e);
            }
            return false;
        }
    }

    public static String byteToBase64Str(byte[] contend) {
        return Base64.getEncoder().encodeToString(contend);
    }

    public static byte[] base64StrToByte(String base64Str) {
        try {
            return Base64.getDecoder().decode(base64Str.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("base64\u7f16\u7801\u5b57\u7b26\u4e32\u8f6c\u6362\u6210\u5b57\u8282\u6570\u7ec4\u51fa\u9519\u3002", e);
        }
    }

    public static String getKeyString(Key key) throws Exception {
        byte[] keyBytes = key.getEncoded();
        return RSAUtil.byteToBase64Str(keyBytes);
    }

    public static PublicKey getPublicKey(String key) throws Exception {
        byte[] bytes = RSAUtil.base64StrToByte(key);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(bytes);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
        PublicKey publicKey = keyFactory.generatePublic(keySpec);
        return publicKey;
    }

    public static PrivateKey getPrivateKey(String key) throws Exception {
        byte[] keyBytes = RSAUtil.base64StrToByte(key);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
        PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
        return privateKey;
    }

    public static String encryptBlockByPublicKey(String publicKey, String plainText) {
        try {
            Cipher cipher = RSAUtil.getCiper();
            cipher.init(1, RSAUtil.getPublicKey(publicKey));
            byte[] encryptData = plainText.getBytes("UTF-8");
            int inputLen = encryptData.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(encryptData, offSet, 117) : cipher.doFinal(encryptData, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 117;
            }
            byte[] decryptedData = out.toByteArray();
            out.close();
            return RSAUtil.byteToBase64Str(decryptedData);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("\u4f7f\u7528\u516c\u94a5\u5bf9\u6570\u636e\u5206\u6bb5\u52a0\u5bc6\u6355\u83b7\u5230\u5f02\u5e38,\u5f02\u5e38\u7684\u4fe1\u606f\u4e3a:" + e.getMessage()), (Throwable)e);
            }
            return null;
        }
    }

    public static String decryptBlockByPrivateKey(String privateKey, String enStr) {
        try {
            Cipher cipher = RSAUtil.getCiper();
            cipher.init(2, RSAUtil.getPrivateKey(privateKey));
            byte[] encryptedData = RSAUtil.base64StrToByte(enStr);
            int inputLen = encryptedData.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offset = 0;
            int i = 0;
            while (inputLen - offset > 0) {
                byte[] cache = inputLen - offset > 128 ? cipher.doFinal(encryptedData, offset, 128) : cipher.doFinal(encryptedData, offset, inputLen - offset);
                out.write(cache, 0, cache.length);
                offset = ++i * 128;
            }
            byte[] bytes = out.toByteArray();
            out.close();
            return new String(bytes);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    public static String encryptBlockByPrivateKey(String privateKey, String plainText) {
        try {
            Cipher cipher = RSAUtil.getCiper();
            cipher.init(1, RSAUtil.getPrivateKey(privateKey));
            byte[] encryptData = plainText.getBytes("UTF-8");
            int inputLen = encryptData.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(encryptData, offSet, 117) : cipher.doFinal(encryptData, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 117;
            }
            byte[] decryptedData = out.toByteArray();
            out.close();
            return RSAUtil.byteToBase64Str(decryptedData);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("\u4f7f\u7528\u79c1\u94a5\u5bf9\u6570\u636e\u5206\u6bb5\u52a0\u5bc6\u6355\u83b7\u5230\u5f02\u5e38,\u5f02\u5e38\u7684\u4fe1\u606f\u4e3a:" + e.getMessage()), (Throwable)e);
            }
            return null;
        }
    }

    public static String decryptBlockByPublicKey(String publicKey, String enStr) {
        try {
            Cipher cipher = RSAUtil.getCiper();
            cipher.init(2, RSAUtil.getPublicKey(publicKey));
            byte[] encryptedData = RSAUtil.base64StrToByte(enStr);
            int inputLen = encryptedData.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offset = 0;
            int i = 0;
            while (inputLen - offset > 0) {
                byte[] cache = inputLen - offset > 128 ? cipher.doFinal(encryptedData, offset, 128) : cipher.doFinal(encryptedData, offset, inputLen - offset);
                out.write(cache, 0, cache.length);
                offset = ++i * 128;
            }
            byte[] bytes = out.toByteArray();
            out.close();
            return new String(bytes);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    public static String getMD5(String msg) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("\u627e\u4e0d\u5230md5\u7b97\u6cd5\u3002", e);
        }
        md.reset();
        md.update(msg.getBytes());
        byte[] bytes = md.digest();
        String result = "";
        for (byte b : bytes) {
            result = result + String.format("%02x", b);
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        String pub_key = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCN7nO9uqo0mM8f7h1jhESW9InWP5qqChWpOt2R6Q3BGqzgTgOw5x5+JXgPmsHEPWulqJ55qZFC6H1eKgIeLH03eO9k2CC2DD4LDTeoZDPPD8u3PESf53inYH7mDoec+JsxDivdxb7vBykxVyBfvur9IQOdxK6tb98q5pukTxPR7QIDAQAB";
        System.out.println("\u516c\u94a5\uff1aMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCN7nO9uqo0mM8f7h1jhESW9InWP5qqChWpOt2R6Q3BGqzgTgOw5x5+JXgPmsHEPWulqJ55qZFC6H1eKgIeLH03eO9k2CC2DD4LDTeoZDPPD8u3PESf53inYH7mDoec+JsxDivdxb7vBykxVyBfvur9IQOdxK6tb98q5pukTxPR7QIDAQAB");
        String pri_key = "MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBAI3uc726qjSYzx/uHWOERJb0idY/mqoKFak63ZHpDcEarOBOA7DnHn4leA+awcQ9a6WonnmpkULofV4qAh4sfTd472TYILYMPgsNN6hkM88Py7c8RJ/neKdgfuYOh5z4mzEOK93Fvu8HKTFXIF++6v0hA53Erq1v3yrmm6RPE9HtAgMBAAECgYAWdLDJRvxhAABdW+44bZfwjlY0mLGez6Ont9GQoV/0uoS5pH4/AgI4ETOSvHiF1PXwKuKP+z0paeFUAa9+GKni3Z+Kr4dbVJON76nkqroU1lAtMNbv4SL9o6Gir76mgih5V+XNbt+PRSO2Fv1c7hMXQvO6HMpIdr6/BF7w6hlLfQJBAMPML3SaMuobIn+ay+ufXM58n+SpXs6VX6VY7p3Lx6zMJ40A5NP5UZj+juI9ZbDyOxmGE8IP2aqfwrKvOvd8FscCQQC5kk0jSJ7WBekwkG87TtvdZG9IsPAqOQGAD5DZKOcgVPZi2KBkoA86sMOfC1IPWpE+Ju23W9Cos7kBx/z7M42rAkAYtFGkh7Q235eZvCFQqHngP8843bntnOFFjpQE6upVviibXOqCaGnIQQ4sM4z6J4YXcVha2v8ezSuWug9ZnJmPAkAWjOzKyNxkbbt0p1idAGw/byEG2FmXB+5ivYGAojPT/f8i6+gx0jGHlEtxXFLQgtT7lId2rLWiipSE3uSjMhSZAkBY2Lflnbr6cfrsP6rCUAAaL0a9gu+vV1KRMzGK9YT025iMg3fJ3LDn8Q2fjH5vl8bNKZo3QYCgnvETQL1x19sT";
        System.out.println("\u79c1\u94a5\uff1aMIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBAI3uc726qjSYzx/uHWOERJb0idY/mqoKFak63ZHpDcEarOBOA7DnHn4leA+awcQ9a6WonnmpkULofV4qAh4sfTd472TYILYMPgsNN6hkM88Py7c8RJ/neKdgfuYOh5z4mzEOK93Fvu8HKTFXIF++6v0hA53Erq1v3yrmm6RPE9HtAgMBAAECgYAWdLDJRvxhAABdW+44bZfwjlY0mLGez6Ont9GQoV/0uoS5pH4/AgI4ETOSvHiF1PXwKuKP+z0paeFUAa9+GKni3Z+Kr4dbVJON76nkqroU1lAtMNbv4SL9o6Gir76mgih5V+XNbt+PRSO2Fv1c7hMXQvO6HMpIdr6/BF7w6hlLfQJBAMPML3SaMuobIn+ay+ufXM58n+SpXs6VX6VY7p3Lx6zMJ40A5NP5UZj+juI9ZbDyOxmGE8IP2aqfwrKvOvd8FscCQQC5kk0jSJ7WBekwkG87TtvdZG9IsPAqOQGAD5DZKOcgVPZi2KBkoA86sMOfC1IPWpE+Ju23W9Cos7kBx/z7M42rAkAYtFGkh7Q235eZvCFQqHngP8843bntnOFFjpQE6upVviibXOqCaGnIQQ4sM4z6J4YXcVha2v8ezSuWug9ZnJmPAkAWjOzKyNxkbbt0p1idAGw/byEG2FmXB+5ivYGAojPT/f8i6+gx0jGHlEtxXFLQgtT7lId2rLWiipSE3uSjMhSZAkBY2Lflnbr6cfrsP6rCUAAaL0a9gu+vV1KRMzGK9YT025iMg3fJ3LDn8Q2fjH5vl8bNKZo3QYCgnvETQL1x19sT");
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < 10; ++i) {
            map.put("\u7528\u6237\u59d3\u540d" + i, "\u5f20\u4e09");
            map.put("\u7528\u6237\u5e74\u9f84" + i, "30\u5c81");
            map.put("\u6240\u5c5e\u4f01\u4e1a" + i, "\u8fdc\u5149\u8f6f\u4ef6");
            map.put("\u6240\u5c5e\u90e8\u95e8" + i, "\u533a\u5757\u94fe\u5e94\u7528\u4e8b\u4e1a\u90e8");
        }
        String json = JSONUtil.toJsonString(map);
        System.out.println("\u539f\u6570\u636e:" + json);
        System.out.println("------------------------------------");
        String enJson = RSAUtil.encryptBlockByPublicKey("MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCN7nO9uqo0mM8f7h1jhESW9InWP5qqChWpOt2R6Q3BGqzgTgOw5x5+JXgPmsHEPWulqJ55qZFC6H1eKgIeLH03eO9k2CC2DD4LDTeoZDPPD8u3PESf53inYH7mDoec+JsxDivdxb7vBykxVyBfvur9IQOdxK6tb98q5pukTxPR7QIDAQAB", json);
        System.out.println("\u516c\u94a5\u52a0\u5bc6\u540e:" + enJson);
        String deJson = RSAUtil.decryptBlockByPrivateKey("MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBAI3uc726qjSYzx/uHWOERJb0idY/mqoKFak63ZHpDcEarOBOA7DnHn4leA+awcQ9a6WonnmpkULofV4qAh4sfTd472TYILYMPgsNN6hkM88Py7c8RJ/neKdgfuYOh5z4mzEOK93Fvu8HKTFXIF++6v0hA53Erq1v3yrmm6RPE9HtAgMBAAECgYAWdLDJRvxhAABdW+44bZfwjlY0mLGez6Ont9GQoV/0uoS5pH4/AgI4ETOSvHiF1PXwKuKP+z0paeFUAa9+GKni3Z+Kr4dbVJON76nkqroU1lAtMNbv4SL9o6Gir76mgih5V+XNbt+PRSO2Fv1c7hMXQvO6HMpIdr6/BF7w6hlLfQJBAMPML3SaMuobIn+ay+ufXM58n+SpXs6VX6VY7p3Lx6zMJ40A5NP5UZj+juI9ZbDyOxmGE8IP2aqfwrKvOvd8FscCQQC5kk0jSJ7WBekwkG87TtvdZG9IsPAqOQGAD5DZKOcgVPZi2KBkoA86sMOfC1IPWpE+Ju23W9Cos7kBx/z7M42rAkAYtFGkh7Q235eZvCFQqHngP8843bntnOFFjpQE6upVviibXOqCaGnIQQ4sM4z6J4YXcVha2v8ezSuWug9ZnJmPAkAWjOzKyNxkbbt0p1idAGw/byEG2FmXB+5ivYGAojPT/f8i6+gx0jGHlEtxXFLQgtT7lId2rLWiipSE3uSjMhSZAkBY2Lflnbr6cfrsP6rCUAAaL0a9gu+vV1KRMzGK9YT025iMg3fJ3LDn8Q2fjH5vl8bNKZo3QYCgnvETQL1x19sT", enJson);
        System.out.println("\u79c1\u94a5\u89e3\u5bc6\u540e:" + deJson);
        System.out.println("------------------------------------");
        String enJson2 = RSAUtil.encryptBlockByPrivateKey("MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBAI3uc726qjSYzx/uHWOERJb0idY/mqoKFak63ZHpDcEarOBOA7DnHn4leA+awcQ9a6WonnmpkULofV4qAh4sfTd472TYILYMPgsNN6hkM88Py7c8RJ/neKdgfuYOh5z4mzEOK93Fvu8HKTFXIF++6v0hA53Erq1v3yrmm6RPE9HtAgMBAAECgYAWdLDJRvxhAABdW+44bZfwjlY0mLGez6Ont9GQoV/0uoS5pH4/AgI4ETOSvHiF1PXwKuKP+z0paeFUAa9+GKni3Z+Kr4dbVJON76nkqroU1lAtMNbv4SL9o6Gir76mgih5V+XNbt+PRSO2Fv1c7hMXQvO6HMpIdr6/BF7w6hlLfQJBAMPML3SaMuobIn+ay+ufXM58n+SpXs6VX6VY7p3Lx6zMJ40A5NP5UZj+juI9ZbDyOxmGE8IP2aqfwrKvOvd8FscCQQC5kk0jSJ7WBekwkG87TtvdZG9IsPAqOQGAD5DZKOcgVPZi2KBkoA86sMOfC1IPWpE+Ju23W9Cos7kBx/z7M42rAkAYtFGkh7Q235eZvCFQqHngP8843bntnOFFjpQE6upVviibXOqCaGnIQQ4sM4z6J4YXcVha2v8ezSuWug9ZnJmPAkAWjOzKyNxkbbt0p1idAGw/byEG2FmXB+5ivYGAojPT/f8i6+gx0jGHlEtxXFLQgtT7lId2rLWiipSE3uSjMhSZAkBY2Lflnbr6cfrsP6rCUAAaL0a9gu+vV1KRMzGK9YT025iMg3fJ3LDn8Q2fjH5vl8bNKZo3QYCgnvETQL1x19sT", json);
        System.out.println("\u79c1\u94a5\u52a0\u5bc6\u540e:" + enJson2);
        String deJson2 = RSAUtil.decryptBlockByPublicKey("MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCN7nO9uqo0mM8f7h1jhESW9InWP5qqChWpOt2R6Q3BGqzgTgOw5x5+JXgPmsHEPWulqJ55qZFC6H1eKgIeLH03eO9k2CC2DD4LDTeoZDPPD8u3PESf53inYH7mDoec+JsxDivdxb7vBykxVyBfvur9IQOdxK6tb98q5pukTxPR7QIDAQAB", enJson2);
        System.out.println("\u516c\u94a5\u89e3\u5bc6\u540e:" + deJson2);
    }
}

