/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.security.converter;

import com.google.common.base.Strings;
import com.ygsoft.abc.service.security.sm4.SM4CBCUtil;
import com.ygsoft.abc.service.tool.PropertyConfigUtil;
import javax.persistence.AttributeConverter;

public class SM4CBCEncryptConverter
implements AttributeConverter<String, String> {
    public String convertToDatabaseColumn(String attribute) {
        if (!Strings.isNullOrEmpty((String)attribute) && PropertyConfigUtil.isEncodeUserKeyInformation()) {
            return SM4CBCUtil.getInstance().encodeWithHeader(attribute);
        }
        return attribute;
    }

    public String convertToEntityAttribute(String dbData) {
        if (Strings.isNullOrEmpty((String)dbData)) {
            return dbData;
        }
        return SM4CBCUtil.getInstance().decodeWithHeader(dbData).trim();
    }
}

