/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.security.key.kit;

import com.ygsoft.abc.service.domain.vo.Base64KeyPair;
import com.ygsoft.abc.service.exception.AbcCryptoException;
import com.ygsoft.abc.service.security.kit.Base64Kit;
import com.ygsoft.abc.service.tool.PreconditionUtil;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class KeyPairKit {
    private static final int KEY_SIZE = 1024;

    public static IKeyPairGenerator rsa() {
        return new RSAKeyPairGenerator(1024);
    }

    public static IKeyPairGenerator rsa(int keySize) {
        return new RSAKeyPairGenerator(keySize);
    }

    public static IKeyPairGenerator dsa() {
        return new DSAKeyPairGenerator(1024);
    }

    public static IKeyPairGenerator dsa(int keySize) {
        return new DSAKeyPairGenerator(keySize);
    }

    public static IKeyPairGenerator ecdsa() {
        return new ECDSAKeyPairGenerator();
    }

    public static Base64KeyPair transfer(KeyPair keyPair) {
        PreconditionUtil.checkNotNull(keyPair, "\u53c2\u6570\u9519\u8bef\uff1akeyPair\u4e3a\u7a7a\u3002");
        PublicKey publicKey = keyPair.getPublic();
        String base64PublicKey = Base64Kit.standardMode().encode(publicKey.getEncoded());
        PrivateKey privateKey = keyPair.getPrivate();
        String base64PrivateKey = Base64Kit.standardMode().encode(privateKey.getEncoded());
        return new Base64KeyPair(base64PublicKey, base64PrivateKey);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    static class ECDSAKeyPairGenerator
    implements IKeyPairGenerator {
        private static final String KEY_ALGORITHM = "ECDSA";

        private ECDSAKeyPairGenerator() {
        }

        @Override
        public KeyPair generate() {
            Security.addProvider((Provider)new BouncyCastleProvider());
            try {
                BigInteger p = new BigInteger("883423532389192164791648750360308885314476597252960362792450860609699839");
                ECFieldFp ecFieldFp = new ECFieldFp(p);
                BigInteger a = new BigInteger("7fffffffffffffffffffffff7fffffffffff8000000000007ffffffffffc", 16);
                BigInteger b = new BigInteger("6b016c3bdcf18941d0d654921475ca71a9db2fb27d1d37796185c2942c0a", 16);
                EllipticCurve ellipticCurve = new EllipticCurve(ecFieldFp, a, b);
                BigInteger x = new BigInteger("110282003749548856476348533541186204577905061504881242240149511594420911");
                BigInteger y = new BigInteger("869078407435509378747351873793058868500210384946040694651368759217025454");
                ECPoint g = new ECPoint(x, y);
                BigInteger n = new BigInteger("883423532389192164791648750360308884807550341691627752275345424702807307");
                ECParameterSpec ecParameterSpec = new ECParameterSpec(ellipticCurve, g, n, 1);
                KeyPairGenerator kpg = KeyPairGenerator.getInstance(KEY_ALGORITHM);
                kpg.initialize(ecParameterSpec, new SecureRandom());
                return kpg.generateKeyPair();
            }
            catch (Exception e) {
                throw AbcCryptoException.newInstance("\u751f\u6210\u5bc6\u94a5\u5bf9\u5931\u8d25\u3002", e);
            }
        }
    }

    static class DSAKeyPairGenerator
    implements IKeyPairGenerator {
        private static final String KEY_ALGORITHM = "DSA";
        private final int keySize;

        private DSAKeyPairGenerator(int keySize) {
            this.keySize = keySize;
        }

        @Override
        public KeyPair generate() {
            try {
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(KEY_ALGORITHM);
                keyPairGenerator.initialize(this.keySize, new SecureRandom());
                return keyPairGenerator.generateKeyPair();
            }
            catch (Exception e) {
                throw AbcCryptoException.newInstance("\u751f\u6210\u5bc6\u94a5\u5bf9\u5931\u8d25\u3002", e);
            }
        }
    }

    static class RSAKeyPairGenerator
    implements IKeyPairGenerator {
        private static final String KEY_ALGORITHM = "RSA";
        private final int keySize;

        private RSAKeyPairGenerator(int keySize) {
            this.keySize = keySize;
        }

        @Override
        public KeyPair generate() {
            try {
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(KEY_ALGORITHM);
                keyPairGenerator.initialize(this.keySize, new SecureRandom());
                return keyPairGenerator.generateKeyPair();
            }
            catch (Exception e) {
                throw AbcCryptoException.newInstance("\u751f\u6210\u5bc6\u94a5\u5bf9\u5931\u8d25\u3002", e);
            }
        }
    }

    public static interface IKeyPairGenerator {
        public KeyPair generate();
    }
}

