/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.security.key.kit;

import com.ygsoft.abc.service.exception.AbcCryptoException;
import java.security.SecureRandom;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class SecretKeyKit {
    private final String algorithm;
    private int keySize = -1;

    private SecretKeyKit(String algorithm) {
        this(algorithm, -1);
    }

    private SecretKeyKit(String algorithm, int keySize) {
        this.algorithm = algorithm;
        this.keySize = keySize;
    }

    public static SecretKeyKit getInstance(String algorithm) {
        return new SecretKeyKit(algorithm);
    }

    public static SecretKeyKit getInstance(String algorithm, int keySize) {
        SecretKeyKit kit = new SecretKeyKit(algorithm, keySize);
        return kit;
    }

    public SecretKey generate() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(this.algorithm);
            if (this.keySize != -1) {
                keyGenerator.init(this.keySize);
            }
            SecretKey secretKey = keyGenerator.generateKey();
            return secretKey;
        }
        catch (Exception e) {
            throw AbcCryptoException.newInstance("\u751f\u6210\u5bc6\u94a5\u5931\u8d25\u3002", e);
        }
    }

    public SecretKey generate(String password) {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(this.algorithm);
            if (this.keySize != -1) {
                keyGenerator.init(this.keySize, new SecureRandom(password.getBytes()));
            }
            SecretKey secretKey = keyGenerator.generateKey();
            return secretKey;
        }
        catch (Exception e) {
            throw AbcCryptoException.newInstance("\u751f\u6210\u5bc6\u94a5\u5931\u8d25\u3002", e);
        }
    }

    public SecretKey restore(byte[] key) {
        SecretKeySpec secretKey = new SecretKeySpec(key, this.algorithm);
        return secretKey;
    }
}

