/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.security.kit;

import com.ygsoft.abc.service.exception.AbcCryptoException;
import com.ygsoft.abc.service.security.kit.Base64Kit;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class AESKit {
    private static final String AES = "AES";
    private static final String AES_ALGORITHM = "AES/GCM/NoPadding";
    private static final int KEY_SIZE = 128;
    private static final int DEFAULT_SALT_SIZE = 16;
    private static final String DEFAULT_SALT = "YG.abc.1029384756";
    private static final AESKit INSTANCE = new AESKit();

    public static AESKit getInstance() {
        return INSTANCE;
    }

    private SecretKey restoreKey(byte[] key) {
        SecretKeySpec secretKey = new SecretKeySpec(key, AES);
        return secretKey;
    }

    public byte[] decrypt(byte[] data, byte[] key) {
        return this.decrypt(data, key, AESKit.getDefaultSalt());
    }

    public byte[] decrypt(byte[] data, byte[] key, byte[] iv) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            SecretKey secret = this.restoreKey(key);
            Cipher cipher = Cipher.getInstance(AES_ALGORITHM);
            cipher.init(2, (Key)secret, new GCMParameterSpec(128, iv));
            byte[] plainText = cipher.doFinal(data);
            return plainText;
        }
        catch (Exception ex) {
            throw AbcCryptoException.newInstance("\u89e3\u5bc6\u5931\u8d25\u3002", ex);
        }
    }

    public byte[] encrypt(byte[] data, byte[] key) {
        return this.encrypt(data, key, AESKit.getDefaultSalt());
    }

    public byte[] encrypt(byte[] data, byte[] key, byte[] iv) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            SecretKey secretKey = this.restoreKey(key);
            Cipher cipher = Cipher.getInstance(AES_ALGORITHM);
            cipher.init(1, (Key)secretKey, new GCMParameterSpec(128, iv));
            byte[] encryptedText = cipher.doFinal(data);
            return encryptedText;
        }
        catch (Exception ex) {
            throw AbcCryptoException.newInstance("\u52a0\u5bc6\u5931\u8d25\u3002", ex);
        }
    }

    private static byte[] getDefaultSalt() {
        byte[] arr = DEFAULT_SALT.getBytes();
        byte[] salt = new byte[16];
        System.arraycopy(arr, 0, salt, 0, 16);
        return salt;
    }

    public SecretKey generateKey(String password) {
        return this.generateKey(password.toCharArray(), AESKit.getDefaultSalt());
    }

    public SecretKey generateKey(char[] password, byte[] salt) {
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            PBEKeySpec spec = new PBEKeySpec(password, salt, 65536, 128);
            SecretKeySpec secret = new SecretKeySpec(factory.generateSecret(spec).getEncoded(), AES);
            return secret;
        }
        catch (Exception ex) {
            throw AbcCryptoException.newInstance("\u751f\u6210\u79d8\u94a5\u5931\u8d25\u3002", ex);
        }
    }

    public SecretKey generateKey() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(AES);
            keyGenerator.init(128);
            SecretKey key = keyGenerator.generateKey();
            return key;
        }
        catch (Exception ex) {
            throw AbcCryptoException.newInstance("\u751f\u6210\u79d8\u94a5\u5931\u8d25\u3002", ex);
        }
    }

    public static void main(String[] args) {
        SecretKey secretKey1 = AESKit.getInstance().generateKey("123456");
        SecretKey secretKey2 = AESKit.getInstance().generateKey("123456");
        System.out.println(secretKey1.equals(secretKey2));
        SecretKey secretKey3 = AESKit.getInstance().generateKey();
        SecretKey secretKey4 = AESKit.getInstance().generateKey();
        System.out.println(secretKey3.equals(secretKey4));
        String data = "\u620d\u9f13\u65ad\u4eba\u884c\uff0c\u8fb9\u79cb\u4e00\u96c1\u58f0\u3002\u9732\u4ece\u4eca\u591c\u767d\uff0c\u6708\u662f\u6545\u4e61\u660e\u3002\u6709\u5f1f\u7686\u5206\u6563\uff0c\u65e0\u5bb6\u95ee\u6b7b\u751f\u3002\u5bc4\u4e66\u957f\u4e0d\u8fbe\uff0c\u51b5\u4e43\u672a\u4f11\u5175\u3002";
        SecretKey secretKey = AESKit.getInstance().generateKey();
        byte[] keyBytes = secretKey.getEncoded();
        System.out.println("\u751f\u6210\u79d8\u94a5\uff1a" + Base64Kit.standardMode().encode(keyBytes));
        byte[] encrypted = AESKit.getInstance().encrypt(data.getBytes(), keyBytes);
        System.out.println("\u52a0\u5bc6\u6570\u636e\uff1a" + Base64Kit.standardMode().encode(encrypted));
        byte[] decrypted = AESKit.getInstance().decrypt(encrypted, keyBytes);
        System.out.println("\u89e3\u5bc6\u6570\u636e\uff1a" + new String(decrypted));
    }
}

