/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.sensitive.util;

import com.ygsoft.abc.service.sensitive.enums.SensitiveDefaultLengthEnum;
import com.ygsoft.abc.service.tool.PropertyConfigUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import org.apache.commons.lang.StringUtils;

public class SensitiveInfoUtils {
    public static boolean isSensitiveCover() {
        String value = PropertyConfigUtil.getProperty("abc.sensitive.cover");
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            return true;
        }
        return "true".equals(value);
    }

    public static String chineseName(String fullName, int showLength) {
        if (StringUtils.isBlank((String)fullName)) {
            return "";
        }
        if (StringUtils.length((String)fullName) <= showLength) {
            return fullName;
        }
        String name = StringUtils.left((String)fullName, (int)showLength);
        return StringUtils.rightPad((String)name, (int)StringUtils.length((String)fullName), (String)"*");
    }

    public static String coverSensitive(String source, int length) {
        if (StringUtils.isBlank((String)source)) {
            return "";
        }
        return SensitiveInfoUtils.getSensitiveInfo(length);
    }

    public static String idCardNum(String idCard, int begin, int end) {
        if (StringUtils.isBlank((String)idCard)) {
            return "";
        }
        return StringUtils.left((String)idCard, (int)begin).concat(StringUtils.removeStart((String)StringUtils.leftPad((String)StringUtils.right((String)idCard, (int)end), (int)StringUtils.length((String)idCard), (String)"*"), (String)"******"));
    }

    public static String fixedPhone(String num, int end) {
        if (StringUtils.isBlank((String)num)) {
            return "";
        }
        return StringUtils.leftPad((String)StringUtils.right((String)num, (int)end), (int)StringUtils.length((String)num), (String)"*");
    }

    public static String mobilePhone(String mobile, int begin, int end) {
        if (StringUtils.isBlank((String)mobile)) {
            return "";
        }
        return StringUtils.left((String)mobile, (int)begin).concat(StringUtils.leftPad((String)StringUtils.right((String)mobile, (int)end), (int)(StringUtils.length((String)mobile) - begin), (String)"*"));
    }

    public static String address(String address, int sensitiveBeginSize) {
        if (StringUtils.isBlank((String)address)) {
            return "";
        }
        int length = StringUtils.length((String)address);
        return StringUtils.rightPad((String)StringUtils.left((String)address, (int)(length - sensitiveBeginSize)), (int)length, (String)"*");
    }

    public static String email(String email, int begin) {
        if (StringUtils.isBlank((String)email)) {
            return "";
        }
        int index = StringUtils.indexOf((String)email, (String)"@");
        if (index <= begin) {
            return email;
        }
        return StringUtils.rightPad((String)StringUtils.left((String)email, (int)begin), (int)index, (String)"*").concat(StringUtils.mid((String)email, (int)index, (int)StringUtils.length((String)email)));
    }

    public static String bankCard(String cardNum, int begin, int end) {
        if (StringUtils.isBlank((String)cardNum)) {
            return "";
        }
        if (SensitiveInfoUtils.getSensitive(cardNum, begin, end)) {
            begin = SensitiveDefaultLengthEnum.BANKCARD.getBegin();
            end = SensitiveDefaultLengthEnum.BANKCARD.getEnd();
        }
        return StringUtils.left((String)cardNum, (int)begin).concat(StringUtils.removeStart((String)StringUtils.leftPad((String)StringUtils.right((String)cardNum, (int)end), (int)StringUtils.length((String)cardNum), (String)"*"), (String)"******"));
    }

    public static String patternReplace(String context, String pattern, String replaceChar) {
        return context.replaceAll(pattern, replaceChar);
    }

    private static int getAllLength(int begin, int end) {
        return begin + end;
    }

    private static boolean getSensitive(String address, int sensitiveBeginSize, int sensitiveEndSize) {
        int length;
        int showLength = SensitiveInfoUtils.getAllLength(sensitiveBeginSize, sensitiveEndSize);
        return showLength <= (length = StringUtils.length((String)address));
    }

    private static String getSensitiveInfo(int length) {
        StringBuilder senBuffer = new StringBuilder();
        senBuffer.append("*");
        while (StringUtils.length((String)senBuffer.toString()) < length) {
            senBuffer.append("*");
        }
        return senBuffer.toString();
    }
}

