/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.sensitive.util;

import com.ygsoft.abc.service.security.sm4.SM4CBCUtil;
import com.ygsoft.abc.service.tool.PropertyConfigUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import com.ygsoft.jt.umc.security.crypto.CommonCryptoUtil;
import com.ygsoft.jt.umc.security.crypto.cons.AgloEnum;
import java.util.HashMap;
import java.util.Map;

public final class TransferEncryptUtils {
    static final Map<String, CommonCryptoUtil> cachedCommonCryptoUtilMap = new HashMap<String, CommonCryptoUtil>();
    private static final String SM4_START = "{SM4}";
    private static final String SM4CBC_START = "{SM4CBC}";

    private TransferEncryptUtils() {
    }

    public static boolean isTransferEncrypt() {
        String value = PropertyConfigUtil.getProperty("abc.transfer.encrypt");
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            return true;
        }
        return "true".equals(value);
    }

    public static String sm4cbcEncrypt(String data) {
        if (StringUtil.isNullOrTrimEmptyString((String)data)) {
            return data;
        }
        if (!cachedCommonCryptoUtilMap.containsKey("SM4CBC")) {
            cachedCommonCryptoUtilMap.put("SM4CBC", new CommonCryptoUtil("SM4CBC"));
        }
        CommonCryptoUtil sm4CBCCommonCryptoUtil = cachedCommonCryptoUtilMap.get("SM4CBC");
        return sm4CBCCommonCryptoUtil.encrypt(data);
    }

    public static String sm4cbcDecrypt(String data) {
        if (StringUtil.isNullOrTrimEmptyString((String)data)) {
            return data;
        }
        if (TransferEncryptUtils.checkIsOldSM4CBCEncrypt(data).booleanValue()) {
            return SM4CBCUtil.getInstance().decodeWithHeader(data);
        }
        if (!cachedCommonCryptoUtilMap.containsKey("SM4CBC")) {
            cachedCommonCryptoUtilMap.put("SM4CBC", new CommonCryptoUtil("SM4CBC"));
        }
        CommonCryptoUtil sm4CBCCommonCryptoUtil = cachedCommonCryptoUtilMap.get("SM4CBC");
        return sm4CBCCommonCryptoUtil.decrypt(data);
    }

    public static Boolean checkIsSm4cbcEncrypt(String data) {
        if (StringUtil.isNullOrTrimEmptyString((String)data)) {
            return false;
        }
        return data.startsWith(AgloEnum.SM4CBC.getEnumId()) || TransferEncryptUtils.checkIsOldSM4CBCEncrypt(data) != false;
    }

    public static String sm4Encrypt(String data) {
        if (StringUtil.isNullOrTrimEmptyString((String)data)) {
            return data;
        }
        if (!cachedCommonCryptoUtilMap.containsKey("SM4")) {
            cachedCommonCryptoUtilMap.put("SM4", new CommonCryptoUtil("SM4"));
        }
        CommonCryptoUtil sm4CommonCryptoUtil = cachedCommonCryptoUtilMap.get("SM4");
        return sm4CommonCryptoUtil.encrypt(data);
    }

    public static String sm4Decrypt(String data) {
        if (StringUtil.isNullOrTrimEmptyString((String)data)) {
            return data;
        }
        if (TransferEncryptUtils.checkIsOldSM4Encrypt(data).booleanValue()) {
            return SM4CBCUtil.getInstance().decodeWithHeader(data);
        }
        if (!cachedCommonCryptoUtilMap.containsKey("SM4")) {
            cachedCommonCryptoUtilMap.put("SM4", new CommonCryptoUtil("SM4"));
        }
        CommonCryptoUtil sm4CommonCryptoUtil = cachedCommonCryptoUtilMap.get("SM4");
        return sm4CommonCryptoUtil.decrypt(data);
    }

    public static Boolean checkIsSm4Encrypt(String data) {
        if (StringUtil.isNullOrTrimEmptyString((String)data)) {
            return false;
        }
        return data.startsWith(AgloEnum.SM4.getEnumId()) || TransferEncryptUtils.checkIsOldSM4Encrypt(data) != false;
    }

    private static Boolean checkIsOldSM4Encrypt(String data) {
        if (StringUtil.isNullOrTrimEmptyString((String)data)) {
            return false;
        }
        return data.startsWith(SM4_START);
    }

    private static Boolean checkIsOldSM4CBCEncrypt(String data) {
        if (StringUtil.isNullOrTrimEmptyString((String)data)) {
            return false;
        }
        return data.startsWith(SM4CBC_START);
    }

    public static void main(String[] args) {
        String sm4cbcStr = TransferEncryptUtils.sm4cbcEncrypt("123456");
        System.out.println(sm4cbcStr);
        System.out.println(TransferEncryptUtils.checkIsSm4cbcEncrypt(sm4cbcStr));
        System.out.println(TransferEncryptUtils.sm4cbcDecrypt(sm4cbcStr));
        String sm4Str = TransferEncryptUtils.sm4Encrypt("123456");
        System.out.println(sm4Str);
        System.out.println(TransferEncryptUtils.checkIsSm4Encrypt(sm4Str));
        System.out.println(TransferEncryptUtils.sm4Decrypt(sm4Str));
        String encode = "JT0006DAA80B698C1C8C7541413F6FC588C82DEABDF4D8CCA29DAD184C3AB06FAE215D";
        String sm4Decode = TransferEncryptUtils.sm4Decrypt("JT0006DAA80B698C1C8C7541413F6FC588C82DEABDF4D8CCA29DAD184C3AB06FAE215D");
        System.out.println("\u89e3\u5bc6\u524d\uff1aJT0006DAA80B698C1C8C7541413F6FC588C82DEABDF4D8CCA29DAD184C3AB06FAE215D");
        System.out.println("\u89e3\u5bc6\u540e\uff1a" + sm4Decode);
    }
}

