/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.seqno;

import com.google.common.base.Joiner;
import com.ygsoft.abc.service.domain.bo.CodeFieldCondition;
import com.ygsoft.abc.service.exception.AbcServiceException;
import com.ygsoft.abc.service.seqno.AbstractCodeBuilder;
import com.ygsoft.abc.service.tool.BlockCollectionUtil;
import com.ygsoft.abc.service.tool.BlockSqlUtil;
import com.ygsoft.abc.service.tool.CastUtil;
import com.ygsoft.abc.service.tool.MonitorUtil;
import com.ygsoft.ecp.service.dataaccess.ISQLTemplate;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.OSGiUtil;
import com.ygsoft.ecp.service.tool.RedisUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public abstract class AbstractConditionCodeBuilder
extends AbstractCodeBuilder {
    private static final IEcpLog LOG = EcpLogFactory.getLog(AbstractConditionCodeBuilder.class);
    private static final int MAX_FIELD_CONDITION = 3;
    private List<String> conditionFields;
    protected List<CodeFieldCondition> fieldConditions;

    protected AbstractConditionCodeBuilder(String newTable, String newField, String newPrefix, String newPadding, int newExpireTime, List<String> newConditionFields) {
        super(newTable, newField, newPrefix, newPadding, newExpireTime);
        this.conditionFields = newConditionFields;
    }

    private boolean isSameSize(List<String> fieldNames, List<String> fieldValues) {
        int valueSize;
        int fieldSize = BlockCollectionUtil.getSize(fieldNames);
        return fieldSize == (valueSize = BlockCollectionUtil.getSize(fieldValues));
    }

    private List<CodeFieldCondition> buildConditions(List<String> fieldValues) {
        if (!this.isSameSize(this.conditionFields, fieldValues)) {
            String msg = "\u5b57\u6bb5\u540d\u79f0\u4e0e\u503c\u7684\u4e2a\u6570\u4e0d\u76f8\u7b49\u3002";
            throw new AbcServiceException("ABC.0015", "\u5b57\u6bb5\u540d\u79f0\u4e0e\u503c\u7684\u4e2a\u6570\u4e0d\u76f8\u7b49\u3002");
        }
        ArrayList<CodeFieldCondition> list = new ArrayList<CodeFieldCondition>();
        if (BlockCollectionUtil.isNotEmpty(fieldValues)) {
            for (int i = 0; i < fieldValues.size(); ++i) {
                list.add(CodeFieldCondition.newInstance(this.conditionFields.get(i), fieldValues.get(i)));
            }
        }
        return list;
    }

    private List<String> arrayToList(String ... conditionFieldValues) {
        if (null == conditionFieldValues) {
            return null;
        }
        return Arrays.asList(conditionFieldValues);
    }

    protected String getNext(String ... conditionFieldValues) {
        MonitorUtil monitorUtil = MonitorUtil.getInstance(LOG);
        long start = monitorUtil.getStartTime();
        this.fieldConditions = this.buildConditions(this.arrayToList(conditionFieldValues));
        if (this.fieldConditions.size() > 3) {
            String msg = "\u6700\u5927\u652f\u63013\u4e2a\u6761\u4ef6\u5b57\u6bb5\u3002";
            throw new AbcServiceException("ABC.0015", "\u6700\u5927\u652f\u63013\u4e2a\u6761\u4ef6\u5b57\u6bb5\u3002");
        }
        String codePrefix = this.getCodePrefix();
        String key = this.buildCodeKey();
        String nextCode = null;
        if (!RedisUtil.getRedisService().exists("abc", key).booleanValue()) {
            this.initSeqno(key, codePrefix);
        }
        nextCode = this.buildBySeqno(codePrefix, RedisUtil.getRedisService().incr("abc", key));
        monitorUtil.monitor("\u83b7\u53d6\u7f16\u7801\u8017\u65f6", start);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)(">>>\u7f16\u7801:code=" + nextCode));
        }
        return nextCode;
    }

    @Override
    protected long findMaxSeqno(String codePrefix) {
        List list;
        ISQLTemplate sqlTemplate = (ISQLTemplate)OSGiUtil.getSpringBean(ISQLTemplate.class);
        String sql = "SELECT MAX(" + this.field + ") CODE FROM " + this.table + " WHERE " + this.field + " LIKE '" + codePrefix + "%'" + this.buildSqlCondition();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("\n>>>\u83b7\u53d6\u6700\u5927\u7f16\u7801Sql=" + sql));
        }
        if (BlockCollectionUtil.isEmpty(list = sqlTemplate.findBySQLWithoutRowNumLimit(sql, Map.class))) {
            return 0L;
        }
        Map entity = (Map)list.get(0);
        if (null == entity) {
            return 0L;
        }
        String code = CastUtil.getString(entity.get("code"));
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("\n>>>\u4ece\u6570\u636e\u5e93\u83b7\u53d6\u6700\u5927\u7f16\u7801code=" + code));
        }
        long seqno = CastUtil.getLong(code.substring(codePrefix.length()));
        return seqno;
    }

    protected String buildSqlCondition() {
        if (BlockCollectionUtil.isEmpty(this.fieldConditions)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (CodeFieldCondition condition : this.fieldConditions) {
            sb.append(" AND " + condition.getFieldName() + "='" + BlockSqlUtil.escapeSql(condition.getValue()) + "'");
        }
        return sb.toString();
    }

    protected String buildCodeKey() {
        String suffixKey = this.table + "#" + this.field + "#" + this.getCodePrefix() + "#" + this.joinFields();
        String key = "abc:seqno:" + suffixKey;
        return key;
    }

    private String joinFields() {
        if (BlockCollectionUtil.isEmpty(this.conditionFields)) {
            return "";
        }
        return Joiner.on((String)"@").join(this.fieldConditions);
    }
}

