/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.seqno;

import com.ygsoft.abc.service.tool.BlockCollectionUtil;
import com.ygsoft.abc.service.tool.CastUtil;
import com.ygsoft.abc.service.tool.MonitorUtil;
import com.ygsoft.abc.service.tool.RedisLockUtil;
import com.ygsoft.ecp.service.dataaccess.ISQLTemplate;
import com.ygsoft.ecp.service.exception.EcpCheckException;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.DateUtil;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.OSGiUtil;
import com.ygsoft.ecp.service.tool.RedisUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Deprecated
public abstract class AbstractSequenceNo {
    private static final IEcpLog LOG = EcpLogFactory.getLog(AbstractSequenceNo.class);
    public static final String REDIS_SEQ_PREFIX = "abc:seqno:";
    public static final String MAXCODE_POSTFIX = "_maxcode";
    public static final String PRETOKEN_PREFIX = "pretoken";
    public static final String EBCPAYABLE_PREFIX = "ebcpayable";
    public static final String RECEIVABLE_PREFIX = "receivable";
    public static final String TOKEN_PREFIX = "token";
    private static final Set<String> ymdayPrefix = new HashSet<String>();
    private static final int SEQ_SIZE = 200;
    private static final int SEQ_LIMIT = 20;
    public static final String YEAR_MONTH_DAY = "yyyyMMdd";
    public static final String PADDING_SIX = "000000";
    public static final String PADDING_SEVEN = "0000000";
    public static final String PADDING_EIGHT = "00000000";
    public static final String PADDING_NINE = "000000000";
    public static final int EXPIRE_NONE = -1;
    public static final int EXPIRE_ONE_DAY = 86401;
    public static final long INIT_ACQUIRETIMEOUT = 10000L;
    public static final long INRC_ACQUIRETIMEOUT = 3L;
    public static final long LOCKED_TIMEOUT = 10000L;
    public static final int POP_TIMEOUT = 1;
    protected String table;
    protected String field;
    protected String prefix;
    protected String padding;
    protected int expireTime;

    protected AbstractSequenceNo(String table, String field, String prefix, String padding, int expireTime) {
        if (StringUtil.isNullOrTrimEmptyString((String)prefix)) {
            throw new EcpCheckException("ABC.0001", EcpI18nUtil.localizedString((String)"AbstractSequenceNo_AbstractSequenceNo_172", (String)"\u53c2\u6570\u9519\u8bef\uff1aprefix\u4e3a\u7a7a\u3002"));
        }
        if (StringUtil.isNullOrTrimEmptyString((String)padding)) {
            throw new EcpCheckException("ABC.0001", EcpI18nUtil.localizedString((String)"AbstractSequenceNo_AbstractSequenceNo_175", (String)"\u53c2\u6570\u9519\u8bef\uff1apadding\u4e3a\u7a7a\u3002"));
        }
        if (StringUtil.isNullOrTrimEmptyString((String)table)) {
            throw new EcpCheckException("ABC.0001", EcpI18nUtil.localizedString((String)"AbstractSequenceNo_AbstractSequenceNo_178", (String)"\u53c2\u6570\u9519\u8bef\uff1atable\u4e3a\u7a7a\u3002"));
        }
        if (StringUtil.isNullOrTrimEmptyString((String)field)) {
            throw new EcpCheckException("ABC.0001", EcpI18nUtil.localizedString((String)"AbstractSequenceNo_AbstractSequenceNo_181", (String)"\u53c2\u6570\u9519\u8bef\uff1afield\u4e3a\u7a7a\u3002"));
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)(">>>\u53c2\u6570:prefix=" + prefix + ",padding=" + padding + ",table=" + table + ",field=" + field + ",expireTime=" + expireTime));
        }
        this.table = table;
        this.field = field;
        this.prefix = prefix;
        this.padding = padding;
        this.expireTime = expireTime;
    }

    public static String getYearMonthDay() {
        Date now = DateUtil.getCurrentSystemTime();
        SimpleDateFormat sdf = new SimpleDateFormat(YEAR_MONTH_DAY);
        return sdf.format(now);
    }

    private void produceCode(String prefix, String padding, String table, String field, int expireTime) {
        String key = REDIS_SEQ_PREFIX + prefix;
        RedisLockUtil.executeTryLock(key, 10000L, 10000L, () -> {
            if (!RedisUtil.getRedisService().exists("abc", key).booleanValue()) {
                String maxCodeKey = key + MAXCODE_POSTFIX;
                String maxCode = RedisUtil.getRedisService().get("abc", maxCodeKey);
                long maxSeqno = 0L;
                maxSeqno = StringUtil.isNullOrTrimEmptyString((String)maxCode) ? this.findMaxSeqno() : this.parseSeqno(maxCode, prefix);
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)(">>>:table=" + table + ",field=" + field + ",prefix=" + prefix + ",padding=" + padding + ", maxSeqno=" + maxSeqno));
                }
                List<String> seqnoList = this.buildSequence(maxSeqno + 1L, 200, padding, prefix);
                AbstractSequenceNo.setCache(prefix, seqnoList, expireTime);
            }
        });
    }

    protected String getNext() {
        List list;
        MonitorUtil monitorUtil = MonitorUtil.getInstance(LOG);
        long start = monitorUtil.getStartTime();
        String key = REDIS_SEQ_PREFIX + this.prefix;
        String nextCode = null;
        while (BlockCollectionUtil.isEmpty(list = RedisUtil.getRedisService().brpop("abc", 1, new String[]{key}))) {
            this.produceCode(this.prefix, this.padding, this.table, this.field, this.expireTime);
        }
        nextCode = (String)list.get(1);
        monitorUtil.monitor("\u83b7\u53d6\u7f16\u7801\u8017\u65f6", start);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)(">>>\u7f16\u7801:code=" + nextCode));
        }
        return nextCode;
    }

    private long parseSeqno(String seqCode, String prefix) {
        String str = seqCode.substring(prefix.length());
        return CastUtil.getLong(str);
    }

    protected long findMaxSeqno() {
        String code;
        String sql;
        ISQLTemplate sqlTemplate = (ISQLTemplate)OSGiUtil.getSpringBean(ISQLTemplate.class);
        List list = sqlTemplate.findBySQLWithoutRowNumLimit(sql = "SELECT MAX(" + this.field + ") CODE FROM " + this.table, Map.class);
        if (BlockCollectionUtil.isEmpty(list)) {
            return 0L;
        }
        Map entity = (Map)list.get(0);
        if (null == entity) {
            return 0L;
        }
        String codePrefix = this.prefix;
        if (this.isYearMonthDayPrefix(this.prefix)) {
            codePrefix = this.parseYearMonthDay(this.prefix);
        }
        if ((code = CastUtil.getString(entity.get("code"))).startsWith(codePrefix)) {
            long seqno = CastUtil.getLong(code.substring(codePrefix.length()));
            return seqno;
        }
        return 0L;
    }

    private List<String> buildSequence(long beginSeq, int size, String padding, String prefix) {
        long endSeq = beginSeq + (long)size;
        ArrayList<Long> seqList = new ArrayList<Long>();
        for (long i = beginSeq; i <= endSeq; ++i) {
            seqList.add(i);
        }
        String codePrefix = prefix;
        if (this.isYearMonthDayPrefix(prefix)) {
            codePrefix = this.parseYearMonthDay(prefix);
        }
        ArrayList<String> seqnoList = new ArrayList<String>(seqList.size());
        for (Long element : seqList) {
            String str = CastUtil.getString(element);
            int length = str.length();
            String code = codePrefix + padding.substring(length) + str;
            seqnoList.add(code);
        }
        return seqnoList;
    }

    private boolean isYearMonthDayPrefix(String prefix) {
        for (String str : ymdayPrefix) {
            if (!prefix.startsWith(str)) continue;
            return true;
        }
        return false;
    }

    private String parseYearMonthDay(String prefix) {
        return prefix.substring(prefix.length() - 8);
    }

    private long getSize(String key) {
        long count = RedisUtil.getRedisService().llen("abc", key);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)(">>>:key=" + key + "\uff0c\u8bb0\u5f55\u6761\u6570:" + count));
        }
        return count;
    }

    private static void setCache(String prefix, List<String> seqnoList, int expireTime) {
        if (StringUtil.isNullOrTrimEmptyString((String)prefix)) {
            throw new EcpCheckException("", EcpI18nUtil.localizedString((String)"AbstractSequenceNo_setCache_431", (String)"\u53c2\u6570\u9519\u8bef\uff1aprefix\u4e3a\u7a7a\u3002"));
        }
        if (BlockCollectionUtil.isEmpty(seqnoList)) {
            return;
        }
        String key = REDIS_SEQ_PREFIX + prefix;
        for (String seqno : seqnoList) {
            RedisUtil.getRedisService().lpush("abc", key, new String[]{seqno});
        }
        String maxCode = seqnoList.get(seqnoList.size() - 1);
        String maxCodeKey = key + MAXCODE_POSTFIX;
        RedisUtil.getRedisService().set("abc", maxCodeKey, maxCode);
        if (expireTime > 0) {
            RedisUtil.getRedisService().expire("abc", key, expireTime);
            RedisUtil.getRedisService().expire("abc", maxCodeKey, expireTime);
        }
    }

    static {
        ymdayPrefix.add(PRETOKEN_PREFIX);
        ymdayPrefix.add(PRETOKEN_PREFIX);
        ymdayPrefix.add(EBCPAYABLE_PREFIX);
        ymdayPrefix.add(RECEIVABLE_PREFIX);
    }
}

