/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.seqno;

import com.ygsoft.abc.service.exception.InvalidNumberRangeException;
import com.ygsoft.abc.service.tool.CastUtil;
import com.ygsoft.abc.service.tool.MonitorUtil;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.RedisUtil;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

public final class SequentialGidBuilder {
    private static final IEcpLog LOG = EcpLogFactory.getLog(SequentialGidBuilder.class);
    private static final String GID_SEQUENCE_KEY = "abc:gid:seq";
    private static final String GID_PREFIX_KEY = "abc:gid:val:";
    private static final String CHECK_VAL = "1";
    private static final Long SET_STATE_SUCCESS = 1L;
    private static long MAX_SEQUENCE_NO = 9999L;
    private static int EXPIRE_SECONDS = 3;
    private static String SPLIT_CHAR = "-";
    private static int MAX_BATCH_SIZE = 10000;

    private SequentialGidBuilder() {
    }

    public static List<String> getBatchGids(int size) {
        if (size <= 1 || MAX_BATCH_SIZE < size) {
            String msg = EcpI18nUtil.localizedString((String)"SequentialGidBuilder_getBatchGids_137", (String)"\u53c2\u6570size\u5fc5\u987b\u5927\u4e8e1\u5c0f\u4e8e10000\u3002");
            throw new InvalidNumberRangeException("ABC.0007", msg);
        }
        String nextGid = SequentialGidBuilder.getGid();
        return SequentialGidBuilder.buildGids(nextGid, size);
    }

    private static List<String> buildGids(String nextGid, int size) {
        GidSubunit gidSubunit = SequentialGidBuilder.parseGid(nextGid);
        ArrayList<String> gids = new ArrayList<String>(size);
        long currentTime = gidSubunit.getCurrentTime();
        for (int i = 0; i < size; ++i) {
            gids.add(SequentialGidBuilder.buildGid(currentTime++, gidSubunit.getSeqNo()));
        }
        return gids;
    }

    private static GidSubunit parseGid(String gid) {
        String[] arr = gid.split(SPLIT_CHAR);
        GidSubunit gidSubunit = new GidSubunit(CastUtil.getLong(arr[0]), CastUtil.getInteger(arr[1]), CastUtil.getInteger(arr[2]));
        return gidSubunit;
    }

    public static String getGid() {
        Long result;
        MonitorUtil monitorUtil = MonitorUtil.getInstance(LOG);
        long start = monitorUtil.getStartTime();
        String nextGid = null;
        int tryCount = 0;
        do {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("\n>>>time:" + start + "\uff0c\u5c1d\u8bd5\u6b21\u6570\uff1a" + ++tryCount));
            }
            long seqno = RedisUtil.getRedisService().incr("abc", GID_SEQUENCE_KEY);
            nextGid = SequentialGidBuilder.buildGid(start, seqno);
            if (seqno >= MAX_SEQUENCE_NO) {
                RedisUtil.getRedisService().incr("abc", GID_SEQUENCE_KEY);
            }
            String gidKey = GID_PREFIX_KEY + nextGid;
            result = RedisUtil.getRedisService().setnx("abc", gidKey, CHECK_VAL);
            RedisUtil.getRedisService().expire("abc", gidKey, EXPIRE_SECONDS);
        } while (SET_STATE_SUCCESS != result);
        monitorUtil.monitor("\n>>>\u83b7\u53d6Gid\u8017\u65f6", start);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)(">>>\u4e3b\u952e:gid=" + nextGid));
        }
        return nextGid;
    }

    private static String buildGid(long currentTime, long seqno) {
        int random = (int)(Math.random() * 10000.0) + 10000;
        long sequence = seqno + 10000L;
        return currentTime + SPLIT_CHAR + sequence + SPLIT_CHAR + random;
    }

    public static void main(String[] args) {
        for (int i = 0; i < 10000; ++i) {
            System.out.println(Instant.now().getNano());
        }
        long start = 1545033621442L;
        long end = 9999999999999L;
        long val = (end - start) / 1557628928L;
        System.out.println("val=" + val);
        start = System.currentTimeMillis();
        for (int i = 0; i < 10000000; ++i) {
            SequentialGidBuilder.buildGid(1L, 2L);
        }
        end = System.currentTimeMillis();
        System.out.println("buildGid:" + (end - start));
    }

    static class GidSubunit {
        private final long currentTime;
        private final int seqNo;
        private final int randomNo;

        public GidSubunit(long currentTime, int seqNo, int randomNo) {
            this.currentTime = currentTime;
            this.seqNo = seqNo;
            this.randomNo = randomNo;
        }

        public long getCurrentTime() {
            return this.currentTime;
        }

        public int getSeqNo() {
            return this.seqNo;
        }

        public int getRandomNo() {
            return this.randomNo;
        }
    }
}

