/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.ygsoft.abc.service.attachment.context.IIndependAttachmentService;
import com.ygsoft.abc.service.domain.vo.FileNameVO;
import com.ygsoft.abc.service.exception.AbcIOException;
import com.ygsoft.abc.service.exception.AbcServiceException;
import com.ygsoft.abc.service.exception.EmptyValueException;
import com.ygsoft.abc.service.tool.BlockIOUtil;
import com.ygsoft.abc.service.tool.CastUtil;
import com.ygsoft.abc.service.tool.PreconditionUtil;
import com.ygsoft.abc.service.tool.PropertyConfigUtil;
import com.ygsoft.ecp.core.framework.context.ILoginContext;
import com.ygsoft.ecp.mapp.common.service.util.LoginContextUtil;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.storage.IUnStructureStorage;
import com.ygsoft.ecp.service.tool.OSGiUtil;
import com.ygsoft.ecp.service.tool.UuidUtil;
import com.ygsoft.ecp.service.unstructure.EntityAttachmentDetailVO;
import com.ygsoft.ecp.service.unstructure.EntityAttachmentSummaryVO;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.hibernate.engine.jdbc.BlobProxy;
import org.springframework.web.multipart.MultipartFile;

public class AttachUtil {
    static final IEcpLog LOG = EcpLogFactory.getLog(AttachUtil.class);
    public static final int FORMAL_STATUS = 1;

    private AttachUtil() {
    }

    public static IUnStructureStorage getUnStructureStorage() {
        return (IUnStructureStorage)OSGiUtil.getService(IUnStructureStorage.class);
    }

    public static void delete(List<String> list) {
        list.forEach(resId -> AttachUtil.delete(resId));
    }

    public static void delete(String resId) {
        PreconditionUtil.checkNotTrimEmpty(resId, "\u9644\u4ef6gid\u4e3a\u7a7a\u3002");
        AttachUtil.getUnStructureStorage().deleteSummaryAndDetailByResId(resId);
    }

    public static void replace(String resId, byte[] data) {
        PreconditionUtil.checkNotTrimEmpty(resId, "\u53c2\u6570\u9519\u8bef\uff1aresId\u4e3a\u7a7a\u3002");
        PreconditionUtil.checkNotNull(data, "\u53c2\u6570\u9519\u8bef\uff1adata\u4e3a\u7a7a\u3002");
        if (PropertyConfigUtil.getStorageType().isDB()) {
            EntityAttachmentSummaryVO attachSummary = AttachUtil.getUnStructureStorage().getSummaryAndDetailByResId(resId);
            Blob blob = BlobProxy.generateProxy((byte[])data);
            attachSummary.getAttachmentDetailVO().setData(blob);
            try {
                attachSummary.getAttachmentDetailVO().setLength(Long.valueOf(blob.length()));
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            AttachUtil.getUnStructureStorage().saveSummaryAndDetail(attachSummary);
        } else {
            EntityAttachmentSummaryVO attachSummary = AttachUtil.getUnStructureStorage().getSummaryByResId(resId);
            String fileName = attachSummary.getTitle() + "." + attachSummary.getBtype();
            EntityAttachmentSummaryVO newSummaryVO = AttachUtil.buildEntityAttachmentSummary(fileName, data, resId);
            AttachUtil.getIndependAttachmentService().saveSummaryAndDetail(newSummaryVO);
        }
    }

    private static IIndependAttachmentService getIndependAttachmentService() {
        return (IIndependAttachmentService)OSGiUtil.getSpringBean(IIndependAttachmentService.class);
    }

    public static String copy(String attachGid) {
        return AttachUtil.copy(attachGid, UuidUtil.newUUID());
    }

    public static String copy(String attachGid, String newResid) {
        EntityAttachmentSummaryVO temp = AttachUtil.getUnStructureStorage().getSummaryAndDetailByResId(attachGid);
        EntityAttachmentSummaryVO newEntity = AttachUtil.copyEntity(newResid, temp);
        AttachUtil.getUnStructureStorage().saveSummaryAndDetail(newEntity);
        return newEntity.getResId();
    }

    public static Map<String, String> copy(List<String> attachGids) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(attachGids.size());
        for (String attachGid : attachGids) {
            String newGid = AttachUtil.copy(attachGid);
            result.put(attachGid, newGid);
        }
        return result;
    }

    public static boolean checkFileSize(long fileSize) {
        return fileSize <= AttachUtil.getMaxSize();
    }

    public static long getMaxSize() {
        String maxConfig = PropertyConfigUtil.getFileMaxSize();
        long maxSize = CastUtil.getLong(maxConfig.substring(0, maxConfig.length() - 1));
        String unit = maxConfig.substring(maxConfig.length() - 1);
        if ("B".equalsIgnoreCase(unit)) {
            return maxSize;
        }
        if ("K".equalsIgnoreCase(unit)) {
            return maxSize * 1024L;
        }
        if ("M".equalsIgnoreCase(unit)) {
            return maxSize * 0x100000L;
        }
        if ("G".equalsIgnoreCase(unit)) {
            return maxSize * 0x40000000L;
        }
        throw new AbcServiceException("ABC.0015", "\u6587\u4ef6\u5927\u5c0f\u5355\u4f4d\u4e0d\u652f\u6301\u3002");
    }

    public static EntityAttachmentSummaryVO toEntityAttachmentSummary(File file, String originalFileName, String key) {
        PreconditionUtil.checkNotNull(file, "file\u4e3a\u7a7a\u3002");
        PreconditionUtil.checkNotTrimEmpty(originalFileName, "originalFileName\u4e3a\u7a7a\u3002");
        PreconditionUtil.checkNotTrimEmpty(key, "\u8d44\u6e90id\u4e3a\u7a7a\u3002");
        FileNameVO fileNameVO = FileNameVO.newInstance(originalFileName);
        Blob blobData = AttachUtil.genBlobFrom(file);
        return AttachUtil.buildEntity(key, blobData, fileNameVO);
    }

    public static EntityAttachmentSummaryVO toEntityAttachmentSummary(byte[] data, String fileName, String key) {
        PreconditionUtil.checkNotNull(data, "data\u4e3a\u7a7a\u3002");
        PreconditionUtil.checkNotTrimEmpty(fileName, "fileName\u4e3a\u7a7a\u3002");
        PreconditionUtil.checkNotTrimEmpty(key, "\u8d44\u6e90id\u4e3a\u7a7a\u3002");
        FileNameVO fileNameVO = FileNameVO.newInstance(fileName);
        Blob blobData = AttachUtil.genBlobFrom(data);
        return AttachUtil.buildEntity(key, blobData, fileNameVO);
    }

    public static EntityAttachmentSummaryVO toEntityAttachmentSummary(byte[] data, String fileName, String key, String ywKey) {
        PreconditionUtil.checkNotNull(data, "data\u4e3a\u7a7a\u3002");
        PreconditionUtil.checkNotTrimEmpty(fileName, "fileName\u4e3a\u7a7a\u3002");
        PreconditionUtil.checkNotTrimEmpty(key, "\u8d44\u6e90id\u4e3a\u7a7a\u3002");
        PreconditionUtil.checkNotTrimEmpty(ywKey, "ywKey\u4e3a\u7a7a\u3002");
        FileNameVO fileNameVO = FileNameVO.newInstance(fileName);
        Blob blobData = AttachUtil.genBlobFrom(data);
        return AttachUtil.buildEntity(key, ywKey, blobData, fileNameVO);
    }

    public static EntityAttachmentSummaryVO toEntityAttachmentSummary(byte[] data, String fileName, String key, long userId) {
        PreconditionUtil.checkNotNull(data, "data\u4e3a\u7a7a\u3002");
        PreconditionUtil.checkNotTrimEmpty(fileName, "fileName\u4e3a\u7a7a\u3002");
        PreconditionUtil.checkNotTrimEmpty(key, "\u8d44\u6e90id\u4e3a\u7a7a\u3002");
        FileNameVO fileNameVO = FileNameVO.newInstance(fileName);
        Blob blobData = AttachUtil.genBlobFrom(data);
        return AttachUtil.buildEntity(key, userId, blobData, fileNameVO);
    }

    public static Blob genBlobFrom(byte[] data) {
        Blob blob = BlobProxy.generateProxy((byte[])data);
        return blob;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Blob genBlobFrom(File file) {
        try (FileInputStream input = new FileInputStream(file);){
            byte[] data = BlockIOUtil.toByteArray(input);
            Blob blob = BlobProxy.generateProxy((byte[])data);
            return blob;
        }
        catch (IOException e) {
            throw AbcIOException.newInstance(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Blob genBlobFrom(MultipartFile file) {
        try (InputStream input = file.getInputStream();){
            byte[] data = BlockIOUtil.toByteArray(input);
            Blob blob = BlobProxy.generateProxy((byte[])data);
            return blob;
        }
        catch (IOException e) {
            throw AbcIOException.newInstance(e);
        }
    }

    public static EntityAttachmentSummaryVO toEntityAttachmentSummary(MultipartFile file, String key) {
        PreconditionUtil.checkNotNull(file, "\u4e0a\u4f20\u9644\u4ef6\u4e3a\u7a7a\u3002");
        PreconditionUtil.checkNotTrimEmpty(key, "\u8d44\u6e90id\u4e3a\u7a7a\u3002");
        FileNameVO fileNameVO = FileNameVO.newInstance(file);
        Blob blobData = AttachUtil.genBlobFrom(file);
        return AttachUtil.buildEntity(key, blobData, fileNameVO);
    }

    public static EntityAttachmentSummaryVO toEntityAttachmentSummary(MultipartFile file, String key, long userId) {
        PreconditionUtil.checkNotNull(file, "\u4e0a\u4f20\u9644\u4ef6\u4e3a\u7a7a\u3002");
        PreconditionUtil.checkNotTrimEmpty(key, "\u8d44\u6e90id\u4e3a\u7a7a\u3002");
        FileNameVO fileNameVO = FileNameVO.newInstance(file);
        Blob blobData = AttachUtil.genBlobFrom(file);
        return AttachUtil.buildEntity(key, userId, blobData, fileNameVO);
    }

    private static EntityAttachmentSummaryVO copyEntity(String newResId, EntityAttachmentSummaryVO entity) {
        ILoginContext loginContext = LoginContextUtil.getLoginContext();
        long userId = -1L;
        if (!Objects.isNull(loginContext)) {
            userId = CastUtil.getLong(loginContext.getUserId());
        }
        try {
            EntityAttachmentDetailVO attachmentDetail = new EntityAttachmentDetailVO();
            byte[] copyFilte = AttachUtil.getBytes(entity);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("copy\u9644\u4ef6\u5927\u5c0f\uff1a" + copyFilte.length));
            }
            attachmentDetail.setData(AttachUtil.genBlobFrom(copyFilte));
            attachmentDetail.setId(newResId);
            attachmentDetail.setLength(entity.getAttachmentDetailVO().getLength());
            EntityAttachmentSummaryVO attachmentSummary = new EntityAttachmentSummaryVO();
            attachmentSummary.setResId(newResId);
            attachmentSummary.setYwkey(newResId);
            attachmentSummary.setUserid(Long.valueOf(userId));
            attachmentSummary.setStatus(Integer.valueOf(1));
            attachmentSummary.setTitle(entity.getTitle());
            attachmentSummary.setBsize(entity.getBsize());
            attachmentSummary.setBtype(entity.getBtype());
            attachmentSummary.setAttachmentDetailVO(attachmentDetail);
            return attachmentSummary;
        }
        catch (Exception e) {
            throw new AbcServiceException("ABC.0015", e);
        }
    }

    private static EntityAttachmentSummaryVO buildEntity(String resId, Blob blobData, FileNameVO fileNameVO) {
        ILoginContext loginContext = LoginContextUtil.getLoginContext();
        long userId = -1L;
        if (!Objects.isNull(loginContext)) {
            userId = CastUtil.getLong(loginContext.getUserId());
        }
        return AttachUtil.buildEntity(resId, userId, blobData, fileNameVO);
    }

    private static EntityAttachmentSummaryVO buildEntity(String resId, String ywKey, Blob blobData, FileNameVO fileNameVO) {
        ILoginContext loginContext = LoginContextUtil.getLoginContext();
        long userId = -1L;
        if (!Objects.isNull(loginContext)) {
            userId = CastUtil.getLong(loginContext.getUserId());
        }
        return AttachUtil.buildEntity(resId, ywKey, userId, blobData, fileNameVO);
    }

    private static EntityAttachmentSummaryVO buildEntity(String resId, long userId, Blob blobData, FileNameVO fileNameVO) {
        try {
            EntityAttachmentDetailVO attachmentDetail = new EntityAttachmentDetailVO();
            attachmentDetail.setData(blobData);
            attachmentDetail.setId(resId);
            attachmentDetail.setLength(Long.valueOf(blobData.length()));
            EntityAttachmentSummaryVO attachmentSummary = new EntityAttachmentSummaryVO();
            attachmentSummary.setResId(resId);
            attachmentSummary.setYwkey(resId);
            attachmentSummary.setUserid(Long.valueOf(userId));
            attachmentSummary.setStatus(Integer.valueOf(1));
            attachmentSummary.setTitle(fileNameVO.getDes());
            attachmentSummary.setBsize(Long.valueOf(blobData.length()));
            attachmentSummary.setBtype(fileNameVO.getExt());
            attachmentSummary.setAttachmentDetailVO(attachmentDetail);
            return attachmentSummary;
        }
        catch (Exception e) {
            throw new AbcServiceException("ABC.0015", e);
        }
    }

    private static EntityAttachmentSummaryVO buildEntity(String resId, String ywkey, long userId, Blob blobData, FileNameVO fileNameVO) {
        try {
            EntityAttachmentDetailVO attachmentDetail = new EntityAttachmentDetailVO();
            attachmentDetail.setData(blobData);
            attachmentDetail.setId(resId);
            attachmentDetail.setLength(Long.valueOf(blobData.length()));
            EntityAttachmentSummaryVO attachmentSummary = new EntityAttachmentSummaryVO();
            attachmentSummary.setResId(resId);
            if (null == ywkey || ywkey.trim().length() == 0) {
                attachmentSummary.setYwkey(resId);
            } else {
                attachmentSummary.setYwkey(ywkey);
            }
            attachmentSummary.setUserid(Long.valueOf(userId));
            attachmentSummary.setStatus(Integer.valueOf(1));
            attachmentSummary.setTitle(fileNameVO.getDes());
            attachmentSummary.setBsize(Long.valueOf(blobData.length()));
            attachmentSummary.setBtype(fileNameVO.getExt());
            attachmentSummary.setAttachmentDetailVO(attachmentDetail);
            return attachmentSummary;
        }
        catch (Exception e) {
            throw new AbcServiceException("ABC.0015", e);
        }
    }

    public static EntityAttachmentSummaryVO buildEntityAttachmentSummary(String fileName, byte[] data, String key) {
        PreconditionUtil.checkNotNull(fileName, "\u6587\u4ef6\u540d\u79f0\u4e3a\u7a7a\u3002");
        PreconditionUtil.checkNotTrimEmpty(key, "\u8d44\u6e90id\u4e3a\u7a7a\u3002");
        PreconditionUtil.checkArgument(data != null && data.length > 0, "\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\u3002");
        FileNameVO fileNameVO = FileNameVO.newInstance(fileName);
        Blob blobData = BlobProxy.generateProxy((byte[])data);
        return AttachUtil.buildEntity(key, blobData, fileNameVO);
    }

    public static byte[] getBytes(EntityAttachmentSummaryVO summaryVO) {
        if (null == summaryVO) {
            throw EmptyValueException.newInstance("\u9644\u4ef6\u5bf9\u8c61\u4e3a\u7a7a\u3002");
        }
        EntityAttachmentDetailVO attachmentDetail = summaryVO.getAttachmentDetailVO();
        return AttachUtil.getBytes(attachmentDetail);
    }

    public static InputStream getInputStream(EntityAttachmentSummaryVO summaryVO) {
        EntityAttachmentDetailVO attachmentDetail = summaryVO.getAttachmentDetailVO();
        return AttachUtil.getInputStream(attachmentDetail);
    }

    public static InputStream getInputStream(EntityAttachmentDetailVO attachmentDetail) {
        if (attachmentDetail == null) {
            return null;
        }
        InputStream inputStream = null;
        Blob blob = attachmentDetail.getData();
        if (blob != null) {
            try {
                inputStream = blob.getBinaryStream();
                return inputStream;
            }
            catch (Exception e) {
                throw AbcIOException.newInstance("\u4ece\u9644\u4ef6\u5185\u5bb9\u4e2d\u53d6\u6570\u636e\u6d41\u51fa\u9519\u3002", e);
            }
        }
        try {
            inputStream = new FileInputStream(attachmentDetail.getFile());
            return inputStream;
        }
        catch (Exception e) {
            throw AbcIOException.newInstance("\u4ece\u9644\u4ef6\u5185\u5bb9\u4e2d\u53d6\u6570\u636e\u6d41\u51fa\u9519\u3002", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(EntityAttachmentDetailVO attachmentDetail) {
        InputStream is;
        block11: {
            byte[] byArray;
            if (attachmentDetail == null) {
                return null;
            }
            is = null;
            try {
                Blob blob = attachmentDetail.getData();
                if (blob != null) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)"DB-\u9644\u4ef6\u3002");
                    }
                    try {
                        is = blob.getBinaryStream();
                    }
                    catch (Exception e) {
                        throw AbcIOException.newInstance("\u4ece\u9644\u4ef6\u5185\u5bb9\u4e2d\u53d6\u6570\u636e\u6d41\u51fa\u9519\u3002", e);
                    }
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"FILE-\u9644\u4ef6\u3002");
                }
                try {
                    is = new FileInputStream(attachmentDetail.getFile());
                }
                catch (Exception e) {
                    throw AbcIOException.newInstance("\u4ece\u9644\u4ef6\u5185\u5bb9\u4e2d\u53d6\u6570\u636e\u6d41\u51fa\u9519\u3002", e);
                }
                if (null != is) break block11;
                byArray = null;
            }
            catch (Throwable throwable) {
                BlockIOUtil.close(is);
                throw throwable;
            }
            BlockIOUtil.close(is);
            return byArray;
        }
        byte[] byArray = BlockIOUtil.toByteArray(is);
        BlockIOUtil.close(is);
        return byArray;
    }

    public static String getHeadOfFileType(MultipartFile file) {
        return AttachUtil.getHeadOfFileType(file, 10);
    }

    /*
     * Exception decompiling
     */
    public static String getHeadOfFileType(MultipartFile file, int length) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getHeadOfFileType(byte[] fileData) {
        return AttachUtil.getHeadOfFileType(fileData, 10);
    }

    /*
     * Exception decompiling
     */
    public static String getHeadOfFileType(byte[] fileData, int length) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getBytes(MultipartFile file) {
        try (InputStream input = file.getInputStream();){
            byte[] data;
            byte[] byArray = data = BlockIOUtil.toByteArray(input);
            return byArray;
        }
        catch (IOException e) {
            throw AbcIOException.newInstance(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isImage(byte[] data) {
        BufferedImage img = null;
        try (ByteArrayInputStream in = new ByteArrayInputStream(data);){
            img = ImageIO.read(in);
            if (img == null || ((Image)img).getWidth(null) <= 0 || ((Image)img).getHeight(null) <= 0) {
                boolean bl2 = false;
                return bl2;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }
}

