/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.ygsoft.abc.service.annotation.AuditField;
import com.ygsoft.abc.service.annotation.AuditItemLog;
import com.ygsoft.abc.service.annotation.AuditMethod;
import com.ygsoft.abc.service.annotation.AuditParam;
import com.ygsoft.abc.service.audit.AuditFieldTransfer;
import com.ygsoft.abc.service.audit.AuditParamTransfer;
import com.ygsoft.abc.service.common.domain.vo.AuditDescribeDefinitionVO;
import com.ygsoft.abc.service.common.types.AuditDescribeType;
import com.ygsoft.abc.service.domain.vo.AuditLogVO;
import com.ygsoft.abc.service.tool.BeanCopyUtil;
import com.ygsoft.abc.service.tool.BlockDateTimeUtil;
import com.ygsoft.abc.service.tool.BlockJSONUtil;
import com.ygsoft.abc.service.tool.CommonUtil;
import com.ygsoft.abc.service.tool.MappServiceUtil;
import com.ygsoft.abc.service.tool.ObjectPropertyUtil;
import com.ygsoft.abc.service.tool.PreconditionUtil;
import com.ygsoft.abc.service.tool.PropertyConfigUtil;
import com.ygsoft.alibaba.fastjson.JSONObject;
import com.ygsoft.ecp.core.framework.context.ILoginContext;
import com.ygsoft.ecp.framework.spring.SpringContextHolder;
import com.ygsoft.ecp.framework.token.TokenHolder;
import com.ygsoft.ecp.mapp.common.service.util.LoginContextUtil;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.JSONUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import com.ygsoft.ecp.service.tool.UuidUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.env.Environment;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public final class AuditLogUtil {
    private static final IEcpLog LOG = EcpLogFactory.getLog(AuditLogUtil.class);
    public static final String AUDIT_LOG_URL = "/necp/mapp/4a/auditlog/addAuditLog?ecp_token={0}";
    public static final String ECP_TOKEN_KEY = "ecp_token";

    private AuditLogUtil() {
    }

    public static String getDefaultItemType() {
        String vipAddress = ((Environment)SpringContextHolder.INSTANCE.getApplicationContext().getBean("environment", Environment.class)).getProperty("server.vipaddress");
        if (StringUtils.isEmpty((CharSequence)vipAddress)) {
            return "";
        }
        if (vipAddress.startsWith("/")) {
            vipAddress = vipAddress.substring(1);
        }
        return vipAddress.replace("/", ".");
    }

    public static String getItemType(String itemType) {
        if (StringUtils.isEmpty((CharSequence)itemType)) {
            return AuditLogUtil.getDefaultItemType();
        }
        String serverName = itemType;
        Pattern p = Pattern.compile("\\$\\{(([a-zA-Z_$][a-zA-Z\\d_$]*\\.)*[a-zA-Z_$][a-zA-Z\\d_$]*)\\}");
        Matcher m = p.matcher(itemType);
        if (m.find()) {
            String content = m.group(1);
            serverName = ((Environment)SpringContextHolder.INSTANCE.getApplicationContext().getBean("environment", Environment.class)).getProperty(content);
            if (StringUtils.isEmpty((CharSequence)serverName)) {
                LOG.warn((Object)("\u83b7\u53d6\u5ba1\u8ba1\u9879\u7c7b\u578bID\u5931\u8d25\u3002auditItemType=" + itemType));
            }
            if (StringUtils.isNotEmpty((CharSequence)serverName) && serverName.contains("/")) {
                if (serverName.startsWith("/")) {
                    serverName = serverName.substring(1);
                }
                serverName = serverName.replace("/", ".");
            }
        }
        return serverName;
    }

    public static String getOperateType(AuditMethod auditMethod, Method method) {
        if (null == auditMethod && null == method) {
            LOG.warn((Object)"\u83b7\u53d6\u5ba1\u8ba1\u9879\u64cd\u4f5c\u7c7b\u578b\uff1aAuditMethod\u6ce8\u89e3\u4e3a\u7a7a\u6216Method\u4e3a\u7a7a\uff0c\u8fd4\u56de\u7a7a\u3002");
            return "";
        }
        if (null != auditMethod && StringUtils.isNotEmpty((CharSequence)auditMethod.operateType())) {
            return auditMethod.operateType();
        }
        String methodName = method.getName();
        if (methodName.indexOf("add") == 0 || methodName.indexOf("save") == 0 || methodName.indexOf("insert") == 0) {
            return "add";
        }
        if (methodName.indexOf("del") == 0) {
            return "delete";
        }
        if (methodName.indexOf("edit") == 0 || methodName.indexOf("alter") == 0 || methodName.indexOf("update") == 0) {
            return "edit";
        }
        if (methodName.indexOf("query") == 0 || methodName.indexOf("find") == 0 || methodName.indexOf("get") == 0) {
            return "query";
        }
        if (methodName.indexOf("upload") == 0) {
            return "unload";
        }
        if (methodName.indexOf("download") == 0) {
            return "download";
        }
        if (methodName.indexOf("import") == 0) {
            return "import";
        }
        if (methodName.indexOf("export") == 0) {
            return "export";
        }
        if (methodName.indexOf("stop") == 0) {
            return "stop";
        }
        if (methodName.indexOf("sta") == 0) {
            return "statisticalAnalysis";
        }
        if (methodName.indexOf("recover") == 0) {
            return "recover";
        }
        if (methodName.indexOf("approve") == 0) {
            return "approve";
        }
        if (methodName.indexOf("verify") == 0) {
            return "verify";
        }
        return "other";
    }

    public static String getEventStatus(boolean isSuccess) {
        if (isSuccess) {
            return "0";
        }
        return "1";
    }

    public static String getAuditItemId(Class<?> clazz, Method method, boolean isSuccess) {
        if (null == clazz || null == method) {
            LOG.warn((Object)"\u83b7\u53d6\u5ba1\u8ba1\u9879ID\uff1aclass\u6216method\u4e3a\u7a7a\uff0c\u8fd4\u56de\u7a7a\u3002");
            return "";
        }
        AuditItemLog auditClazzAnnotation = clazz.getAnnotation(AuditItemLog.class);
        AuditMethod auditMethodAnnotation = method.getAnnotation(AuditMethod.class);
        if (StringUtil.isNotEmpty((String)auditMethodAnnotation.auditItemId())) {
            return auditMethodAnnotation.auditItemId();
        }
        StringBuilder sb = new StringBuilder();
        String serverName = AuditLogUtil.getItemType(auditClazzAnnotation.auditItemType());
        String className = BeanCopyUtil.getClassSimpleName(clazz);
        String methodName = method.getName();
        sb.append(serverName).append("@").append(className).append("@").append(methodName);
        if (isSuccess) {
            sb.append(".success");
        } else {
            sb.append(".fail");
        }
        return sb.toString();
    }

    public static Object toReadableValue(AuditParam auditParamAnnotation, Object value) {
        String formatPattern = auditParamAnnotation.format();
        if (StringUtils.isNotEmpty((CharSequence)formatPattern) && value instanceof Date) {
            return BlockDateTimeUtil.formate((Date)value, formatPattern);
        }
        Class<?> clazz = auditParamAnnotation.transferUsing();
        if (clazz == Void.class) {
            if (value instanceof Date) {
                return BlockDateTimeUtil.formate((Date)value, "yyyy-MM-dd HH:mm:ss");
            }
            return value;
        }
        try {
            Object transferInstance = clazz.newInstance();
            if (transferInstance instanceof AuditParamTransfer) {
                AuditParamTransfer instance = (AuditParamTransfer)transferInstance;
                return instance.transfer(value);
            }
            return value;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return value;
        }
    }

    public static Object toReadableValue(AuditField auditFieldAnnotation, Object object, Field field) {
        String formatPattern = auditFieldAnnotation.format();
        if (StringUtils.isNotEmpty((CharSequence)formatPattern) && field.getType() == Date.class) {
            Date date = (Date)ObjectPropertyUtil.getValue(object, field.getName());
            return BlockDateTimeUtil.formate(date, formatPattern);
        }
        Class<?> clazz = auditFieldAnnotation.transferUsing();
        if (clazz == Void.class) {
            if (field.getType() == Date.class) {
                Date date = (Date)ObjectPropertyUtil.getValue(object, field.getName());
                return BlockDateTimeUtil.formate(date, "yyyy-MM-dd HH:mm:ss");
            }
            return ObjectPropertyUtil.getValue(object, field.getName());
        }
        try {
            Object transferInstance = clazz.newInstance();
            if (transferInstance instanceof AuditFieldTransfer) {
                AuditFieldTransfer instance = (AuditFieldTransfer)transferInstance;
                return instance.transfer(object, field);
            }
            return ObjectPropertyUtil.getValue(object, field.getName());
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return ObjectPropertyUtil.getValue(object, field.getName());
        }
    }

    public static String buildAuditText(int pageNo, int pageSize, String sort, String dsc, String json, Map<String, AuditDescribeDefinitionVO> fieldNameMap) {
        return "\u7b2c" + pageNo + "\u9875\uff0c\u6bcf\u9875" + pageSize + "\u884c\uff0c\u6392\u5e8f\u5b57\u6bb5" + sort + "\uff0c\u6392\u5e8f\u89c4\u5219" + dsc + AuditLogUtil.buildAuditText(json, fieldNameMap);
    }

    public static String buildAuditText(String json, Map<String, AuditDescribeDefinitionVO> fieldNameMap) {
        StringBuilder sb = new StringBuilder();
        JSONObject jsonObject = (JSONObject)JSONUtil.fromJsonString((String)json, JSONObject.class);
        for (Map.Entry<String, AuditDescribeDefinitionVO> entry : fieldNameMap.entrySet()) {
            AuditDescribeDefinitionVO definitionVO = entry.getValue();
            String fieldName = entry.getKey();
            String fieldText = definitionVO.getText();
            String fieldValue = AuditLogUtil.cover(definitionVO.getType(), jsonObject.getString(fieldName));
            if (!StringUtil.isNotEmptyString((String)fieldValue)) continue;
            sb.append(fieldText).append(":").append(fieldValue).append(",");
        }
        String result = sb.toString();
        if (result.endsWith(",")) {
            return result.substring(0, result.length() - 1);
        }
        return result + "\u3002";
    }

    public static String cover(AuditDescribeType type, String value) {
        if (type.isText()) {
            return value;
        }
        if (type.isCardNO()) {
            return value.replaceAll("(\\d{3})\\d{11}(\\w{4})", "$1*********$2");
        }
        if (type.isMovetel()) {
            return value.replaceAll("(\\d{3})\\d{6}(\\d{2})", "$1******$2");
        }
        if (type.isBankNO()) {
            return value.replaceAll("(\\d{3})\\d*(\\w{2})", "$1******$2");
        }
        if (type.isEmail()) {
            return value.replaceAll("(\\w{2})\\w+@(\\w+)", "$1***@$2");
        }
        if (type.isAddress()) {
            return value.replaceAll("\\d+", "*");
        }
        if (type.isBrithday()) {
            return value.replaceAll("(\\d{2})\\d*(\\d{2})", "$1*******$2");
        }
        if (type.isMoney()) {
            return "****";
        }
        return value;
    }

    public static void save(String auditItemId, String logContent) {
        block4: {
            PreconditionUtil.checkNotTrimEmpty(auditItemId, "auditItemId\u4e3a\u7a7a\u3002");
            PreconditionUtil.checkNotTrimEmpty(logContent, "logContent\u4e3a\u7a7a\u3002");
            try {
                AuditLogVO auditLogVO = new AuditLogVO();
                auditLogVO.setAuditItemId(auditItemId);
                auditLogVO.setLogContext(logContent);
                ILoginContext loginContext = LoginContextUtil.getLoginContext();
                if (!Objects.isNull(loginContext)) {
                    auditLogVO.setHostIp(loginContext.getIp());
                }
                if (PropertyConfigUtil.isActiveAuditLog()) {
                    String json = BlockJSONUtil.toEcpJson(auditLogVO);
                    MappServiceUtil.doPostReturnVoid(AUDIT_LOG_URL, json, AuditLogUtil.getEcpToken());
                }
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block4;
                LOG.warn((Object)"\u5ba1\u8ba1\u65e5\u5fd7\u5199\u5165\u5931\u8d25\u3002", (Throwable)e);
            }
        }
    }

    public static void saveAfterCommit(String auditItemId, String logContent) {
        AuditLogUtil.save(auditItemId, logContent);
    }

    @Deprecated
    public static void save(AuditLogVO auditLogVO) {
        PreconditionUtil.checkNotNull(auditLogVO, "auditLogVO\u4e3anull\u3002");
        if (PropertyConfigUtil.isActiveAuditLog()) {
            String json = BlockJSONUtil.toEcpJson(auditLogVO);
            MappServiceUtil.doPostReturnVoid(AUDIT_LOG_URL, json, AuditLogUtil.getEcpToken());
        }
    }

    private static String getEcpToken() {
        String ecpToken = null;
        ecpToken = TokenHolder.INSTANCE.getToken();
        if (StringUtil.isNotEmptyString((String)ecpToken)) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)String.format("\u624b\u52a8\u83b7\u53d6ecp_token=%s", ecpToken));
            }
            return ecpToken;
        }
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        ecpToken = request.getHeader(ECP_TOKEN_KEY);
        if (StringUtil.isNotEmptyString((String)ecpToken)) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)String.format("\u624b\u52a8\u83b7\u53d6ecp_token=%s", ecpToken));
            }
            return ecpToken;
        }
        ecpToken = request.getParameter(ECP_TOKEN_KEY);
        if (StringUtil.isNotEmptyString((String)ecpToken)) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)String.format("\u624b\u52a8\u83b7\u53d6ecp_token=%s", ecpToken));
            }
            return ecpToken;
        }
        return ecpToken;
    }

    public static class AuditLogBuilder {
        private AuditLogVO auditLogVO = this.newDefaultAuditLogVO();

        AuditLogBuilder(String auditItemId) {
            this.auditLogVO.setAuditItemId(auditItemId);
        }

        AuditLogVO newDefaultAuditLogVO() {
            AuditLogVO model = new AuditLogVO();
            model.setGid(UuidUtil.newUUID());
            model.setAppId("-1");
            model.setTenantId("-1");
            model.setHostType("PC");
            model.setHostIp(this.getHostIp());
            model.setOperator("4999");
            model.setOperateUnit("9999");
            model.setOperateTime(new Date());
            return model;
        }

        private String getHostIp() {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            if (null != request) {
                return CommonUtil.getRemortIP(request);
            }
            return "";
        }

        public AuditLogBuilder setTenantId(String tenantId) {
            PreconditionUtil.checkNotTrimEmpty(tenantId, "tenantId\u4e3a\u7a7a\u3002");
            this.auditLogVO.setTenantId(tenantId);
            return this;
        }

        public AuditLogBuilder setAppId(String appId) {
            PreconditionUtil.checkNotTrimEmpty(appId, "appId\u4e3a\u7a7a\u3002");
            this.auditLogVO.setAppId(appId);
            return this;
        }

        public AuditLogBuilder setLogContent(String logContent) {
            PreconditionUtil.checkNotTrimEmpty(logContent, "logContent\u4e3a\u7a7a\u3002");
            this.auditLogVO.setLogContext(logContent);
            return this;
        }

        public AuditLogBuilder setHostIp(String hostIp) {
            this.auditLogVO.setHostIp(hostIp);
            return this;
        }

        public AuditLogBuilder setHostMac(String hostMac) {
            this.auditLogVO.setHostMac(hostMac);
            return this;
        }

        public AuditLogBuilder setHostName(String hostName) {
            this.auditLogVO.setHostName(hostName);
            return this;
        }

        public AuditLogBuilder setHostType(String hostType) {
            this.auditLogVO.setHostType(hostType);
            return this;
        }

        public AuditLogBuilder setOperator(String operator) {
            this.auditLogVO.setOperator(operator);
            return this;
        }

        public AuditLogBuilder setOperateUnit(String operateUnit) {
            this.auditLogVO.setOperateUnit(operateUnit);
            return this;
        }

        public AuditLogBuilder setOperateTime(Date operateTime) {
            this.auditLogVO.setOperateTime(operateTime);
            return this;
        }

        public AuditLogVO build() {
            return this.auditLogVO;
        }
    }
}

