/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.ygsoft.abc.service.tool.CastUtil;
import com.ygsoft.ecp.service.exception.EcpCheckException;
import com.ygsoft.ecp.service.exception.EcpRuntimeException;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.necp.core.service.function.Objects;
import com.ygsoft.necp.core.service.model.IIdentifyModel;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import jersey.repackaged.com.google.common.collect.ImmutableMap;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.cglib.beans.BeanCopier;

public class BeanCopierUtil {
    private static final IEcpLog LOG = EcpLogFactory.getLog(BeanCopierUtil.class);
    private static final Map<String, BeanCopier> BEAN_COPIER_CACHE = Maps.newConcurrentMap();
    private static final String GET_GID = "getGid";
    private static final String SET_GID = "setGid";
    private static final String SET = "set";
    private static final Map<Class<?>, Integer> BASIC_TYPE_MAP = ImmutableMap.builder().put(Byte.TYPE, (Object)0).put(Byte.class, (Object)0).put(Short.TYPE, (Object)1).put(Short.class, (Object)1).put(Integer.TYPE, (Object)2).put(Integer.class, (Object)2).put(Long.TYPE, (Object)3).put(Long.class, (Object)3).put(Float.TYPE, (Object)4).put(Float.class, (Object)4).put(Double.TYPE, (Object)5).put(Double.class, (Object)5).put(Boolean.TYPE, (Object)6).put(Boolean.class, (Object)6).put(Character.TYPE, (Object)7).put(Character.class, (Object)7).build();
    private static final Pattern LONG_PATTERN = Pattern.compile("[0-9]{1,18}");

    public static <S, T> void copyProperty(S s, T t) {
        if (Objects.isNull(s) || Objects.isNull(t)) {
            throw new EcpCheckException("ABC.0001", "BEAN\u5c5e\u6027\u590d\u5236\u7684Source\u5bf9\u8c61\u6216Target\u5bf9\u8c61\u4e3a\u7a7a");
        }
        BeanCopier copier = BeanCopierUtil.getBeanCopier(s, t);
        copier.copy(s, t, BeanCopierUtil::convert);
        BeanCopierUtil.copyGid(s, t);
    }

    public static <S, T> void copyProperty(S s, T t, String[] ignoreProperties) {
        if (Objects.isNull(s) || Objects.isNull(t)) {
            throw new EcpCheckException("ABC.0001", "BEAN\u5c5e\u6027\u590d\u5236\u7684Source\u5bf9\u8c61\u6216Target\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (ignoreProperties == null || ignoreProperties.length == 0) {
            BeanCopierUtil.copyProperty(s, t);
            return;
        }
        List<String> ignoreList = Lists.newArrayList((Object[])ignoreProperties).stream().filter(it -> !Strings.isNullOrEmpty((String)it)).map(BeanCopierUtil::buildSetMethod).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ignoreList)) {
            BeanCopierUtil.copyProperty(s, t);
            return;
        }
        BeanCopier copier = BeanCopierUtil.getBeanCopier(s, t);
        copier.copy(s, t, (value, tClazz, context) -> {
            String setMethodName = CastUtil.getString(context);
            if (!Strings.isNullOrEmpty((String)setMethodName) && !ignoreList.contains(setMethodName.toLowerCase())) {
                return BeanCopierUtil.convert(value, tClazz, context);
            }
            return null;
        });
        if (!BeanCopierUtil.isIgnoreGid(ignoreList)) {
            BeanCopierUtil.copyGid(s, t);
        }
    }

    public static <S, T> T copyProperty(S s, Class<T> tClass, String[] ignoreProperties) {
        if (Objects.isNull(s) || Objects.isNull(tClass)) {
            throw new EcpCheckException("ABC.0001", "BEAN\u5c5e\u6027\u590d\u5236\u7684Source\u5bf9\u8c61\u6216tClass\u5bf9\u8c61\u4e3a\u7a7a");
        }
        try {
            T t = tClass.newInstance();
            BeanCopierUtil.copyProperty(s, t, ignoreProperties);
            return t;
        }
        catch (Exception e) {
            throw new EcpRuntimeException("ABC.0015", "\u5bf9\u8c61\u5c5e\u6027\u590d\u5236\u5f02\u5e38\u3002", (Throwable)e, new Object[0]);
        }
    }

    public static <S, T> T copyProperty(S s, Class<T> tClass) {
        if (Objects.isNull(s) || Objects.isNull(tClass)) {
            throw new EcpCheckException("ABC.0001", "BEAN\u5c5e\u6027\u590d\u5236\u7684Source\u5bf9\u8c61\u6216tClass\u5bf9\u8c61\u4e3a\u7a7a");
        }
        try {
            T t = tClass.newInstance();
            BeanCopierUtil.copyProperty(s, t);
            return t;
        }
        catch (Exception e) {
            throw new EcpRuntimeException("ABC.0015", "\u5bf9\u8c61\u5c5e\u6027\u590d\u5236\u5f02\u5e38\u3002", (Throwable)e, new Object[0]);
        }
    }

    private static Object convert(Object value, Class<?> tClazz, Object context) {
        if (value == null || tClazz == null) {
            return null;
        }
        Class<?> vClazz = value.getClass();
        if (BeanCopierUtil.isAlikeClass(vClazz, tClazz)) {
            return value;
        }
        if (BeanCopierUtil.isExtendsClass(vClazz, tClazz)) {
            return value;
        }
        if (tClazz == String.class) {
            return CastUtil.getString(value);
        }
        if (BeanCopierUtil.isStringToLong(vClazz, tClazz, value)) {
            return CastUtil.getLong(value);
        }
        return null;
    }

    private static boolean isExtendsClass(Class<?> vClazz, Class<?> tClazz) {
        return tClazz.isAssignableFrom(vClazz);
    }

    private static boolean isAlikeClass(Class<?> vClazz, Class<?> tClazz) {
        if (vClazz == tClazz) {
            return true;
        }
        return BASIC_TYPE_MAP.containsKey(vClazz) && BASIC_TYPE_MAP.containsKey(tClazz) && BASIC_TYPE_MAP.get(vClazz) == BASIC_TYPE_MAP.get(tClazz);
    }

    private static boolean isStringToLong(Class<?> vCalzz, Class<?> tCalzz, Object value) {
        if (vCalzz == String.class && tCalzz == Long.class) {
            String v = (String)value;
            return LONG_PATTERN.matcher(v).matches();
        }
        return false;
    }

    private static String getKey(Class<?> srcClazz, Class<?> tgtClazz) {
        return srcClazz.getName() + tgtClazz.getName();
    }

    private static <S, T> BeanCopier getBeanCopier(S s, T t) {
        String key = BeanCopierUtil.getKey(s.getClass(), t.getClass());
        if (BEAN_COPIER_CACHE.containsKey(key)) {
            return BEAN_COPIER_CACHE.get(key);
        }
        BeanCopier create = BeanCopier.create(s.getClass(), t.getClass(), (boolean)true);
        BEAN_COPIER_CACHE.put(key, create);
        return create;
    }

    private static <S, T> void copyGid(S s, T t) {
        if (t instanceof IIdentifyModel) {
            try {
                String gid;
                Object sourceGid = BeanCopierUtil.getSourceGid(s);
                if (Objects.isNull((Object)sourceGid)) {
                    return;
                }
                Type genType = t.getClass().getGenericSuperclass();
                Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
                Class tClazz = (Class)params[0];
                Method method = t.getClass().getMethod(SET_GID, Serializable.class);
                if (sourceGid.getClass() == tClazz) {
                    method.invoke(t, sourceGid);
                    return;
                }
                if (tClazz == String.class) {
                    method.invoke(t, CastUtil.getString(sourceGid));
                    return;
                }
                if (3 == BASIC_TYPE_MAP.get(tClazz) && sourceGid instanceof String && LONG_PATTERN.matcher(gid = (String)sourceGid).matches()) {
                    method.invoke(t, CastUtil.getLong(gid));
                }
            }
            catch (Exception e) {
                LOG.error((Object)"bean\u5c5e\u6027\u590d\u5236\u8fdb\u884cGID\u590d\u5236\u65f6\u5f02\u5e38", (Throwable)e);
                throw new EcpRuntimeException("ABC.0015", "bean\u5c5e\u6027\u590d\u5236\u8fdb\u884cGID\u590d\u5236\u65f6\u5f02\u5e38");
            }
        }
    }

    private static <S> Object getSourceGid(S s) throws Exception {
        Class<?> sClazz = s.getClass();
        Method[] methods = sClazz.getMethods();
        if (methods == null || methods.length < 1) {
            return null;
        }
        for (Method method : methods) {
            if (!GET_GID.equals(method.getName())) continue;
            return method.invoke(s, new Object[0]);
        }
        return null;
    }

    public static String buildSetMethod(String filedName) {
        if (Strings.isNullOrEmpty((String)filedName)) {
            return null;
        }
        return (SET + filedName).toLowerCase();
    }

    public static boolean isIgnoreGid(List<String> list) {
        return list.contains(SET_GID.toLowerCase());
    }
}

